/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.bson.Document;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class PartialIndexFilter
implements IndexFilter {
    private final Object filterExpression;

    private PartialIndexFilter(Object filterExpression) {
        Assert.notNull((Object)filterExpression, (String)"FilterExpression must not be null");
        this.filterExpression = filterExpression;
    }

    public static PartialIndexFilter of(Document where) {
        return new PartialIndexFilter(where);
    }

    public static PartialIndexFilter of(CriteriaDefinition where) {
        return new PartialIndexFilter(where);
    }

    @Override
    public Document getFilterObject() {
        if (this.filterExpression instanceof Document) {
            return (Document)this.filterExpression;
        }
        if (this.filterExpression instanceof CriteriaDefinition) {
            return ((CriteriaDefinition)this.filterExpression).getCriteriaObject();
        }
        throw new IllegalArgumentException(String.format("Unknown type %s used as filter expression", this.filterExpression.getClass()));
    }
}

