/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GeoJsonMultiPoint
implements GeoJson<Iterable<Point>> {
    private static final String TYPE = "MultiPoint";
    private final List<Point> points;

    public GeoJsonMultiPoint(Point point) {
        Assert.notNull((Object)point, (String)"Point must not be null");
        this.points = new ArrayList<Point>();
        this.points.add(point);
    }

    public GeoJsonMultiPoint(List<Point> points) {
        Assert.notNull(points, (String)"Points must not be null");
        Assert.notEmpty(points, (String)"Points must contain at least one point");
        this.points = new ArrayList<Point>(points);
    }

    public GeoJsonMultiPoint(Point first, Point second, Point ... others) {
        Assert.notNull((Object)first, (String)"First point must not be null");
        Assert.notNull((Object)second, (String)"Second point must not be null");
        Assert.notNull((Object)others, (String)"Additional points must not be null");
        this.points = new ArrayList<Point>();
        this.points.add(first);
        this.points.add(second);
        this.points.addAll(Arrays.asList(others));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public List<Point> getCoordinates() {
        return Collections.unmodifiableList(this.points);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.points);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoJsonMultiPoint)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.points, ((GeoJsonMultiPoint)obj).points);
    }
}

