/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class IndexField {
    private final String key;
    @Nullable
    private final Sort.Direction direction;
    private final Type type;
    private final Float weight;

    private IndexField(String key, @Nullable Sort.Direction direction, @Nullable Type type) {
        this(key, direction, type, Float.valueOf(Float.NaN));
    }

    private IndexField(String key, @Nullable Sort.Direction direction, @Nullable Type type, @Nullable Float weight) {
        Assert.hasText((String)key, (String)"Key must not be null or empty");
        if (Type.GEO.equals((Object)type) || Type.TEXT.equals((Object)type)) {
            Assert.isNull((Object)direction, (String)"Geo/Text indexes must not have a direction");
        } else if (!Type.HASH.equals((Object)type) && !Type.WILDCARD.equals((Object)type)) {
            Assert.notNull((Object)direction, (String)"Default indexes require a direction");
        }
        this.key = key;
        this.direction = direction;
        this.type = type == null ? Type.DEFAULT : type;
        this.weight = Float.valueOf(weight == null ? Float.NaN : weight.floatValue());
    }

    public static IndexField create(String key, Sort.Direction order) {
        Assert.notNull((Object)order, (String)"Direction must not be null");
        return new IndexField(key, order, Type.DEFAULT);
    }

    static IndexField hashed(String key) {
        return new IndexField(key, null, Type.HASH);
    }

    static IndexField wildcard(String key) {
        return new IndexField(key, null, Type.WILDCARD);
    }

    public static IndexField geo(String key) {
        return new IndexField(key, null, Type.GEO);
    }

    public static IndexField text(String key, Float weight) {
        return new IndexField(key, null, Type.TEXT, weight);
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public Sort.Direction getDirection() {
        return this.direction;
    }

    public boolean isGeo() {
        return Type.GEO.equals((Object)this.type);
    }

    public boolean isText() {
        return Type.TEXT.equals((Object)this.type);
    }

    public boolean isHashed() {
        return Type.HASH.equals((Object)this.type);
    }

    public boolean isWildcard() {
        return Type.WILDCARD.equals((Object)this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField that = (IndexField)obj;
        return this.key.equals(that.key) && ObjectUtils.nullSafeEquals((Object)this.direction, (Object)that.direction) && this.type == that.type;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.key);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.direction);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)((Object)this.type));
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.weight);
    }

    public String toString() {
        return String.format("IndexField [ key: %s, direction: %s, type: %s, weight: %s]", new Object[]{this.key, this.direction, this.type, this.weight});
    }

    static enum Type {
        GEO,
        TEXT,
        DEFAULT,
        HASH,
        WILDCARD;

    }
}

