/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.SystemVariable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class Fields
implements Iterable<Field> {
    private static final String AMBIGUOUS_EXCEPTION = "Found two fields both using '%s' as name: %s and %s; Please customize your field definitions to get to unique field names";
    public static final String UNDERSCORE_ID = "_id";
    public static final String UNDERSCORE_ID_REF = "$_id";
    private final List<Field> fields;

    public static Fields from(Field ... fields) {
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return new Fields(Arrays.asList(fields));
    }

    public static Fields fields(String ... names) {
        Assert.notNull((Object)names, (String)"Field names must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        for (String name : names) {
            fields.add(Fields.field(name));
        }
        return new Fields(fields);
    }

    public static Field field(String name) {
        return new AggregationField(name);
    }

    public static Field field(String name, String target) {
        Assert.hasText((String)target, (String)"Target must not be null or empty");
        return new AggregationField(name, target);
    }

    private Fields(List<Field> fields) {
        Assert.notNull(fields, (String)"Fields must not be null");
        this.fields = Fields.verify(fields);
    }

    private static List<Field> verify(List<Field> fields) {
        HashMap<String, Field> reference = new HashMap<String, Field>();
        for (Field field : fields) {
            String name = field.getName();
            Field found = (Field)reference.get(name);
            if (found != null) {
                throw new IllegalArgumentException(String.format(AMBIGUOUS_EXCEPTION, name, found, field));
            }
            reference.put(name, field);
        }
        return fields;
    }

    private Fields(Fields existing, Field tail) {
        this.fields = new ArrayList<Field>(existing.fields.size() + 1);
        this.fields.addAll(existing.fields);
        this.fields.add(tail);
    }

    public Fields and(String name) {
        return this.and(new AggregationField(name));
    }

    public Fields and(String name, String target) {
        return this.and(new AggregationField(name, target));
    }

    public Fields and(Field field) {
        return new Fields(this, field);
    }

    public Fields and(Fields fields) {
        Fields result = this;
        for (Field field : fields) {
            result = result.and(field);
        }
        return result;
    }

    public int size() {
        return this.fields.size();
    }

    @Nullable
    public Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    public List<Field> asList() {
        return Collections.unmodifiableList(this.fields);
    }

    static class AggregationField
    implements Field {
        private final String raw;
        private final String name;
        private final String target;

        public AggregationField(String name) {
            this(name, null);
        }

        public AggregationField(String name, @Nullable String target) {
            this.raw = name;
            String nameToSet = name != null ? AggregationField.cleanUp(name) : null;
            String targetToSet = target != null ? AggregationField.cleanUp(target) : null;
            Assert.hasText((String)nameToSet, (String)"AggregationField name must not be null or empty");
            if (target == null && name.contains(".")) {
                this.name = nameToSet.substring(nameToSet.indexOf(46) + 1);
                this.target = nameToSet;
            } else {
                this.name = nameToSet;
                this.target = targetToSet;
            }
        }

        private static String cleanUp(String source) {
            if (SystemVariable.isReferingToSystemVariable(source)) {
                return source;
            }
            int dollarIndex = source.lastIndexOf(36);
            return dollarIndex == -1 ? source : source.substring(dollarIndex + 1);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTarget() {
            if (this.isLocalVar() || this.pointsToDBRefId()) {
                return this.getRaw();
            }
            return StringUtils.hasText((String)this.target) ? this.target : this.name;
        }

        @Override
        public boolean isAliased() {
            return !this.getName().equals(this.getTarget());
        }

        @Override
        public boolean isInternal() {
            return this.getRaw().endsWith("$$this") || this.getRaw().endsWith("$$value");
        }

        public boolean isLocalVar() {
            return this.raw.startsWith("$$") && !this.raw.startsWith("$$$");
        }

        protected boolean pointsToDBRefId() {
            return this.raw.endsWith(".$id");
        }

        public String getRaw() {
            return this.raw;
        }

        public String toString() {
            return String.format("AggregationField - name: %s, target: %s", this.name, this.target);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AggregationField)) {
                return false;
            }
            AggregationField that = (AggregationField)obj;
            return this.name.equals(that.name) && ObjectUtils.nullSafeEquals((Object)this.target, (Object)that.target);
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.name.hashCode();
            return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.target);
        }
    }
}

