/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mongodb.BulkOperationException;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.mongodb.core.mapping.event.MongoMappingEvent;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultBulkOperations
implements BulkOperations {
    private final MongoOperations mongoOperations;
    private final String collectionName;
    private final BulkOperationContext bulkOperationContext;
    private final List<SourceAwareWriteModelHolder> models = new ArrayList<SourceAwareWriteModelHolder>();
    @Nullable
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;

    DefaultBulkOperations(MongoOperations mongoOperations, String collectionName, BulkOperationContext bulkOperationContext) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(bulkOperationContext.getBulkMode());
    }

    void setDefaultWriteConcern(@Nullable WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public BulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(document, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(document);
        this.addModel(source, (WriteModel<Document>)new InsertOneModel((Object)this.getMappedObject(source)));
        return this;
    }

    @Override
    public BulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null");
        documents.forEach(this::insert);
        return this;
    }

    @Override
    public BulkOperations updateOne(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        return this.updateOne(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateOne(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, false);
        }
        return this;
    }

    @Override
    public BulkOperations updateMulti(Query query, Update update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        return this.updateMulti(Collections.singletonList(Pair.of((Object)query, (Object)update)));
    }

    @Override
    public BulkOperations updateMulti(List<Pair<Query, Update>> updates) {
        Assert.notNull(updates, (String)"Updates must not be null");
        for (Pair<Query, Update> update : updates) {
            this.update((Query)update.getFirst(), (Update)update.getSecond(), false, true);
        }
        return this;
    }

    @Override
    public BulkOperations upsert(Query query, Update update) {
        return this.update(query, update, true, true);
    }

    @Override
    public BulkOperations upsert(List<Pair<Query, Update>> updates) {
        for (Pair<Query, Update> update : updates) {
            this.upsert((Query)update.getFirst(), (Update)update.getSecond());
        }
        return this;
    }

    @Override
    public BulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        DeleteOptions deleteOptions = new DeleteOptions();
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
        this.addModel(query, (WriteModel<Document>)new DeleteManyModel((Bson)query.getQueryObject(), deleteOptions));
        return this;
    }

    @Override
    public BulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public BulkOperations replaceOne(Query query, Object replacement, FindAndReplaceOptions options) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)replacement, (String)"Replacement must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        ReplaceOptions replaceOptions = new ReplaceOptions();
        replaceOptions.upsert(options.isUpsert());
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((ReplaceOptions)replaceOptions).collation(arg_0));
        this.maybeEmitEvent(new BeforeConvertEvent<Object>(replacement, this.collectionName));
        Object source = this.maybeInvokeBeforeConvertCallback(replacement);
        this.addModel(source, (WriteModel<Document>)new ReplaceOneModel(this.getMappedQuery((Bson)query.getQueryObject()), (Object)this.getMappedObject(source), replaceOptions));
        return this;
    }

    @Override
    public BulkWriteResult execute() {
        try {
            BulkWriteResult result = this.mongoOperations.execute(this.collectionName, this::bulkWriteTo);
            Assert.state((result != null ? 1 : 0) != 0, (String)"Result must not be null");
            this.models.forEach(this::maybeEmitAfterSaveEvent);
            this.models.forEach(this::maybeInvokeAfterSaveCallback);
            BulkWriteResult bulkWriteResult = result;
            return bulkWriteResult;
        }
        finally {
            this.bulkOptions = DefaultBulkOperations.getBulkWriteOptions(this.bulkOperationContext.getBulkMode());
        }
    }

    private BulkWriteResult bulkWriteTo(MongoCollection<Document> collection) {
        if (this.defaultWriteConcern != null) {
            collection = collection.withWriteConcern(this.defaultWriteConcern);
        }
        try {
            return collection.bulkWrite(this.models.stream().map(this::extractAndMapWriteModel).collect(Collectors.toList()), this.bulkOptions);
        }
        catch (RuntimeException ex) {
            if (ex instanceof MongoBulkWriteException) {
                MongoBulkWriteException mongoBulkWriteException = (MongoBulkWriteException)ex;
                if (mongoBulkWriteException.getWriteConcernError() != null) {
                    throw new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
                }
                throw new BulkOperationException(ex.getMessage(), mongoBulkWriteException);
            }
            throw ex;
        }
    }

    private WriteModel<Document> extractAndMapWriteModel(SourceAwareWriteModelHolder it) {
        this.maybeEmitBeforeSaveEvent(it);
        if (it.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)it.getModel()).getDocument();
            this.maybeInvokeBeforeSaveCallback(it.getSource(), target);
        } else if (it.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)it.getModel()).getReplacement();
            this.maybeInvokeBeforeSaveCallback(it.getSource(), target);
        }
        return this.mapWriteModel(it.getModel());
    }

    private BulkOperations update(Query query, Update update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        UpdateOptions options = DefaultBulkOperations.computeUpdateOptions(query, update, upsert);
        if (multi) {
            this.addModel(update, (WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        } else {
            this.addModel(update, (WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)update.getUpdateObject(), options));
        }
        return this;
    }

    private WriteModel<Document> mapWriteModel(WriteModel<Document> writeModel) {
        if (writeModel instanceof UpdateOneModel) {
            UpdateOneModel model = (UpdateOneModel)writeModel;
            return new UpdateOneModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof UpdateManyModel) {
            UpdateManyModel model = (UpdateManyModel)writeModel;
            return new UpdateManyModel(this.getMappedQuery(model.getFilter()), this.getMappedUpdate(model.getUpdate()), model.getOptions());
        }
        if (writeModel instanceof DeleteOneModel) {
            DeleteOneModel model = (DeleteOneModel)writeModel;
            return new DeleteOneModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        if (writeModel instanceof DeleteManyModel) {
            DeleteManyModel model = (DeleteManyModel)writeModel;
            return new DeleteManyModel(this.getMappedQuery(model.getFilter()), model.getOptions());
        }
        return writeModel;
    }

    private Bson getMappedUpdate(Bson update) {
        return ((QueryMapper)this.bulkOperationContext.getUpdateMapper()).getMappedObject(update, this.bulkOperationContext.getEntity());
    }

    private Bson getMappedQuery(Bson query) {
        return this.bulkOperationContext.getQueryMapper().getMappedObject(query, this.bulkOperationContext.getEntity());
    }

    private Document getMappedObject(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(source, sink);
        return sink;
    }

    private void addModel(Object source, WriteModel<Document> model) {
        this.models.add(new SourceAwareWriteModelHolder(source, model));
    }

    private void maybeEmitBeforeSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeEmitEvent(new BeforeSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        }
    }

    private void maybeEmitAfterSaveEvent(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeEmitEvent(new AfterSaveEvent<Object>(holder.getSource(), target, this.collectionName));
        }
    }

    private void maybeInvokeAfterSaveCallback(SourceAwareWriteModelHolder holder) {
        if (holder.getModel() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.getModel()).getDocument();
            this.maybeInvokeAfterSaveCallback(holder.getSource(), target);
        } else if (holder.getModel() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.getModel()).getReplacement();
            this.maybeInvokeAfterSaveCallback(holder.getSource(), target);
        }
    }

    private <E extends MongoMappingEvent<T>, T> E maybeEmitEvent(E event) {
        if (this.bulkOperationContext.getEventPublisher() == null) {
            return event;
        }
        this.bulkOperationContext.getEventPublisher().publishEvent(event);
        return event;
    }

    private Object maybeInvokeBeforeConvertCallback(Object value) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(BeforeConvertCallback.class, value, new Object[]{this.collectionName});
    }

    private Object maybeInvokeBeforeSaveCallback(Object value, Document mappedDocument) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(BeforeSaveCallback.class, value, new Object[]{mappedDocument, this.collectionName});
    }

    private Object maybeInvokeAfterSaveCallback(Object value, Document mappedDocument) {
        if (this.bulkOperationContext.getEntityCallbacks() == null) {
            return value;
        }
        return this.bulkOperationContext.getEntityCallbacks().callback(AfterSaveCallback.class, value, new Object[]{mappedDocument, this.collectionName});
    }

    private static BulkWriteOptions getBulkWriteOptions(BulkOperations.BulkMode bulkMode) {
        BulkWriteOptions options = new BulkWriteOptions();
        switch (bulkMode) {
            case ORDERED: {
                return options.ordered(true);
            }
            case UNORDERED: {
                return options.ordered(false);
            }
        }
        throw new IllegalStateException("BulkMode was null");
    }

    private static UpdateOptions computeUpdateOptions(Query filterQuery, UpdateDefinition update, boolean upsert) {
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        if (update.hasArrayFilters()) {
            ArrayList<Document> list = new ArrayList<Document>(update.getArrayFilters().size());
            for (UpdateDefinition.ArrayFilter arrayFilter : update.getArrayFilters()) {
                list.add(arrayFilter.asDocument());
            }
            options.arrayFilters(list);
        }
        filterQuery.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((UpdateOptions)options).collation(arg_0));
        return options;
    }

    static final class BulkOperationContext {
        private final BulkOperations.BulkMode bulkMode;
        private final Optional<? extends MongoPersistentEntity<?>> entity;
        private final QueryMapper queryMapper;
        private final UpdateMapper updateMapper;
        private final ApplicationEventPublisher eventPublisher;
        private final EntityCallbacks entityCallbacks;

        BulkOperationContext(BulkOperations.BulkMode bulkMode, Optional<? extends MongoPersistentEntity<?>> entity, QueryMapper queryMapper, UpdateMapper updateMapper, ApplicationEventPublisher eventPublisher, EntityCallbacks entityCallbacks) {
            this.bulkMode = bulkMode;
            this.entity = entity;
            this.queryMapper = queryMapper;
            this.updateMapper = updateMapper;
            this.eventPublisher = eventPublisher;
            this.entityCallbacks = entityCallbacks;
        }

        public BulkOperations.BulkMode getBulkMode() {
            return this.bulkMode;
        }

        public Optional<? extends MongoPersistentEntity<?>> getEntity() {
            return this.entity;
        }

        public QueryMapper getQueryMapper() {
            return this.queryMapper;
        }

        public UpdateMapper getUpdateMapper() {
            return this.updateMapper;
        }

        public ApplicationEventPublisher getEventPublisher() {
            return this.eventPublisher;
        }

        public EntityCallbacks getEntityCallbacks() {
            return this.entityCallbacks;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulkOperationContext that = (BulkOperationContext)o;
            if (this.bulkMode != that.bulkMode) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.entity, that.entity)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.queryMapper, (Object)that.queryMapper)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.updateMapper, (Object)that.updateMapper)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.eventPublisher, (Object)that.eventPublisher)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.entityCallbacks, (Object)that.entityCallbacks);
        }

        public int hashCode() {
            int result = this.bulkMode != null ? this.bulkMode.hashCode() : 0;
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.entity);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.queryMapper);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.updateMapper);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.eventPublisher);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.entityCallbacks);
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.BulkOperationContext(bulkMode=" + this.getBulkMode() + ", entity=" + this.getEntity() + ", queryMapper=" + this.getQueryMapper() + ", updateMapper=" + this.getUpdateMapper() + ", eventPublisher=" + this.getEventPublisher() + ", entityCallbacks=" + this.getEntityCallbacks() + ")";
        }
    }

    private static final class SourceAwareWriteModelHolder {
        private final Object source;
        private final WriteModel<Document> model;

        SourceAwareWriteModelHolder(Object source, WriteModel<Document> model) {
            this.source = source;
            this.model = model;
        }

        public Object getSource() {
            return this.source;
        }

        public WriteModel<Document> getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceAwareWriteModelHolder that = (SourceAwareWriteModelHolder)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.source, (Object)that.source)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.model, that.model);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.model);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.source);
            return result;
        }

        public String toString() {
            return "DefaultBulkOperations.SourceAwareWriteModelHolder(source=" + this.getSource() + ", model=" + this.getModel() + ")";
        }
    }
}

