/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.annotation.Reference;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.domain.Example;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoExampleMapper;
import org.springframework.data.mongodb.core.convert.MongoJsonSchemaMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.mongodb.util.DotPath;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryMapper {
    protected static final Log LOGGER = LogFactory.getLog(QueryMapper.class);
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private static final Document META_TEXT_SCORE = new Document("$meta", (Object)"textScore");
    static final ClassTypeInformation<?> NESTED_DOCUMENT = ClassTypeInformation.from(MappingMongoConverter.NestedDocument.class);
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoExampleMapper exampleMapper;
    private final MongoJsonSchemaMapper schemaMapper;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter, (String)"MongoConverter must not be null!");
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.exampleMapper = new MongoExampleMapper(converter);
        this.schemaMapper = new MongoJsonSchemaMapper(converter);
    }

    public Document getMappedObject(Bson query, Optional<? extends MongoPersistentEntity<?>> entity) {
        return this.getMappedObject(query, (MongoPersistentEntity<?>)entity.orElse(null));
    }

    public Document getMappedObject(Bson query, @Nullable MongoPersistentEntity<?> entity) {
        if (this.isNestedKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        Document result = new Document();
        for (String key : BsonUtils.asMap(query).keySet()) {
            if (Query.isRestrictedTypeKey(key)) {
                Set restrictedTypes = (Set)BsonUtils.get(query, key);
                this.converter.getTypeMapper().writeTypeRestrictions(result, restrictedTypes);
                continue;
            }
            if (this.isTypeKey(key)) {
                result.put(key, BsonUtils.get(query, key));
                continue;
            }
            if (this.isKeyword(key)) {
                result.putAll((Map)this.getMappedKeyword(new Keyword(query, key), entity));
                continue;
            }
            try {
                Field field = this.createPropertyField(entity, key, this.mappingContext);
                if (field.getProperty() != null && field.getProperty().isUnwrapped()) {
                    Object theNestedObject = BsonUtils.get(query, key);
                    Document mappedValue = (Document)this.getMappedValue(field, theNestedObject);
                    if (!StringUtils.hasText((String)field.getMappedKey())) {
                        result.putAll((Map)mappedValue);
                        continue;
                    }
                    result.put(field.getMappedKey(), (Object)mappedValue);
                    continue;
                }
                Map.Entry<String, Object> entry = this.getMappedObjectForField(field, BsonUtils.get(query, key));
                result.put(entry.getKey(), entry.getValue());
            }
            catch (InvalidPersistentPropertyPath invalidPathException) {
                if (!(BsonUtils.get(query, key) instanceof Document)) {
                    throw invalidPathException;
                }
                result.put(key, BsonUtils.get(query, key));
            }
        }
        return result;
    }

    public Document getMappedSort(Document sortObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)sortObject, (String)"SortObject must not be null!");
        if (sortObject.isEmpty()) {
            return BsonUtils.EMPTY_DOCUMENT;
        }
        Document mappedSort = this.mapFieldsToPropertyNames(sortObject, entity);
        return this.mapMetaAttributes(mappedSort, entity, MetaMapping.WHEN_PRESENT);
    }

    public Document getMappedFields(Document fieldsObject, @Nullable MongoPersistentEntity<?> entity) {
        Assert.notNull((Object)fieldsObject, (String)"FieldsObject must not be null!");
        Document mappedFields = this.mapFieldsToPropertyNames(fieldsObject, entity);
        return this.mapMetaAttributes(mappedFields, entity, MetaMapping.FORCE);
    }

    private Document mapFieldsToPropertyNames(Document fields, @Nullable MongoPersistentEntity<?> entity) {
        if (fields.isEmpty()) {
            return BsonUtils.EMPTY_DOCUMENT;
        }
        Document target = new Document();
        BsonUtils.asMap((Bson)this.filterUnwrappedObjects(fields, entity)).forEach((k, v) -> {
            Field field = this.createPropertyField(entity, (String)k, this.mappingContext);
            if (field.getProperty() != null && field.getProperty().isUnwrapped()) {
                return;
            }
            target.put(field.getMappedKey(), v);
        });
        return target;
    }

    public Document addMetaAttributes(Document source, @Nullable MongoPersistentEntity<?> entity) {
        return this.mapMetaAttributes(source, entity, MetaMapping.FORCE);
    }

    private Document mapMetaAttributes(Document source, @Nullable MongoPersistentEntity<?> entity, MetaMapping metaMapping) {
        if (entity == null) {
            return source;
        }
        if (entity.hasTextScoreProperty() && !MetaMapping.IGNORE.equals((Object)metaMapping)) {
            if (source == BsonUtils.EMPTY_DOCUMENT) {
                source = new Document();
            }
            MongoPersistentProperty textScoreProperty = entity.getTextScoreProperty();
            if (MetaMapping.FORCE.equals((Object)metaMapping) || MetaMapping.WHEN_PRESENT.equals((Object)metaMapping) && source.containsKey((Object)textScoreProperty.getFieldName())) {
                source.putAll((Map)this.getMappedTextScoreField(textScoreProperty));
            }
        }
        return source;
    }

    private Document filterUnwrappedObjects(Document fieldsObject, @Nullable MongoPersistentEntity<?> entity) {
        if (fieldsObject.isEmpty() || entity == null) {
            return fieldsObject;
        }
        Document target = new Document();
        for (Map.Entry field : fieldsObject.entrySet()) {
            try {
                PropertyPath path = PropertyPath.from((String)((String)field.getKey()), (TypeInformation)entity.getTypeInformation());
                PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(path);
                MongoPersistentProperty property = (MongoPersistentProperty)this.mappingContext.getPersistentPropertyPath(path).getRequiredLeafProperty();
                if (property.isUnwrapped() && property.isEntity()) {
                    MongoPersistentEntity unwrappedEntity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
                    Iterator iterator = unwrappedEntity.iterator();
                    while (iterator.hasNext()) {
                        MongoPersistentProperty unwrappedProperty = (MongoPersistentProperty)iterator.next();
                        DotPath dotPath = DotPath.from(persistentPropertyPath.toDotPath()).append(unwrappedProperty.getName());
                        target.put(dotPath.toString(), field.getValue());
                    }
                    continue;
                }
                target.put((String)field.getKey(), field.getValue());
            }
            catch (RuntimeException e) {
                target.put((String)field.getKey(), field.getValue());
            }
        }
        return target;
    }

    private Document getMappedTextScoreField(MongoPersistentProperty property) {
        return new Document(property.getFieldName(), (Object)META_TEXT_SCORE);
    }

    protected Map.Entry<String, Object> getMappedObjectForField(Field field, Object rawValue) {
        Object value;
        String key = field.getMappedKey();
        if (rawValue instanceof MongoExpression) {
            return this.createMapEntry(key, (Object)this.getMappedObject((Bson)((MongoExpression)rawValue).toDocument(), field.getEntity()));
        }
        if (this.isNestedKeyword(rawValue) && !field.isIdField()) {
            Keyword keyword = new Keyword((Bson)((Document)rawValue));
            value = this.getMappedKeyword(field, keyword);
        } else {
            value = this.getMappedValue(field, rawValue);
        }
        return this.createMapEntry(key, value);
    }

    protected Field createPropertyField(@Nullable MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        if (entity == null) {
            return new Field(key);
        }
        if ("_id".equals(key)) {
            return new MetadataBackedField(key, entity, mappingContext, (MongoPersistentProperty)entity.getIdProperty());
        }
        return new MetadataBackedField(key, entity, mappingContext);
    }

    protected Document getMappedKeyword(Keyword keyword, @Nullable MongoPersistentEntity<?> entity) {
        if (keyword.isOrOrNor() || keyword.hasIterableValue() && !keyword.isGeometry()) {
            Iterable conditions = (Iterable)keyword.getValue();
            ArrayList<Object> newConditions = conditions instanceof Collection ? new ArrayList<Object>(((Collection)conditions).size()) : new ArrayList();
            for (Object condition : conditions) {
                newConditions.add(this.isDocument(condition) ? this.getMappedObject((Bson)((Document)condition), entity) : this.convertSimpleOrDocument(condition, entity));
            }
            return new Document(keyword.getKey(), newConditions);
        }
        if (keyword.isSample()) {
            return this.exampleMapper.getMappedExample((Example)keyword.getValue(), entity);
        }
        if (keyword.isJsonSchema()) {
            return this.schemaMapper.mapSchema(new Document(keyword.getKey(), keyword.getValue()), entity != null ? entity.getType() : Object.class);
        }
        return new Document(keyword.getKey(), this.convertSimpleOrDocument(keyword.getValue(), entity));
    }

    protected Document getMappedKeyword(Field property, Keyword keyword) {
        Object convertedValue;
        boolean needsAssociationConversion = property.isAssociation() && !keyword.isExists() && keyword.mayHoldDbRef();
        Object value = keyword.getValue();
        Object object = convertedValue = needsAssociationConversion ? this.convertAssociation(value, property) : this.getMappedValue(property.with(keyword.getKey()), value);
        if (keyword.isSample() && convertedValue instanceof Document) {
            return (Document)convertedValue;
        }
        return new Document(keyword.key, convertedValue);
    }

    @Nullable
    protected Object getMappedValue(Field documentField, Object sourceValue) {
        Object value = this.applyFieldTargetTypeHintToValue(documentField, sourceValue);
        if (documentField.getProperty() != null && this.converter.getCustomConversions().getPropertyValueConversions().hasValueConverter((PersistentProperty)documentField.getProperty())) {
            return this.converter.getCustomConversions().getPropertyValueConversions().getValueConverter((PersistentProperty)documentField.getProperty()).write(value, (ValueConversionContext)new MongoConversionContext(documentField.getProperty(), this.converter));
        }
        if (documentField.isIdField() && !documentField.isAssociation()) {
            if (this.isDBObject(value)) {
                DBObject valueDbo = (DBObject)value;
                Document resultDbo = new Document(valueDbo.toMap());
                if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                    String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get(inKey)) {
                        ids.add(this.convertId(id, this.getIdTypeForField(documentField)));
                    }
                    resultDbo.put(inKey, ids);
                } else if (valueDbo.containsField("$ne")) {
                    resultDbo.put("$ne", this.convertId(valueDbo.get("$ne"), this.getIdTypeForField(documentField)));
                } else {
                    return this.getMappedObject((Bson)resultDbo, Optional.empty());
                }
                return resultDbo;
            }
            if (this.isDocument(value)) {
                Document valueDbo = (Document)value;
                Document resultDbo = new Document((Map)valueDbo);
                if (valueDbo.containsKey((Object)"$in") || valueDbo.containsKey((Object)"$nin")) {
                    String inKey = valueDbo.containsKey((Object)"$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get((Object)inKey)) {
                        ids.add(this.convertId(id, this.getIdTypeForField(documentField)));
                    }
                    resultDbo.put(inKey, ids);
                } else if (valueDbo.containsKey((Object)"$ne")) {
                    resultDbo.put("$ne", this.convertId(valueDbo.get((Object)"$ne"), this.getIdTypeForField(documentField)));
                } else {
                    return this.getMappedObject((Bson)resultDbo, Optional.empty());
                }
                return resultDbo;
            }
            return this.convertId(value, this.getIdTypeForField(documentField));
        }
        if (value == null) {
            return null;
        }
        if (this.isNestedKeyword(value)) {
            return this.getMappedKeyword(new Keyword((Bson)value), documentField.getPropertyEntity());
        }
        if (this.isAssociationConversionNecessary(documentField, value)) {
            return this.convertAssociation(value, documentField);
        }
        return this.convertSimpleOrDocument(value, documentField.getPropertyEntity());
    }

    private boolean isIdField(Field documentField) {
        return documentField.getProperty() != null && documentField.getProperty().isIdProperty();
    }

    private Class<?> getIdTypeForField(Field documentField) {
        return this.isIdField(documentField) ? documentField.getProperty().getFieldType() : ObjectId.class;
    }

    protected boolean isAssociationConversionNecessary(Field documentField, @Nullable Object value) {
        Assert.notNull((Object)documentField, (String)"Document field must not be null!");
        if (value == null) {
            return false;
        }
        if (!documentField.isAssociation()) {
            return false;
        }
        Class<?> type = value.getClass();
        MongoPersistentProperty property = documentField.getProperty();
        if (property.getActualType().isAssignableFrom(type)) {
            return true;
        }
        if (property.isDocumentReference()) {
            return true;
        }
        MongoPersistentEntity<?> entity = documentField.getPropertyEntity();
        return entity.hasIdProperty() && (type.equals(DBRef.class) || ((MongoPersistentProperty)entity.getRequiredIdProperty()).getActualType().isAssignableFrom(type));
    }

    @Nullable
    protected Object convertSimpleOrDocument(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (source instanceof Example) {
            return this.exampleMapper.getMappedExample((Example)source, entity);
        }
        if (source instanceof List) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDocument(source)) {
            return this.getMappedObject((Bson)((Document)source), entity);
        }
        if (source instanceof BasicDBList) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (this.isDBObject(source)) {
            return this.getMappedObject((Bson)((BasicDBObject)source), entity);
        }
        if (source instanceof BsonValue) {
            return source;
        }
        if (source instanceof Map) {
            LinkedHashMap map = new LinkedHashMap();
            ((Map)source).entrySet().forEach(it -> {
                String key = ObjectUtils.nullSafeToString((Object)this.converter.convertToMongoType(it.getKey()));
                if (it.getValue() instanceof Document) {
                    map.put(key, this.getMappedObject((Bson)((Document)it.getValue()), entity));
                } else {
                    map.put(key, this.delegateConvertToMongoType(it.getValue(), entity));
                }
            });
            return map;
        }
        return this.delegateConvertToMongoType(source, entity);
    }

    @Nullable
    protected Object delegateConvertToMongoType(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (entity != null && entity.isUnwrapped()) {
            return this.converter.convertToMongoType(source, entity);
        }
        return this.converter.convertToMongoType(source, entity == null ? null : entity.getTypeInformation());
    }

    protected Object convertAssociation(Object source, Field field) {
        Object value = this.convertAssociation(source, field.getProperty());
        if (value != null && field.isIdField() && field.getFieldType() != value.getClass()) {
            return this.convertId(value, field.getFieldType());
        }
        return value;
    }

    @Nullable
    protected Object convertAssociation(@Nullable Object source, @Nullable MongoPersistentProperty property) {
        if (property == null || source == null || source instanceof Document || source instanceof DBObject) {
            return source;
        }
        if (source instanceof DBRef) {
            DBRef ref = (DBRef)source;
            Object id = this.convertId(ref.getId(), property != null && property.isIdProperty() ? property.getFieldType() : ObjectId.class);
            if (StringUtils.hasText((String)ref.getDatabaseName())) {
                return new DBRef(ref.getDatabaseName(), ref.getCollectionName(), id);
            }
            return new DBRef(ref.getCollectionName(), id);
        }
        if (source instanceof Iterable) {
            BasicDBList result = new BasicDBList();
            for (Object element : (Iterable)source) {
                result.add(this.createReferenceFor(element, property));
            }
            return result;
        }
        if (property.isMap()) {
            Document result = new Document();
            Document dbObject = (Document)source;
            for (String key : dbObject.keySet()) {
                result.put(key, this.createReferenceFor(dbObject.get((Object)key), property));
            }
            return result;
        }
        return this.createReferenceFor(source, property);
    }

    protected final boolean isDocument(@Nullable Object value) {
        return value instanceof Document;
    }

    protected final boolean isDBObject(@Nullable Object value) {
        return value instanceof DBObject;
    }

    protected final Map.Entry<String, Object> createMapEntry(Field field, @Nullable Object value) {
        return this.createMapEntry(field.getMappedKey(), value);
    }

    private Map.Entry<String, Object> createMapEntry(String key, @Nullable Object value) {
        Assert.hasText((String)key, (String)"Key must not be null or empty!");
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    private Object createReferenceFor(Object source, MongoPersistentProperty property) {
        if (source instanceof DBRef) {
            return (DBRef)source;
        }
        if (property != null && (property.isDocumentReference() || !property.isDbReference() && property.findAnnotation(Reference.class) != null)) {
            return this.converter.toDocumentPointer(source, property).getPointer();
        }
        return this.converter.toDBRef(source, property);
    }

    @Nullable
    public Object convertId(@Nullable Object id) {
        return this.convertId(id, ObjectId.class);
    }

    @Nullable
    public Object convertId(@Nullable Object id, Class<?> targetType) {
        return this.converter.convertId(id, targetType);
    }

    protected boolean isNestedKeyword(@Nullable Object candidate) {
        if (!(candidate instanceof Document)) {
            return false;
        }
        Map<String, Object> map = BsonUtils.asMap((Bson)candidate);
        if (map.size() != 1) {
            return false;
        }
        return this.isKeyword(map.entrySet().iterator().next().getKey());
    }

    protected boolean isTypeKey(String key) {
        return this.converter.getTypeMapper().isTypeKey(key);
    }

    protected boolean isKeyword(String candidate) {
        return candidate.startsWith("$");
    }

    @Nullable
    private Object applyFieldTargetTypeHintToValue(Field documentField, @Nullable Object value) {
        if (value == null || documentField.getProperty() == null || !documentField.getProperty().hasExplicitWriteTarget() || value instanceof Document || value instanceof DBObject) {
            return value;
        }
        if (!this.conversionService.canConvert(value.getClass(), documentField.getProperty().getFieldType())) {
            return value;
        }
        if (value instanceof Collection) {
            Collection source = (Collection)value;
            ArrayList<Object> converted = new ArrayList<Object>(source.size());
            for (Object o : source) {
                converted.add(this.conversionService.convert(o, documentField.getProperty().getFieldType()));
            }
            return converted;
        }
        return this.conversionService.convert(value, documentField.getProperty().getFieldType());
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected static class AssociationConverter
    implements Converter<MongoPersistentProperty, String> {
        private final String name;
        private final MongoPersistentProperty property;
        private boolean associationFound;

        public AssociationConverter(String name, Association<MongoPersistentProperty> association) {
            Assert.notNull(association, (String)"Association must not be null!");
            this.property = (MongoPersistentProperty)association.getInverse();
            this.name = name;
        }

        public String convert(MongoPersistentProperty source) {
            if (this.associationFound) {
                return null;
            }
            if (this.property.equals(source)) {
                this.associationFound = true;
            }
            if (this.associationFound && this.name.endsWith("$") && this.property.isCollectionLike()) {
                return source.getFieldName() + ".$";
            }
            return source.getFieldName();
        }
    }

    protected static class MetadataBackedField
    extends Field {
        private static final Pattern POSITIONAL_PARAMETER_PATTERN = Pattern.compile("\\.\\$(\\[.*?\\])?");
        private static final Pattern DOT_POSITIONAL_PATTERN = Pattern.compile("\\.\\d+(?!$)");
        private static final String INVALID_ASSOCIATION_REFERENCE = "Invalid path reference %s! Associations can only be pointed to directly or via their id property!";
        private final MongoPersistentEntity<?> entity;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final MongoPersistentProperty property;
        @Nullable
        private final PersistentPropertyPath<MongoPersistentProperty> path;
        @Nullable
        private final Association<MongoPersistentProperty> association;

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            this(name, entity, context, null);
        }

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, @Nullable MongoPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(MetadataBackedField.removePlaceholders(POSITIONAL_PARAMETER_PATTERN, name), property);
            this.property = this.path == null ? property : (MongoPersistentProperty)this.path.getLeafProperty();
            this.association = this.findAssociation();
        }

        @Override
        public MetadataBackedField with(String name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public boolean isIdField() {
            if (this.property != null) {
                return this.property.isIdProperty();
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty != null) {
                return this.name.equals(idProperty.getName()) || this.name.equals(idProperty.getFieldName());
            }
            return DEFAULT_ID_NAMES.contains(this.name);
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.association == null ? this.property : (MongoPersistentProperty)this.association.getInverse();
        }

        @Override
        public MongoPersistentEntity<?> getPropertyEntity() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }

        @Override
        @Nullable
        public MongoPersistentEntity<?> getEntity() {
            return this.entity;
        }

        @Override
        public boolean isAssociation() {
            return this.association != null;
        }

        @Override
        public Association<MongoPersistentProperty> getAssociation() {
            return this.association;
        }

        @Nullable
        private Association<MongoPersistentProperty> findAssociation() {
            if (this.path != null) {
                for (MongoPersistentProperty p : this.path) {
                    Association association = p.getAssociation();
                    if (association == null) continue;
                    return association;
                }
            }
            return null;
        }

        @Override
        public Class<?> getFieldType() {
            return this.property.getFieldType();
        }

        @Override
        public String getMappedKey() {
            return this.path == null ? this.name : this.path.toDotPath(this.isAssociation() ? this.getAssociationConverter() : this.getPropertyConverter());
        }

        @Nullable
        protected PersistentPropertyPath<MongoPersistentProperty> getPath() {
            return this.path;
        }

        @Nullable
        private PersistentPropertyPath<MongoPersistentProperty> getPath(String pathExpression, @Nullable MongoPersistentProperty sourceProperty) {
            String rawPath = MetadataBackedField.removePlaceholders(POSITIONAL_OPERATOR, MetadataBackedField.removePlaceholders(DOT_POSITIONAL_PATTERN, pathExpression));
            if (sourceProperty != null && sourceProperty.getOwner().equals(this.entity)) {
                return this.mappingContext.getPersistentPropertyPath(PropertyPath.from((String)Pattern.quote(sourceProperty.getName()), (TypeInformation)this.entity.getTypeInformation()));
            }
            PropertyPath path = this.forName(rawPath);
            if (path == null || this.isPathToJavaLangClassProperty(path)) {
                return null;
            }
            PersistentPropertyPath<MongoPersistentProperty> propertyPath = this.tryToResolvePersistentPropertyPath(path);
            if (propertyPath == null) {
                if (LOGGER.isInfoEnabled()) {
                    String types = StringUtils.collectionToDelimitedString((Collection)path.stream().map(it -> it.getType().getSimpleName()).collect(Collectors.toList()), (String)" -> ");
                    LOGGER.info((Object)String.format("Could not map '%s'. Maybe a fragment in '%s' is considered a simple type. Mapper continues with %s.", path, types, pathExpression));
                }
                return null;
            }
            Iterator iterator = propertyPath.iterator();
            boolean associationDetected = false;
            while (iterator.hasNext()) {
                MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
                if (property.isAssociation()) {
                    associationDetected = true;
                    continue;
                }
                if (!associationDetected || property.isIdProperty()) continue;
                throw new MappingException(String.format(INVALID_ASSOCIATION_REFERENCE, pathExpression));
            }
            return propertyPath;
        }

        @Nullable
        private PersistentPropertyPath<MongoPersistentProperty> tryToResolvePersistentPropertyPath(PropertyPath path) {
            try {
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (MappingException e) {
                return null;
            }
        }

        @Nullable
        private PropertyPath forName(String path) {
            try {
                if (this.entity.getPersistentProperty(path) != null) {
                    return PropertyPath.from((String)Pattern.quote(path), (TypeInformation)this.entity.getTypeInformation());
                }
                return PropertyPath.from((String)path, (TypeInformation)this.entity.getTypeInformation());
            }
            catch (PropertyReferenceException | InvalidPersistentPropertyPath e) {
                if (path.endsWith("_id")) {
                    return this.forName(path.substring(0, path.length() - 3) + "id");
                }
                try {
                    return PropertyPath.from((String)Pattern.quote(path), (TypeInformation)this.entity.getTypeInformation());
                }
                catch (PropertyReferenceException | InvalidPersistentPropertyPath throwable) {
                    return null;
                }
            }
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return (path.getType() == Class.class || path.getType().equals(Object.class)) && path.getLeafProperty().getType() == Class.class;
        }

        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new PositionParameterRetainingPropertyKeyConverter(this.name, this.mappingContext);
        }

        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new AssociationConverter(this.name, this.getAssociation());
        }

        protected MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
            return this.mappingContext;
        }

        private static String removePlaceholders(Pattern pattern, String raw) {
            return pattern.matcher(raw).replaceAll("");
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            MongoPersistentProperty property = this.getProperty();
            if (property == null) {
                return super.getTypeHint();
            }
            if (property.getActualType().isInterface() || Modifier.isAbstract(property.getActualType().getModifiers())) {
                return ClassTypeInformation.OBJECT;
            }
            return NESTED_DOCUMENT;
        }

        static class KeyMapper {
            private final Iterator<String> iterator;
            private int currentIndex;
            private String currentPropertyRoot;
            private final List<String> pathParts;

            public KeyMapper(String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
                this.pathParts = Arrays.asList(key.split("\\."));
                this.iterator = this.pathParts.iterator();
                this.currentPropertyRoot = this.iterator.next();
                this.currentIndex = 0;
            }

            String nextToken() {
                return this.pathParts.get(this.currentIndex + 1);
            }

            boolean hasNexToken() {
                return this.pathParts.size() > this.currentIndex + 1;
            }

            protected String mapPropertyName(MongoPersistentProperty property) {
                StringBuilder mappedName = new StringBuilder(MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property));
                if (!this.hasNexToken()) {
                    return mappedName.toString();
                }
                String nextToken = this.nextToken();
                if (KeyMapper.isPositionalParameter(nextToken)) {
                    mappedName.append(".").append(nextToken);
                    this.currentIndex += 2;
                    return mappedName.toString();
                }
                if (property.isMap()) {
                    mappedName.append(".").append(nextToken);
                    this.currentIndex += 2;
                    return mappedName.toString();
                }
                ++this.currentIndex;
                return mappedName.toString();
            }

            static boolean isPositionalParameter(String partial) {
                if ("$".equals(partial)) {
                    return true;
                }
                Matcher matcher = Field.POSITIONAL_OPERATOR.matcher(partial);
                if (matcher.find()) {
                    return true;
                }
                try {
                    Long.valueOf(partial);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        static class PositionParameterRetainingPropertyKeyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final KeyMapper keyMapper;

            public PositionParameterRetainingPropertyKeyConverter(String rawKey, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> ctx) {
                this.keyMapper = new KeyMapper(rawKey, ctx);
            }

            public String convert(MongoPersistentProperty source) {
                return this.keyMapper.mapPropertyName(source);
            }
        }
    }

    protected static class Field {
        protected static final Pattern POSITIONAL_OPERATOR = Pattern.compile("\\$\\[.*\\]");
        private static final String ID_KEY = "_id";
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(String name) {
            return new Field(name);
        }

        public boolean isIdField() {
            return ID_KEY.equals(this.name);
        }

        @Nullable
        public MongoPersistentProperty getProperty() {
            return null;
        }

        @Nullable
        public MongoPersistentEntity<?> getPropertyEntity() {
            return null;
        }

        @Nullable
        MongoPersistentEntity<?> getEntity() {
            return null;
        }

        public boolean isAssociation() {
            return false;
        }

        public String getMappedKey() {
            return this.isIdField() ? ID_KEY : this.name;
        }

        public boolean containsAssociation() {
            return false;
        }

        @Nullable
        public Association<MongoPersistentProperty> getAssociation() {
            return null;
        }

        public boolean isMap() {
            return this.getProperty() != null && this.getProperty().isMap();
        }

        public TypeInformation<?> getTypeHint() {
            return ClassTypeInformation.OBJECT;
        }

        public Class<?> getFieldType() {
            return Object.class;
        }
    }

    static class Keyword {
        private static final Set<String> NON_DBREF_CONVERTING_KEYWORDS = new HashSet<String>(Arrays.asList("$", "$size", "$slice", "$gt", "$lt"));
        private final String key;
        private final Object value;

        public Keyword(Bson source, String key) {
            this.key = key;
            this.value = BsonUtils.get(source, key);
        }

        public Keyword(Bson bson) {
            Map<String, Object> map = BsonUtils.asMap(bson);
            Assert.isTrue((map.size() == 1 ? 1 : 0) != 0, (String)"Can only use a single value Document!");
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            Map.Entry<String, Object> entry = entries.iterator().next();
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public boolean isExists() {
            return "$exists".equalsIgnoreCase(this.key);
        }

        public boolean isOrOrNor() {
            return this.key.equalsIgnoreCase("$or") || this.key.equalsIgnoreCase("$nor");
        }

        public boolean isGeometry() {
            return "$geometry".equalsIgnoreCase(this.key);
        }

        public boolean isSample() {
            return "$example".equalsIgnoreCase(this.key);
        }

        public boolean hasIterableValue() {
            return this.value instanceof Iterable;
        }

        public String getKey() {
            return this.key;
        }

        public <T> T getValue() {
            return (T)this.value;
        }

        public boolean mayHoldDbRef() {
            return !NON_DBREF_CONVERTING_KEYWORDS.contains(this.key);
        }

        public boolean isJsonSchema() {
            return "$jsonSchema".equalsIgnoreCase(this.key);
        }
    }

    private static enum MetaMapping {
        FORCE,
        WHEN_PRESENT,
        IGNORE;

    }
}

