/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.encryption;

import java.util.UUID;
import java.util.function.Supplier;
import org.bson.Document;
import org.springframework.data.mongodb.util.spel.ExpressionUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class EncryptionUtils {
    @Nullable
    public static Object resolveKeyId(String value, Supplier<EvaluationContext> evaluationContext) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        Object potentialKeyId = value;
        Expression expression = ExpressionUtils.detectExpression(value);
        if (expression != null && !((potentialKeyId = expression.getValue(evaluationContext.get())) instanceof String)) {
            return potentialKeyId;
        }
        try {
            return UUID.fromString(potentialKeyId.toString());
        }
        catch (IllegalArgumentException e) {
            return Document.parse((String)("{ val : { $binary : { base64 : '" + potentialKeyId + "', subType : '04'} } }")).get((Object)"val");
        }
    }
}

