/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ArithmeticOperators;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.data.mongodb.core.aggregation.ConditionalOperators;
import org.springframework.data.mongodb.core.aggregation.DateOperators;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.LiteralOperators;
import org.springframework.data.mongodb.core.aggregation.SpelExpressionTransformer;
import org.springframework.data.mongodb.core.aggregation.StringOperators;
import org.springframework.data.mongodb.core.aggregation.VariableOperators;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ProjectionOperation
implements FieldsExposingAggregationOperation {
    private static final List<Projection> NONE = Collections.emptyList();
    private static final String EXCLUSION_ERROR = "Exclusion of field %s not allowed. Projections by the mongodb aggregation framework only support the exclusion of the %s field!";
    private final List<Projection> projections;

    public ProjectionOperation() {
        this(NONE, NONE);
    }

    public ProjectionOperation(Fields fields) {
        this(NONE, ProjectionOperationBuilder.FieldProjection.from(fields));
    }

    public ProjectionOperation(Class<?> type) {
        this(NONE, Collections.singletonList(new TypeProjection(type)));
    }

    private ProjectionOperation(List<? extends Projection> current, List<? extends Projection> projections) {
        Assert.notNull(current, (String)"Current projections must not be null!");
        Assert.notNull(projections, (String)"Projections must not be null!");
        this.projections = new ArrayList<Projection>(current.size() + projections.size());
        this.projections.addAll(current);
        this.projections.addAll(projections);
    }

    private ProjectionOperation and(Projection projection) {
        return new ProjectionOperation(this.projections, Collections.singletonList(projection));
    }

    private ProjectionOperation andReplaceLastOneWith(Projection projection) {
        List projections = this.projections.isEmpty() ? Collections.emptyList() : this.projections.subList(0, this.projections.size() - 1);
        return new ProjectionOperation(projections, Collections.singletonList(projection));
    }

    public ProjectionOperationBuilder and(String name) {
        return new ProjectionOperationBuilder(name, this, null);
    }

    public ExpressionProjectionOperationBuilder andExpression(String expression, Object ... params) {
        return new ExpressionProjectionOperationBuilder(expression, this, params);
    }

    public ProjectionOperationBuilder and(AggregationExpression expression) {
        return new ProjectionOperationBuilder(expression, this, null);
    }

    public ProjectionOperation andExclude(String ... fieldNames) {
        List<ProjectionOperationBuilder.FieldProjection> excludeProjections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), false);
        return new ProjectionOperation(this.projections, excludeProjections);
    }

    public ProjectionOperation andInclude(String ... fieldNames) {
        List<ProjectionOperationBuilder.FieldProjection> projections = ProjectionOperationBuilder.FieldProjection.from(Fields.fields(fieldNames), true);
        return new ProjectionOperation(this.projections, projections);
    }

    public ProjectionOperation andInclude(Fields fields) {
        return new ProjectionOperation(this.projections, ProjectionOperationBuilder.FieldProjection.from(fields, true));
    }

    public ProjectionOperation asArray(String name) {
        return new ProjectionOperation(Collections.emptyList(), Collections.singletonList(new ArrayProjection(Fields.field(name), this.projections)));
    }

    public ArrayProjectionOperationBuilder andArrayOf(Object ... values) {
        ArrayProjectionOperationBuilder builder = new ArrayProjectionOperationBuilder(this);
        for (Object value : values) {
            if (value instanceof Field) {
                builder.and((Field)value);
                continue;
            }
            if (value instanceof AggregationExpression) {
                builder.and((AggregationExpression)value);
                continue;
            }
            builder.and(value);
        }
        return builder;
    }

    @Override
    public ExposedFields getFields() {
        ExposedFields fields = null;
        for (Projection projection : this.projections) {
            ExposedFields.ExposedField field = projection.getExposedField();
            fields = fields == null ? ExposedFields.from(field) : fields.and(field);
        }
        return fields != null ? fields : ExposedFields.empty();
    }

    @Override
    public boolean inheritsFields() {
        return this.projections.stream().filter(ProjectionOperationBuilder.FieldProjection.class::isInstance).map(ProjectionOperationBuilder.FieldProjection.class::cast).anyMatch(ProjectionOperationBuilder.FieldProjection::isExcluded);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Document fieldObject = new Document();
        for (Projection projection : this.projections) {
            fieldObject.putAll((Map)projection.toDocument(context));
        }
        return new Document("$project", (Object)fieldObject);
    }

    static class ArrayProjection
    extends Projection {
        private final Field targetField;
        private final List<Object> projections;

        public ArrayProjection(Field targetField, List<Object> projections) {
            super(targetField);
            this.targetField = targetField;
            this.projections = projections;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document(this.targetField.getName(), this.projections.stream().map(it -> this.toArrayEntry(it, context)).collect(Collectors.toList()));
        }

        private Object toArrayEntry(Object projection, AggregationOperationContext ctx) {
            if (projection instanceof Field) {
                return ctx.getReference((Field)projection).toString();
            }
            if (projection instanceof AggregationExpression) {
                return ((AggregationExpression)projection).toDocument(ctx);
            }
            if (projection instanceof ProjectionOperationBuilder.FieldProjection) {
                return ctx.getReference(((ProjectionOperationBuilder.FieldProjection)projection).getExposedField().getTarget()).toString();
            }
            if (projection instanceof Projection) {
                ((Projection)projection).toDocument(ctx);
            }
            return projection;
        }
    }

    public static class ArrayProjectionOperationBuilder {
        private ProjectionOperation target;
        private final List<Object> projections;

        public ArrayProjectionOperationBuilder(ProjectionOperation target) {
            this.target = target;
            this.projections = new ArrayList<Object>();
        }

        public ArrayProjectionOperationBuilder and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"AggregationExpression must not be null!");
            this.projections.add(expression);
            return this;
        }

        public ArrayProjectionOperationBuilder and(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.projections.add(field);
            return this;
        }

        public ArrayProjectionOperationBuilder and(Object value) {
            this.projections.add(value);
            return this;
        }

        public ProjectionOperation as(String name) {
            return new ProjectionOperation(this.target.projections, Collections.singletonList(new ArrayProjection(Fields.field(name), this.projections)));
        }
    }

    static class TypeProjection
    extends Projection {
        private final Class<?> type;

        TypeProjection(Class<?> type) {
            super(Fields.field(type.getSimpleName()));
            this.type = type;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Document projections = new Document();
            Fields fields = context.getFields(this.type);
            fields.forEach(it -> projections.append(it.getName(), (Object)1));
            return context.getMappedObject(projections, this.type);
        }
    }

    static class ExpressionProjection
    extends Projection {
        private final AggregationExpression expression;
        private final Field field;

        public ExpressionProjection(Field field, AggregationExpression expression) {
            super(field);
            this.field = field;
            this.expression = expression;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document(this.field.getName(), (Object)this.expression.toDocument(context));
        }
    }

    private static abstract class Projection {
        private final ExposedFields.ExposedField field;

        public Projection(Field field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        public ExposedFields.ExposedField getExposedField() {
            return this.field;
        }

        public abstract Document toDocument(AggregationOperationContext var1);
    }

    public static class ProjectionOperationBuilder
    extends AbstractProjectionOperationBuilder {
        private static final String NUMBER_NOT_NULL = "Number must not be null!";
        private static final String FIELD_REFERENCE_NOT_NULL = "Field reference must not be null!";
        @Nullable
        private final String name;
        @Nullable
        private final OperationProjection previousProjection;

        public ProjectionOperationBuilder(String name, ProjectionOperation operation, @Nullable OperationProjection previousProjection) {
            super(name, operation);
            this.name = name;
            this.previousProjection = previousProjection;
        }

        protected ProjectionOperationBuilder(Object value, ProjectionOperation operation, @Nullable OperationProjection previousProjection) {
            super(value, operation);
            this.name = null;
            this.previousProjection = previousProjection;
        }

        public ProjectionOperation previousOperation() {
            return this.operation.andExclude("_id").and(new PreviousOperationProjection(this.getRequiredName()));
        }

        public ProjectionOperation nested(Fields fields) {
            return this.operation.and(new NestedFieldProjection(this.getRequiredName(), fields));
        }

        @Override
        public ProjectionOperation as(String alias) {
            if (this.previousProjection != null) {
                return this.operation.andReplaceLastOneWith(this.previousProjection.withAlias(alias));
            }
            if (this.value instanceof AggregationExpression) {
                return this.operation.and(new ExpressionProjection(Fields.field(alias, alias), (AggregationExpression)this.value));
            }
            return this.operation.and(new FieldProjection(Fields.field(alias, this.getRequiredName()), null));
        }

        @Override
        public ProjectionOperation applyCondition(ConditionalOperators.Cond cond) {
            Assert.notNull((Object)cond, (String)"ConditionalOperator must not be null!");
            return this.operation.and(new ExpressionProjection(Fields.field(this.getRequiredName()), cond));
        }

        @Override
        public ProjectionOperation applyCondition(ConditionalOperators.IfNull ifNull) {
            Assert.notNull((Object)ifNull, (String)"IfNullOperator must not be null!");
            return this.operation.and(new ExpressionProjection(Fields.field(this.getRequiredName()), ifNull));
        }

        public ProjectionOperationBuilder plus(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("add", number);
        }

        public ProjectionOperationBuilder plus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("add", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder minus(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("subtract", number);
        }

        public ProjectionOperationBuilder minus(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("subtract", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder minus(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.project("subtract", expression);
        }

        public ProjectionOperationBuilder multiply(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            return this.project("multiply", number);
        }

        public ProjectionOperationBuilder multiply(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("multiply", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder multiply(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.project("multiply", expression);
        }

        public ProjectionOperationBuilder divide(Number number) {
            Assert.notNull((Object)number, (String)FIELD_REFERENCE_NOT_NULL);
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("divide", number);
        }

        public ProjectionOperationBuilder divide(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("divide", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder divide(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.project("divide", expression);
        }

        public ProjectionOperationBuilder mod(Number number) {
            Assert.notNull((Object)number, (String)NUMBER_NOT_NULL);
            Assert.isTrue((Math.abs(number.intValue()) != 0 ? 1 : 0) != 0, (String)"Number must not be zero!");
            return this.project("mod", number);
        }

        public ProjectionOperationBuilder mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)FIELD_REFERENCE_NOT_NULL);
            return this.project("mod", Fields.field(fieldReference));
        }

        public ProjectionOperationBuilder mod(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return this.project("mod", expression);
        }

        public ProjectionOperationBuilder size() {
            return this.project("size", new Object[0]);
        }

        public ProjectionOperationBuilder cmp(Object compareValue) {
            return this.project("cmp", compareValue);
        }

        public ProjectionOperationBuilder eq(Object compareValue) {
            return this.project("eq", compareValue);
        }

        public ProjectionOperationBuilder gt(Object compareValue) {
            return this.project("gt", compareValue);
        }

        public ProjectionOperationBuilder gte(Object compareValue) {
            return this.project("gte", compareValue);
        }

        public ProjectionOperationBuilder lt(Object compareValue) {
            return this.project("lt", compareValue);
        }

        public ProjectionOperationBuilder lte(Object compareValue) {
            return this.project("lte", compareValue);
        }

        public ProjectionOperationBuilder ne(Object compareValue) {
            return this.project("ne", compareValue);
        }

        public ProjectionOperationBuilder slice(int count) {
            return this.project("slice", count);
        }

        public ProjectionOperationBuilder slice(int count, int offset) {
            return this.project("slice", offset, count);
        }

        public ProjectionOperationBuilder filter(String as, AggregationExpression condition) {
            return this.operation.and(ArrayOperators.Filter.filter(this.getRequiredName()).as(as).by(condition));
        }

        public ProjectionOperationBuilder equalsArrays(String ... arrays) {
            Assert.notEmpty((Object[])arrays, (String)"Arrays must not be null or empty!");
            return this.project("setEquals", Fields.fields(arrays));
        }

        public ProjectionOperationBuilder intersectsArrays(String ... arrays) {
            Assert.notEmpty((Object[])arrays, (String)"Arrays must not be null or empty!");
            return this.project("setIntersection", Fields.fields(arrays));
        }

        public ProjectionOperationBuilder unionArrays(String ... arrays) {
            Assert.notEmpty((Object[])arrays, (String)"Arrays must not be null or empty!");
            return this.project("setUnion", Fields.fields(arrays));
        }

        public ProjectionOperationBuilder differenceToArray(String array) {
            Assert.hasText((String)array, (String)"Array must not be null or empty!");
            return this.project("setDifference", Fields.fields(array));
        }

        public ProjectionOperationBuilder subsetOfArray(String array) {
            Assert.hasText((String)array, (String)"Array must not be null or empty!");
            return this.project("setIsSubset", Fields.fields(array));
        }

        public ProjectionOperationBuilder anyElementInArrayTrue() {
            return this.project("anyElementTrue", new Object[0]);
        }

        public ProjectionOperationBuilder allElementsInArrayTrue() {
            return this.project("allElementsTrue", new Object[0]);
        }

        public ProjectionOperationBuilder absoluteValue() {
            return this.operation.and(ArithmeticOperators.Abs.absoluteValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder ceil() {
            return this.operation.and(ArithmeticOperators.Ceil.ceilValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder exp() {
            return this.operation.and(ArithmeticOperators.Exp.expValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder floor() {
            return this.operation.and(ArithmeticOperators.Floor.floorValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder ln() {
            return this.operation.and(ArithmeticOperators.Ln.lnValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder log(String baseFieldRef) {
            return this.operation.and(ArithmeticOperators.Log.valueOf(this.getRequiredName()).log(baseFieldRef));
        }

        public ProjectionOperationBuilder log(Number base) {
            return this.operation.and(ArithmeticOperators.Log.valueOf(this.getRequiredName()).log(base));
        }

        public ProjectionOperationBuilder log(AggregationExpression base) {
            return this.operation.and(ArithmeticOperators.Log.valueOf(this.getRequiredName()).log(base));
        }

        public ProjectionOperationBuilder log10() {
            return this.operation.and(ArithmeticOperators.Log10.log10ValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder pow(String exponentFieldRef) {
            return this.operation.and(ArithmeticOperators.Pow.valueOf(this.getRequiredName()).pow(exponentFieldRef));
        }

        public ProjectionOperationBuilder pow(Number exponent) {
            return this.operation.and(ArithmeticOperators.Pow.valueOf(this.getRequiredName()).pow(exponent));
        }

        public ProjectionOperationBuilder pow(AggregationExpression exponentExpression) {
            return this.operation.and(ArithmeticOperators.Pow.valueOf(this.getRequiredName()).pow(exponentExpression));
        }

        public ProjectionOperationBuilder sqrt() {
            return this.operation.and(ArithmeticOperators.Sqrt.sqrtOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder trunc() {
            return this.operation.and(ArithmeticOperators.Trunc.truncValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder concat(Object ... values) {
            return this.project("concat", values);
        }

        public ProjectionOperationBuilder substring(int start) {
            return this.substring(start, -1);
        }

        public ProjectionOperationBuilder substring(int start, int nrOfChars) {
            return this.project("substr", start, nrOfChars);
        }

        public ProjectionOperationBuilder toLower() {
            return this.operation.and(StringOperators.ToLower.lowerValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder toUpper() {
            return this.operation.and(StringOperators.ToUpper.upperValueOf(this.getRequiredName()));
        }

        public ProjectionOperationBuilder strCaseCmp(String value) {
            return this.project("strcasecmp", value);
        }

        public ProjectionOperationBuilder strCaseCmpValueOf(String fieldRef) {
            return this.project("strcasecmp", fieldRef);
        }

        public ProjectionOperationBuilder strCaseCmp(AggregationExpression expression) {
            return this.project("strcasecmp", expression);
        }

        public ProjectionOperationBuilder arrayElementAt(int position) {
            return this.project("arrayElemAt", position);
        }

        public ProjectionOperationBuilder concatArrays(String ... fields) {
            return this.project("concatArrays", Fields.fields(fields));
        }

        public ProjectionOperationBuilder isArray() {
            return this.operation.and(ArrayOperators.IsArray.isArray(this.getRequiredName()));
        }

        public ProjectionOperationBuilder asLiteral() {
            return this.operation.and(LiteralOperators.Literal.asLiteral(this.getRequiredName()));
        }

        public ProjectionOperationBuilder dateAsFormattedString(String format) {
            return this.operation.and(DateOperators.DateToString.dateOf(this.getRequiredName()).toString(format));
        }

        public ProjectionOperationBuilder dateAsFormattedString() {
            return this.operation.and(DateOperators.DateToString.dateOf(this.getRequiredName()).defaultFormat());
        }

        public ProjectionOperationBuilder let(AggregationExpression valueExpression, String variableName, AggregationExpression in) {
            return this.operation.and(VariableOperators.Let.define(VariableOperators.Let.ExpressionVariable.newVariable(variableName).forExpression(valueExpression)).andApply(in));
        }

        public ProjectionOperationBuilder let(Collection<VariableOperators.Let.ExpressionVariable> variables, AggregationExpression in) {
            return this.operation.and(VariableOperators.Let.define(variables).andApply(in));
        }

        private String getRequiredName() {
            Assert.state((this.name != null ? 1 : 0) != 0, (String)"Projection field name must not be null!");
            return this.name;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return this.operation.toDocument(context);
        }

        public ProjectionOperationBuilder project(String operation, Object ... values) {
            OperationProjection operationProjection = new OperationProjection(Fields.field(this.value.toString()), operation, values);
            return new ProjectionOperationBuilder(this.value, this.operation.and(operationProjection), operationProjection);
        }

        public ProjectionOperationBuilder extractMinute() {
            return this.project("minute", new Object[0]);
        }

        public ProjectionOperationBuilder extractHour() {
            return this.project("hour", new Object[0]);
        }

        public ProjectionOperationBuilder extractSecond() {
            return this.project("second", new Object[0]);
        }

        public ProjectionOperationBuilder extractMillisecond() {
            return this.project("millisecond", new Object[0]);
        }

        public ProjectionOperationBuilder extractYear() {
            return this.project("year", new Object[0]);
        }

        public ProjectionOperationBuilder extractMonth() {
            return this.project("month", new Object[0]);
        }

        public ProjectionOperationBuilder extractWeek() {
            return this.project("week", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfYear() {
            return this.project("dayOfYear", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfMonth() {
            return this.project("dayOfMonth", new Object[0]);
        }

        public ProjectionOperationBuilder extractDayOfWeek() {
            return this.project("dayOfWeek", new Object[0]);
        }

        static class NestedFieldProjection
        extends Projection {
            private final String name;
            private final Fields fields;

            NestedFieldProjection(String name, Fields fields) {
                super(Fields.field(name));
                this.name = name;
                this.fields = fields;
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                Document nestedObject = new Document();
                for (Field field : this.fields) {
                    nestedObject.put(field.getName(), (Object)context.getReference(field.getTarget()).toString());
                }
                return new Document(this.name, (Object)nestedObject);
            }
        }

        static class OperationProjection
        extends Projection {
            private final Field field;
            private final String operation;
            private final List<Object> values;

            OperationProjection(Field field, String operation, Object[] values) {
                super(field);
                Assert.hasText((String)operation, (String)"Operation must not be null or empty!");
                Assert.notNull((Object)values, (String)"Values must not be null!");
                this.field = field;
                this.operation = operation;
                this.values = Arrays.asList(values);
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                Document inner = new Document("$" + this.operation, this.getOperationArguments(context));
                return new Document(this.getField().getName(), (Object)inner);
            }

            protected List<Object> getOperationArguments(AggregationOperationContext context) {
                ArrayList<Object> result = new ArrayList<Object>(this.values.size());
                result.add(context.getReference(this.getField()).toString());
                for (Object element : this.values) {
                    if (element instanceof Field) {
                        result.add(context.getReference((Field)element).toString());
                        continue;
                    }
                    if (element instanceof Fields) {
                        for (Field field : (Fields)element) {
                            result.add(context.getReference(field).toString());
                        }
                        continue;
                    }
                    if (element instanceof AggregationExpression) {
                        result.add(((AggregationExpression)element).toDocument(context));
                        continue;
                    }
                    result.add(element);
                }
                return result;
            }

            protected Field getField() {
                return this.field;
            }

            @Override
            public ExposedFields.ExposedField getExposedField() {
                if (!this.getField().isAliased()) {
                    return super.getExposedField();
                }
                return new ExposedFields.ExposedField(new Fields.AggregationField(this.getField().getName()), true);
            }

            OperationProjection withAlias(String alias) {
                final Field aliasedField = Fields.field(alias, this.field.getName());
                return new OperationProjection(aliasedField, this.operation, this.values.toArray()){

                    @Override
                    protected Field getField() {
                        return aliasedField;
                    }

                    @Override
                    protected List<Object> getOperationArguments(AggregationOperationContext context) {
                        return this.getOperationArguments(context);
                    }
                };
            }
        }

        static class FieldProjection
        extends Projection {
            private final Field field;
            @Nullable
            private final Object value;

            public FieldProjection(String name, Object value) {
                this(Fields.field(name), value);
            }

            private FieldProjection(Field field, @Nullable Object value) {
                super(new ExposedFields.ExposedField(field.getName(), true));
                this.field = field;
                this.value = value;
            }

            public static List<? extends Projection> from(Fields fields) {
                return FieldProjection.from(fields, null);
            }

            public static List<FieldProjection> from(Fields fields, @Nullable Object value) {
                Assert.notNull((Object)fields, (String)"Fields must not be null!");
                ArrayList<FieldProjection> projections = new ArrayList<FieldProjection>();
                for (Field field : fields) {
                    projections.add(new FieldProjection(field, value));
                }
                return projections;
            }

            public boolean isExcluded() {
                return Boolean.FALSE.equals(this.value);
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                return new Document(this.field.getName(), this.renderFieldValue(context));
            }

            private Object renderFieldValue(AggregationOperationContext context) {
                if (this.value == null || Boolean.TRUE.equals(this.value)) {
                    if (Aggregation.SystemVariable.isReferingToSystemVariable(this.field.getTarget())) {
                        return this.field.getTarget();
                    }
                    return context.getReference(this.field).getReferenceValue();
                }
                if (Boolean.FALSE.equals(this.value)) {
                    return 0;
                }
                return this.value;
            }
        }

        static class PreviousOperationProjection
        extends Projection {
            private final String name;

            public PreviousOperationProjection(String name) {
                super(Fields.field(name));
                this.name = name;
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                return new Document(this.name, (Object)"$_id");
            }
        }
    }

    public static class ExpressionProjectionOperationBuilder
    extends ProjectionOperationBuilder {
        private final Object[] params;
        private final String expression;

        public ExpressionProjectionOperationBuilder(String expression, ProjectionOperation operation, Object[] parameters) {
            super(expression, operation, null);
            this.expression = expression;
            this.params = (Object[])parameters.clone();
        }

        @Override
        public ProjectionOperationBuilder project(String operation, final Object ... values) {
            ProjectionOperationBuilder.OperationProjection operationProjection = new ProjectionOperationBuilder.OperationProjection(Fields.field(this.value.toString()), operation, values){

                @Override
                protected List<Object> getOperationArguments(AggregationOperationContext context) {
                    ArrayList<Object> result = new ArrayList<Object>(values.length + 1);
                    result.add(ExpressionProjection.toMongoExpression(context, expression, params));
                    result.addAll(Arrays.asList(values));
                    return result;
                }
            };
            return new ProjectionOperationBuilder(this.value, this.operation.and(operationProjection), operationProjection);
        }

        @Override
        public ProjectionOperation as(String alias) {
            Field expressionField = Fields.field(alias, alias);
            return this.operation.and(new ExpressionProjection(expressionField, this.value.toString(), this.params));
        }

        static class ExpressionProjection
        extends Projection {
            private static final SpelExpressionTransformer TRANSFORMER = new SpelExpressionTransformer();
            private final String expression;
            private final Object[] params;

            public ExpressionProjection(Field field, String expression, Object[] parameters) {
                super(field);
                Assert.hasText((String)expression, (String)"Expression must not be null!");
                Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
                this.expression = expression;
                this.params = (Object[])parameters.clone();
            }

            @Override
            public Document toDocument(AggregationOperationContext context) {
                return new Document(this.getExposedField().getName(), ExpressionProjection.toMongoExpression(context, this.expression, this.params));
            }

            protected static Object toMongoExpression(AggregationOperationContext context, String expression, Object[] params) {
                return TRANSFORMER.transform(expression, context, params);
            }
        }
    }

    private static abstract class AbstractProjectionOperationBuilder
    implements AggregationOperation {
        protected final Object value;
        protected final ProjectionOperation operation;

        public AbstractProjectionOperationBuilder(Object value, ProjectionOperation operation) {
            Assert.notNull((Object)value, (String)"value must not be null or empty!");
            Assert.notNull((Object)operation, (String)"ProjectionOperation must not be null!");
            this.value = value;
            this.operation = operation;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return this.operation.toDocument(context);
        }

        public abstract ProjectionOperation as(String var1);

        public abstract ProjectionOperation applyCondition(ConditionalOperators.Cond var1);

        public abstract ProjectionOperation applyCondition(ConditionalOperators.IfNull var1);
    }
}

