/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.util.Optionals;

public class GridFsResource
extends InputStreamResource {
    static final String CONTENT_TYPE_FIELD = "_contentType";
    private final GridFSFile file;

    public GridFsResource(GridFSFile file) {
        this(file, new ByteArrayInputStream(new byte[0]));
    }

    public GridFsResource(GridFSFile file, InputStream inputStream) {
        super(inputStream);
        this.file = file;
    }

    public long contentLength() throws IOException {
        return this.file.getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.file.getFilename();
    }

    public long lastModified() throws IOException {
        return this.file.getUploadDate().getTime();
    }

    public Object getId() {
        return this.file.getId();
    }

    public String getContentType() {
        return (String)Optionals.firstNonEmpty((Supplier[])new Supplier[]{() -> Optional.ofNullable(this.file.getMetadata()).map(it -> (String)it.get((Object)CONTENT_TYPE_FIELD, String.class)), () -> Optional.ofNullable(this.file.getContentType())}).orElseThrow(() -> new MongoGridFSException("No contentType data for this GridFS file"));
    }
}

