/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class AggregationUtil {
    QueryMapper queryMapper;
    MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    AggregationOperationContext prepareAggregationContext(Aggregation aggregation, @Nullable AggregationOperationContext context) {
        if (context != null) {
            return context;
        }
        if (aggregation instanceof TypedAggregation) {
            return new TypeBasedAggregationOperationContext(((TypedAggregation)aggregation).getInputType(), this.mappingContext, this.queryMapper);
        }
        return Aggregation.DEFAULT_CONTEXT;
    }

    Document createPipeline(String collectionName, Aggregation aggregation, AggregationOperationContext context) {
        if (!ObjectUtils.nullSafeEquals((Object)context, (Object)Aggregation.DEFAULT_CONTEXT)) {
            return aggregation.toDocument(collectionName, context);
        }
        Document command = aggregation.toDocument(collectionName, context);
        command.put("pipeline", this.mapAggregationPipeline((List)command.get((Object)"pipeline", List.class)));
        return command;
    }

    Document createCommand(String collection, Aggregation aggregation, AggregationOperationContext context) {
        Document command = aggregation.toDocument(collection, context);
        if (!ObjectUtils.nullSafeEquals((Object)context, (Object)Aggregation.DEFAULT_CONTEXT)) {
            return command;
        }
        command.put("pipeline", this.mapAggregationPipeline((List)command.get((Object)"pipeline", List.class)));
        return command;
    }

    private List<Document> mapAggregationPipeline(List<Document> pipeline) {
        return pipeline.stream().map(val -> this.queryMapper.getMappedObject((Bson)val, Optional.empty())).collect(Collectors.toList());
    }

    public AggregationUtil(QueryMapper queryMapper, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.queryMapper = queryMapper;
        this.mappingContext = mappingContext;
    }
}

