/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import java.beans.ConstructorProperties;
import java.util.Locale;
import java.util.Optional;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Collation {
    private static final Collation SIMPLE = Collation.of("simple");
    private final CollationLocale locale;
    private Optional<ComparisonLevel> strength = Optional.empty();
    private Optional<Boolean> numericOrdering = Optional.empty();
    private Optional<Alternate> alternate = Optional.empty();
    private Optional<Boolean> backwards = Optional.empty();
    private Optional<Boolean> normalization = Optional.empty();
    private Optional<String> version = Optional.empty();

    private Collation(CollationLocale locale) {
        Assert.notNull((Object)locale, (String)"ICULocale must not be null!");
        this.locale = locale;
    }

    public static Collation simple() {
        return SIMPLE;
    }

    public static Collation of(Locale locale) {
        Assert.notNull((Object)locale, (String)"Locale must not be null!");
        String format = StringUtils.hasText((String)locale.getCountry()) ? String.format("%s_%s", locale.getLanguage(), locale.getCountry()) : locale.getLanguage();
        return Collation.of(CollationLocale.of(format).variant(locale.getVariant()));
    }

    public static Collation of(String language) {
        return Collation.of(CollationLocale.of(language));
    }

    public static Collation of(CollationLocale locale) {
        return new Collation(locale);
    }

    public static Collation from(Document source) {
        Assert.notNull((Object)source, (String)"Source must not be null!");
        Collation collation = Collation.of(source.getString((Object)"locale"));
        if (source.containsKey((Object)"strength")) {
            collation = collation.strength(source.getInteger((Object)"strength"));
        }
        if (source.containsKey((Object)"caseLevel")) {
            collation = collation.caseLevel(source.getBoolean((Object)"caseLevel"));
        }
        if (source.containsKey((Object)"caseFirst")) {
            collation = collation.caseFirst(source.getString((Object)"caseFirst"));
        }
        if (source.containsKey((Object)"numericOrdering")) {
            collation = collation.numericOrdering(source.getBoolean((Object)"numericOrdering"));
        }
        if (source.containsKey((Object)"alternate")) {
            collation = collation.alternate(source.getString((Object)"alternate"));
        }
        if (source.containsKey((Object)"maxVariable")) {
            collation = collation.maxVariable(source.getString((Object)"maxVariable"));
        }
        if (source.containsKey((Object)"backwards")) {
            collation = collation.backwards(source.getBoolean((Object)"backwards"));
        }
        if (source.containsKey((Object)"normalization")) {
            collation = collation.normalization(source.getBoolean((Object)"normalization"));
        }
        if (source.containsKey((Object)"version")) {
            collation.version = Optional.of(source.get((Object)"version").toString());
        }
        return collation;
    }

    public Collation strength(int strength) {
        ComparisonLevel current = this.strength.orElseGet(() -> new ICUComparisonLevel(strength));
        return this.strength(new ICUComparisonLevel(strength, current.getCaseFirst(), current.getCaseLevel()));
    }

    public Collation strength(ComparisonLevel comparisonLevel) {
        Collation newInstance = this.copy();
        newInstance.strength = Optional.of(comparisonLevel);
        return newInstance;
    }

    public Collation caseLevel(boolean caseLevel) {
        ComparisonLevel strengthValue = this.strength.orElseGet(ComparisonLevel::primary);
        return this.strength(new ICUComparisonLevel(strengthValue.getLevel(), strengthValue.getCaseFirst(), Optional.of(caseLevel)));
    }

    public Collation caseFirst(String caseFirst) {
        return this.caseFirst(new CaseFirst(caseFirst));
    }

    public Collation caseFirst(CaseFirst sort) {
        ComparisonLevel strengthValue = this.strength.orElseGet(ComparisonLevel::tertiary);
        return this.strength(new ICUComparisonLevel(strengthValue.getLevel(), Optional.of(sort), strengthValue.getCaseLevel()));
    }

    public Collation numericOrderingEnabled() {
        return this.numericOrdering(true);
    }

    public Collation numericOrderingDisabled() {
        return this.numericOrdering(false);
    }

    public Collation numericOrdering(boolean flag) {
        Collation newInstance = this.copy();
        newInstance.numericOrdering = Optional.of(flag);
        return newInstance;
    }

    public Collation alternate(String alternate) {
        Alternate instance = this.alternate.orElseGet(() -> new Alternate(alternate, Optional.empty()));
        return this.alternate(new Alternate(alternate, instance.maxVariable));
    }

    public Collation alternate(Alternate alternate) {
        Collation newInstance = this.copy();
        newInstance.alternate = Optional.of(alternate);
        return newInstance;
    }

    public Collation backwardDiacriticSort() {
        return this.backwards(true);
    }

    public Collation forwardDiacriticSort() {
        return this.backwards(false);
    }

    public Collation backwards(boolean backwards) {
        Collation newInstance = this.copy();
        newInstance.backwards = Optional.of(backwards);
        return newInstance;
    }

    public Collation normalizationEnabled() {
        return this.normalization(true);
    }

    public Collation normalizationDisabled() {
        return this.normalization(false);
    }

    public Collation normalization(boolean normalization) {
        Collation newInstance = this.copy();
        newInstance.normalization = Optional.of(normalization);
        return newInstance;
    }

    public Collation maxVariable(String maxVariable) {
        Alternate alternateValue = this.alternate.orElseGet(Alternate::shifted);
        return this.alternate(new AlternateWithMaxVariable(alternateValue.alternate, maxVariable));
    }

    public Document toDocument() {
        return this.map(Collation.toMongoDocumentConverter());
    }

    public com.mongodb.client.model.Collation toMongoCollation() {
        return this.map(Collation.toMongoCollationConverter());
    }

    public <R> R map(Converter<? super Collation, ? extends R> mapper) {
        return (R)mapper.convert((Object)this);
    }

    public String toString() {
        return this.toDocument().toJson();
    }

    private Collation copy() {
        Collation collation = new Collation(this.locale);
        collation.strength = this.strength;
        collation.normalization = this.normalization;
        collation.numericOrdering = this.numericOrdering;
        collation.alternate = this.alternate;
        collation.backwards = this.backwards;
        return collation;
    }

    private static Converter<Collation, Document> toMongoDocumentConverter() {
        return source -> {
            Document document = new Document();
            document.append("locale", (Object)source.locale.asString());
            source.strength.ifPresent(strength -> {
                document.append("strength", (Object)strength.getLevel());
                strength.getCaseLevel().ifPresent(it -> document.append("caseLevel", it));
                strength.getCaseFirst().ifPresent(it -> document.append("caseFirst", (Object)((CaseFirst)it).state));
            });
            source.numericOrdering.ifPresent(val -> document.append("numericOrdering", val));
            source.alternate.ifPresent(it -> {
                document.append("alternate", (Object)it.alternate);
                it.maxVariable.ifPresent(maxVariable -> document.append("maxVariable", maxVariable));
            });
            source.backwards.ifPresent(it -> document.append("backwards", it));
            source.normalization.ifPresent(it -> document.append("normalization", it));
            source.version.ifPresent(it -> document.append("version", it));
            return document;
        };
    }

    private static Converter<Collation, com.mongodb.client.model.Collation> toMongoCollationConverter() {
        return source -> {
            Collation.Builder builder = com.mongodb.client.model.Collation.builder();
            builder.locale(source.locale.asString());
            source.strength.ifPresent(strength -> {
                builder.collationStrength(CollationStrength.fromInt((int)strength.getLevel()));
                strength.getCaseLevel().ifPresent(arg_0 -> ((Collation.Builder)builder).caseLevel(arg_0));
                strength.getCaseFirst().ifPresent(it -> builder.collationCaseFirst(CollationCaseFirst.fromString((String)((CaseFirst)it).state)));
            });
            source.numericOrdering.ifPresent(arg_0 -> ((Collation.Builder)builder).numericOrdering(arg_0));
            source.alternate.ifPresent(it -> {
                builder.collationAlternate(CollationAlternate.fromString((String)it.alternate));
                it.maxVariable.ifPresent(maxVariable -> builder.collationMaxVariable(CollationMaxVariable.fromString((String)maxVariable)));
            });
            source.backwards.ifPresent(arg_0 -> ((Collation.Builder)builder).backwards(arg_0));
            source.normalization.ifPresent(arg_0 -> ((Collation.Builder)builder).normalization(arg_0));
            return builder.build();
        };
    }

    public static class CollationLocale {
        private final String language;
        private final Optional<String> variant;

        public static CollationLocale of(String language) {
            Assert.notNull((Object)language, (String)"Code must not be null!");
            return new CollationLocale(language, Optional.empty());
        }

        public CollationLocale variant(String variant) {
            Assert.notNull((Object)variant, (String)"Variant must not be null!");
            return new CollationLocale(this.language, Optional.of(variant));
        }

        public String asString() {
            StringBuilder sb = new StringBuilder(this.language);
            this.variant.filter(it -> !it.isEmpty()).ifPresent(val -> sb.append("@collation=").append((String)val));
            return sb.toString();
        }

        @ConstructorProperties(value={"language", "variant"})
        private CollationLocale(String language, Optional<String> variant) {
            this.language = language;
            this.variant = variant;
        }
    }

    public static class AlternateWithMaxVariable
    extends Alternate {
        static final AlternateWithMaxVariable DEFAULT = new AlternateWithMaxVariable("shifted");
        static final Alternate SHIFTED_PUNCT = new AlternateWithMaxVariable("shifted", "punct");
        static final Alternate SHIFTED_SPACE = new AlternateWithMaxVariable("shifted", "space");

        private AlternateWithMaxVariable(String alternate) {
            super(alternate, Optional.empty());
        }

        private AlternateWithMaxVariable(String alternate, String maxVariable) {
            super(alternate, Optional.of(maxVariable));
        }

        public Alternate punct() {
            return SHIFTED_PUNCT;
        }

        public Alternate space() {
            return SHIFTED_SPACE;
        }
    }

    public static class Alternate {
        private static final Alternate NON_IGNORABLE = new Alternate("non-ignorable", Optional.empty());
        final String alternate;
        final Optional<String> maxVariable;

        public static Alternate nonIgnorable() {
            return NON_IGNORABLE;
        }

        public static AlternateWithMaxVariable shifted() {
            return AlternateWithMaxVariable.DEFAULT;
        }

        @ConstructorProperties(value={"alternate", "maxVariable"})
        Alternate(String alternate, Optional<String> maxVariable) {
            this.alternate = alternate;
            this.maxVariable = maxVariable;
        }
    }

    public static class CaseFirst {
        private static final CaseFirst UPPER = new CaseFirst("upper");
        private static final CaseFirst LOWER = new CaseFirst("lower");
        private static final CaseFirst OFF = new CaseFirst("off");
        private final String state;

        public static CaseFirst upper() {
            return UPPER;
        }

        public static CaseFirst lower() {
            return LOWER;
        }

        public static CaseFirst off() {
            return OFF;
        }

        @ConstructorProperties(value={"state"})
        private CaseFirst(String state) {
            this.state = state;
        }
    }

    public static class TertiaryICUComparisonLevel
    extends ICUComparisonLevel {
        static final TertiaryICUComparisonLevel DEFAULT = new TertiaryICUComparisonLevel();

        private TertiaryICUComparisonLevel() {
            super(3);
        }

        private TertiaryICUComparisonLevel(CaseFirst caseFirst) {
            super(3, Optional.of(caseFirst), Optional.empty());
        }

        public ComparisonLevel caseFirst(CaseFirst caseFirst) {
            Assert.notNull((Object)caseFirst, (String)"CaseFirst must not be null!");
            return new TertiaryICUComparisonLevel(caseFirst);
        }
    }

    public static class SecondaryICUComparisonLevel
    extends ICUComparisonLevel {
        static final SecondaryICUComparisonLevel DEFAULT = new SecondaryICUComparisonLevel();
        static final SecondaryICUComparisonLevel WITH_CASE_LEVEL = new SecondaryICUComparisonLevel(true);
        static final SecondaryICUComparisonLevel WITHOUT_CASE_LEVEL = new SecondaryICUComparisonLevel(false);

        private SecondaryICUComparisonLevel() {
            super(2);
        }

        private SecondaryICUComparisonLevel(boolean caseLevel) {
            super(2, Optional.empty(), Optional.of(caseLevel));
        }

        public ComparisonLevel includeCase() {
            return WITH_CASE_LEVEL;
        }

        public ComparisonLevel excludeCase() {
            return WITHOUT_CASE_LEVEL;
        }
    }

    public static class PrimaryICUComparisonLevel
    extends ICUComparisonLevel {
        static final PrimaryICUComparisonLevel DEFAULT = new PrimaryICUComparisonLevel();
        static final PrimaryICUComparisonLevel WITH_CASE_LEVEL = new PrimaryICUComparisonLevel(true);
        static final PrimaryICUComparisonLevel WITHOUT_CASE_LEVEL = new PrimaryICUComparisonLevel(false);

        private PrimaryICUComparisonLevel() {
            super(1);
        }

        private PrimaryICUComparisonLevel(boolean caseLevel) {
            super(1, Optional.empty(), Optional.of(caseLevel));
        }

        public ComparisonLevel includeCase() {
            return WITH_CASE_LEVEL;
        }

        public ComparisonLevel excludeCase() {
            return WITHOUT_CASE_LEVEL;
        }
    }

    static enum ComparisonLevels implements ComparisonLevel
    {
        QUATERNARY(4),
        IDENTICAL(5);

        private final int level;

        private ComparisonLevels(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }
    }

    static class ICUComparisonLevel
    implements ComparisonLevel {
        private final int level;
        private final Optional<CaseFirst> caseFirst;
        private final Optional<Boolean> caseLevel;

        ICUComparisonLevel(int level) {
            this(level, Optional.empty(), Optional.empty());
        }

        @ConstructorProperties(value={"level", "caseFirst", "caseLevel"})
        ICUComparisonLevel(int level, Optional<CaseFirst> caseFirst, Optional<Boolean> caseLevel) {
            this.level = level;
            this.caseFirst = caseFirst;
            this.caseLevel = caseLevel;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public Optional<CaseFirst> getCaseFirst() {
            return this.caseFirst;
        }

        @Override
        public Optional<Boolean> getCaseLevel() {
            return this.caseLevel;
        }
    }

    public static interface ComparisonLevel {
        public static PrimaryICUComparisonLevel primary() {
            return PrimaryICUComparisonLevel.DEFAULT;
        }

        public static SecondaryICUComparisonLevel secondary() {
            return SecondaryICUComparisonLevel.DEFAULT;
        }

        public static TertiaryICUComparisonLevel tertiary() {
            return TertiaryICUComparisonLevel.DEFAULT;
        }

        public static ComparisonLevel quaternary() {
            return ComparisonLevels.QUATERNARY;
        }

        public static ComparisonLevel identical() {
            return ComparisonLevels.IDENTICAL;
        }

        public int getLevel();

        default public Optional<CaseFirst> getCaseFirst() {
            return Optional.empty();
        }

        default public Optional<Boolean> getCaseLevel() {
            return Optional.empty();
        }
    }
}

