/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class ObjectPath {
    static final ObjectPath ROOT = new ObjectPath();
    private final ObjectPathItem[] items;

    private ObjectPath() {
        this.items = new ObjectPathItem[0];
    }

    private ObjectPath(ObjectPath parent, ObjectPathItem item) {
        ObjectPathItem[] items = new ObjectPathItem[parent.items.length + 1];
        System.arraycopy(parent.items, 0, items, 0, parent.items.length);
        items[parent.items.length] = item;
        this.items = items;
    }

    ObjectPath push(Object object, MongoPersistentEntity<?> entity, @Nullable Object id) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
        ObjectPathItem item = new ObjectPathItem(object, id, entity.getCollection());
        return new ObjectPath(this, item);
    }

    @Nullable
    @Deprecated
    Object getPathItem(Object id, String collection) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.hasText((String)collection, (String)"Collection name must not be null!");
        for (ObjectPathItem item : this.items) {
            Object object = item.getObject();
            if (object == null || item.getIdValue() == null || !collection.equals(item.getCollection()) || !id.equals(item.getIdValue())) continue;
            return object;
        }
        return null;
    }

    @Nullable
    <T> T getPathItem(Object id, String collection, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.hasText((String)collection, (String)"Collection name must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        for (ObjectPathItem item : this.items) {
            Object object = item.getObject();
            if (object == null || item.getIdValue() == null || !collection.equals(item.getCollection()) || !id.equals(item.getIdValue()) || !ClassUtils.isAssignable(type, object.getClass())) continue;
            return type.cast(object);
        }
        return null;
    }

    @Nullable
    Object getCurrentObject() {
        return this.items.length == 0 ? null : this.items[this.items.length - 1].getObject();
    }

    public String toString() {
        if (this.items.length == 0) {
            return "[empty]";
        }
        ArrayList<String> strings = new ArrayList<String>(this.items.length);
        for (ObjectPathItem item : this.items) {
            strings.add(ObjectUtils.nullSafeToString((Object)item.object));
        }
        return StringUtils.collectionToDelimitedString(strings, (String)" -> ");
    }

    private static final class ObjectPathItem {
        private final Object object;
        @Nullable
        private final Object idValue;
        private final String collection;

        @ConstructorProperties(value={"object", "idValue", "collection"})
        public ObjectPathItem(Object object, @Nullable Object idValue, String collection) {
            this.object = object;
            this.idValue = idValue;
            this.collection = collection;
        }

        public Object getObject() {
            return this.object;
        }

        @Nullable
        public Object getIdValue() {
            return this.idValue;
        }

        public String getCollection() {
            return this.collection;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectPathItem)) {
                return false;
            }
            ObjectPathItem other = (ObjectPathItem)o;
            Object this$object = this.getObject();
            Object other$object = other.getObject();
            if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
                return false;
            }
            Object this$idValue = this.getIdValue();
            Object other$idValue = other.getIdValue();
            if (this$idValue == null ? other$idValue != null : !this$idValue.equals(other$idValue)) {
                return false;
            }
            String this$collection = this.getCollection();
            String other$collection = other.getCollection();
            return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $object = this.getObject();
            result = result * 59 + ($object == null ? 43 : $object.hashCode());
            Object $idValue = this.getIdValue();
            result = result * 59 + ($idValue == null ? 43 : $idValue.hashCode());
            String $collection = this.getCollection();
            result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
            return result;
        }

        public String toString() {
            return "ObjectPath.ObjectPathItem(object=" + this.getObject() + ", idValue=" + this.getIdValue() + ", collection=" + this.getCollection() + ")";
        }
    }
}

