/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Order;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class IndexField {
    private final String key;
    private final Sort.Direction direction;
    private final boolean isGeo;

    private IndexField(String key, Sort.Direction direction, boolean isGeo) {
        Assert.hasText((String)key);
        Assert.isTrue((boolean)(direction != null ^ isGeo));
        this.key = key;
        this.direction = direction;
        this.isGeo = isGeo;
    }

    @Deprecated
    public static IndexField create(String key, Order order) {
        Assert.notNull((Object)((Object)order));
        return new IndexField(key, order.toDirection(), false);
    }

    public static IndexField create(String key, Sort.Direction order) {
        Assert.notNull((Object)order);
        return new IndexField(key, order, false);
    }

    public static IndexField geo(String key) {
        return new IndexField(key, null, true);
    }

    public String getKey() {
        return this.key;
    }

    @Deprecated
    public Order getOrder() {
        return Sort.Direction.ASC.equals((Object)this.direction) ? Order.ASCENDING : Order.DESCENDING;
    }

    public Sort.Direction getDirection() {
        return this.direction;
    }

    public boolean isGeo() {
        return this.isGeo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField that = (IndexField)obj;
        return this.key.equals(that.key) && ObjectUtils.nullSafeEquals((Object)this.direction, (Object)that.direction) && this.isGeo == that.isGeo;
    }

    public int hashCode() {
        int result = 17;
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.key);
        result += 31 * ObjectUtils.nullSafeHashCode((Object)this.direction);
        return result += 31 * ObjectUtils.nullSafeHashCode((Object)this.isGeo);
    }

    public String toString() {
        return String.format("IndexField [ key: %s, direction: %s, isGeo: %s]", this.key, this.direction, this.isGeo);
    }
}

