/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AnnotationAuditingConfiguration;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mapping.context.MappingContextIsNewStrategyFactory;
import org.springframework.data.mongodb.config.EnableMongoAuditing;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.event.AuditingEventListener;
import org.springframework.util.Assert;

class MongoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    MongoAuditingRegistrar() {
    }

    protected Class<? extends Annotation> getAnnotation() {
        return EnableMongoAuditing.class;
    }

    public void registerBeanDefinitions(AnnotationMetadata annotationMetadata, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)annotationMetadata, (String)"AnnotationMetadata must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        this.defaultDependenciesIfNecessary(registry, annotationMetadata);
        super.registerBeanDefinitions(annotationMetadata, registry);
    }

    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AnnotationAuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"AnnotationAuditingConfiguration must not be null!");
        return this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class)).addConstructorArgReference("isNewStrategyFactory");
    }

    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, (String)"BeanDefinition must not be null!");
        Assert.notNull((Object)registry, (String)"BeanDefinitionRegistry must not be null!");
        this.registerInfrastructureBeanWithId(BeanDefinitionBuilder.rootBeanDefinition(AuditingEventListener.class).addConstructorArgValue((Object)auditingHandlerDefinition).getRawBeanDefinition(), AuditingEventListener.class.getName(), registry);
    }

    private void defaultDependenciesIfNecessary(BeanDefinitionRegistry registry, Object source) {
        if (!registry.containsBeanDefinition("mappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(MongoMappingContext.class);
            definition.setRole(2);
            definition.setSource(source);
            registry.registerBeanDefinition("mappingContext", (BeanDefinition)definition);
        }
        if (!registry.containsBeanDefinition("isNewStrategyFactory")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MappingContextIsNewStrategyFactory.class);
            builder.addConstructorArgReference("mappingContext");
            AbstractBeanDefinition definition = ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)builder, (Object)source);
            definition.setRole(2);
            registry.registerBeanDefinition("isNewStrategyFactory", (BeanDefinition)definition);
        }
    }
}

