/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class QueryMapper {
    private static final List<String> DEFAULT_ID_NAMES = Arrays.asList("id", "_id");
    private final ConversionService conversionService;
    private final MongoConverter converter;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public QueryMapper(MongoConverter converter) {
        Assert.notNull((Object)converter);
        this.conversionService = converter.getConversionService();
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public DBObject getMappedObject(DBObject query, MongoPersistentEntity<?> entity) {
        if (this.isNestedKeyword(query)) {
            return this.getMappedKeyword(new Keyword(query), entity);
        }
        BasicDBObject result = new BasicDBObject();
        for (String key : query.keySet()) {
            if (Query.isRestrictedTypeKey(key)) {
                Set restrictedTypes = (Set)query.get(key);
                this.converter.getTypeMapper().writeTypeRestrictions((DBObject)result, restrictedTypes);
                continue;
            }
            if (this.isKeyword(key)) {
                result.putAll((BSONObject)this.getMappedKeyword(new Keyword(query, key), entity));
                continue;
            }
            Field field = entity == null ? new Field(key) : new MetadataBackedField(key, entity, this.mappingContext);
            Object rawValue = query.get(key);
            String newKey = field.getMappedKey();
            if (this.isNestedKeyword(rawValue) && !field.isIdField()) {
                Keyword keyword = new Keyword((DBObject)rawValue);
                result.put(newKey, (Object)this.getMappedKeyword(field, keyword));
                continue;
            }
            result.put(newKey, this.getMappedValue(field, rawValue));
        }
        return result;
    }

    private DBObject getMappedKeyword(Keyword keyword, MongoPersistentEntity<?> entity) {
        if (keyword.isOrOrNor() || keyword.hasIterableValue()) {
            Iterable conditions = (Iterable)keyword.getValue();
            BasicDBList newConditions = new BasicDBList();
            for (Object condition : conditions) {
                newConditions.add(condition instanceof DBObject ? this.getMappedObject((DBObject)condition, entity) : this.convertSimpleOrDBObject(condition, entity));
            }
            return new BasicDBObject(keyword.getKey(), (Object)newConditions);
        }
        return new BasicDBObject(keyword.getKey(), this.convertSimpleOrDBObject(keyword.getValue(), entity));
    }

    private DBObject getMappedKeyword(Field property, Keyword keyword) {
        boolean needsAssociationConversion = property.isAssociation() && !keyword.isExists();
        Object value = keyword.getValue();
        Object convertedValue = needsAssociationConversion ? this.convertAssociation(value, property.getProperty()) : this.getMappedValue(property.with(keyword.getKey()), value);
        return new BasicDBObject(keyword.key, convertedValue);
    }

    private Object getMappedValue(Field documentField, Object value) {
        if (documentField.isIdField()) {
            if (value instanceof DBObject) {
                DBObject valueDbo = (DBObject)value;
                if (valueDbo.containsField("$in") || valueDbo.containsField("$nin")) {
                    String inKey = valueDbo.containsField("$in") ? "$in" : "$nin";
                    ArrayList<Object> ids = new ArrayList<Object>();
                    for (Object id : (Iterable)valueDbo.get(inKey)) {
                        ids.add(this.convertId(id));
                    }
                    valueDbo.put(inKey, (Object)ids.toArray(new Object[ids.size()]));
                } else if (valueDbo.containsField("$ne")) {
                    valueDbo.put("$ne", this.convertId(valueDbo.get("$ne")));
                } else {
                    return this.getMappedObject((DBObject)value, null);
                }
                return valueDbo;
            }
            return this.convertId(value);
        }
        if (this.isNestedKeyword(value)) {
            return this.getMappedKeyword(new Keyword((DBObject)value), null);
        }
        if (documentField.isAssociation()) {
            return this.convertAssociation(value, documentField.getProperty());
        }
        return this.convertSimpleOrDBObject(value, documentField.getPropertyEntity());
    }

    private Object convertSimpleOrDBObject(Object source, MongoPersistentEntity<?> entity) {
        if (source instanceof BasicDBList) {
            return this.delegateConvertToMongoType(source, entity);
        }
        if (source instanceof DBObject) {
            return this.getMappedObject((DBObject)source, entity);
        }
        return this.delegateConvertToMongoType(source, entity);
    }

    protected Object delegateConvertToMongoType(Object source, MongoPersistentEntity<?> entity) {
        return this.converter.convertToMongoType(source);
    }

    private Object convertAssociation(Object source, MongoPersistentProperty property) {
        if (property == null || !property.isAssociation()) {
            return source;
        }
        if (source instanceof Iterable) {
            BasicDBList result = new BasicDBList();
            for (Object element : (Iterable)source) {
                result.add(element instanceof DBRef ? element : this.converter.toDBRef(element, property));
            }
            return result;
        }
        if (property.isMap()) {
            BasicDBObject result = new BasicDBObject();
            DBObject dbObject = (DBObject)source;
            Iterator i$ = dbObject.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                Object o = dbObject.get(key = (String)i$.next());
                result.put(key, o instanceof DBRef ? o : this.converter.toDBRef(o, property));
            }
            return result;
        }
        return source == null || source instanceof DBRef ? source : this.converter.toDBRef(source, property);
    }

    public Object convertId(Object id) {
        try {
            return this.conversionService.convert(id, ObjectId.class);
        }
        catch (ConversionException conversionException) {
            return this.delegateConvertToMongoType(id, null);
        }
    }

    protected boolean isNestedKeyword(Object candidate) {
        if (!(candidate instanceof BasicDBObject)) {
            return false;
        }
        BasicDBObject dbObject = (BasicDBObject)candidate;
        Set keys = dbObject.keySet();
        if (keys.size() != 1) {
            return false;
        }
        return this.isKeyword(((String)keys.iterator().next()).toString());
    }

    protected boolean isKeyword(String candidate) {
        return candidate.startsWith("$");
    }

    private static class MetadataBackedField
    extends Field {
        private final MongoPersistentEntity<?> entity;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
        private final MongoPersistentProperty property;

        public MetadataBackedField(String name, MongoPersistentEntity<?> entity, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
            this.entity = entity;
            this.mappingContext = context;
            PersistentPropertyPath<MongoPersistentProperty> path = this.getPath(name);
            this.property = path == null ? null : (MongoPersistentProperty)path.getLeafProperty();
        }

        @Override
        public MetadataBackedField with(String name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext);
        }

        @Override
        public boolean isIdField() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty != null) {
                return idProperty.getName().equals(this.name) || idProperty.getFieldName().equals(this.name);
            }
            return DEFAULT_ID_NAMES.contains(this.name);
        }

        @Override
        public MongoPersistentProperty getProperty() {
            return this.property;
        }

        @Override
        public MongoPersistentEntity<?> getPropertyEntity() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? null : (MongoPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property);
        }

        @Override
        public boolean isAssociation() {
            MongoPersistentProperty property = this.getProperty();
            return property == null ? false : property.isAssociation();
        }

        @Override
        public String getMappedKey() {
            PersistentPropertyPath<MongoPersistentProperty> path = this.getPath(this.name);
            return path == null ? this.name : path.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE);
        }

        private PersistentPropertyPath<MongoPersistentProperty> getPath(String name) {
            try {
                PropertyPath path = PropertyPath.from((String)name, (TypeInformation)this.entity.getTypeInformation());
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (PropertyReferenceException e) {
                return null;
            }
        }
    }

    private static class Field {
        private static final String ID_KEY = "_id";
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(String name) {
            return new Field(name);
        }

        public boolean isIdField() {
            return ID_KEY.equals(this.name);
        }

        public MongoPersistentProperty getProperty() {
            return null;
        }

        public MongoPersistentEntity<?> getPropertyEntity() {
            return null;
        }

        public boolean isAssociation() {
            return false;
        }

        public String getMappedKey() {
            return this.isIdField() ? ID_KEY : this.name;
        }
    }

    private static class Keyword {
        private static final String N_OR_PATTERN = "\\$.*or";
        private final String key;
        private final Object value;

        public Keyword(DBObject source, String key) {
            this.key = key;
            this.value = source.get(key);
        }

        public Keyword(DBObject dbObject) {
            Set keys = dbObject.keySet();
            Assert.isTrue((keys.size() == 1 ? 1 : 0) != 0, (String)"Can only use a single value DBObject!");
            this.key = (String)keys.iterator().next();
            this.value = dbObject.get(this.key);
        }

        public boolean isExists() {
            return "$exists".equalsIgnoreCase(this.key);
        }

        public boolean isOrOrNor() {
            return this.key.matches(N_OR_PATTERN);
        }

        public boolean hasIterableValue() {
            return this.value instanceof Iterable;
        }

        public String getKey() {
            return this.key;
        }

        public <T> T getValue() {
            return (T)this.value;
        }
    }
}

