/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<MongoOperations> operations;

    public MongoRepositoryBean(Bean<MongoOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager) {
        super(qualifiers, repositoryType, beanManager);
        Assert.notNull(operations);
        this.operations = operations;
    }

    public Class<? extends Annotation> getScope() {
        return this.operations.getScope();
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        MongoOperations mongoOperations = (MongoOperations)this.getDependencyInstance(this.operations, MongoOperations.class);
        MongoRepositoryFactory factory = new MongoRepositoryFactory(mongoOperations);
        return (T)factory.getRepository(repositoryType);
    }
}

