/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.CustomMetric;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;

public final class NearQuery {
    private final Point point;
    private Query query;
    private Distance maxDistance;
    private Distance minDistance;
    private Metric metric;
    private boolean spherical;
    private Integer num;
    private Integer skip;

    private NearQuery(Point point, Metric metric) {
        Assert.notNull((Object)point, (String)"Point must not be null!");
        this.point = point;
        this.spherical = false;
        if (metric != null) {
            this.in(metric);
        }
    }

    public static NearQuery near(double x, double y) {
        return NearQuery.near(x, y, null);
    }

    public static NearQuery near(double x, double y, Metric metric) {
        return NearQuery.near(new Point(x, y), metric);
    }

    public static NearQuery near(Point point) {
        return NearQuery.near(point, null);
    }

    public static NearQuery near(Point point, Metric metric) {
        return new NearQuery(point, metric);
    }

    public Metric getMetric() {
        return this.metric == null ? Metrics.NEUTRAL : this.metric;
    }

    public NearQuery num(int num) {
        this.num = num;
        return this;
    }

    public NearQuery skip(int skip) {
        this.skip = skip;
        return this;
    }

    public NearQuery with(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be 'null'.");
        this.num = pageable.getOffset() + pageable.getPageSize();
        this.skip = pageable.getOffset();
        return this;
    }

    public NearQuery maxDistance(double maxDistance) {
        return this.maxDistance(new Distance(maxDistance, this.getMetric()));
    }

    public NearQuery maxDistance(double maxDistance, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        return this.maxDistance(new Distance(maxDistance, metric));
    }

    public NearQuery maxDistance(Distance distance) {
        Assert.notNull((Object)distance, (String)"Distance must not be null!");
        if (distance.getMetric() != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        if (this.metric == null) {
            this.in(distance.getMetric());
        }
        this.maxDistance = distance;
        return this;
    }

    public NearQuery minDistance(double minDistance) {
        return this.minDistance(new Distance(minDistance, this.getMetric()));
    }

    public NearQuery minDistance(double minDistance, Metric metric) {
        Assert.notNull((Object)metric, (String)"Metric must not be null!");
        return this.minDistance(new Distance(minDistance, metric));
    }

    public NearQuery minDistance(Distance distance) {
        Assert.notNull((Object)distance, (String)"Distance must not be null!");
        if (distance.getMetric() != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        if (this.metric == null) {
            this.in(distance.getMetric());
        }
        this.minDistance = distance;
        return this;
    }

    public Distance getMaxDistance() {
        return this.maxDistance;
    }

    public Distance getMinDistance() {
        return this.minDistance;
    }

    public NearQuery distanceMultiplier(double distanceMultiplier) {
        this.metric = new CustomMetric(distanceMultiplier);
        return this;
    }

    @Deprecated
    public NearQuery distanceMultiplier(Metric metric) {
        Assert.notNull((Object)metric);
        return this.in(metric);
    }

    public NearQuery spherical(boolean spherical) {
        this.spherical = spherical;
        return this;
    }

    public boolean isSpherical() {
        return this.spherical;
    }

    public NearQuery inKilometers() {
        return this.adaptMetric((Metric)Metrics.KILOMETERS);
    }

    public NearQuery inMiles() {
        return this.adaptMetric((Metric)Metrics.MILES);
    }

    public NearQuery in(Metric metric) {
        return this.adaptMetric((Metric)(metric == null ? Metrics.NEUTRAL : metric));
    }

    private NearQuery adaptMetric(Metric metric) {
        if (metric != Metrics.NEUTRAL) {
            this.spherical(true);
        }
        this.metric = metric;
        return this;
    }

    public NearQuery query(Query query) {
        Assert.notNull((Object)query, (String)"Cannot apply 'null' query on NearQuery.");
        this.query = query;
        this.skip = query.getSkip();
        if (query.getLimit() != 0) {
            this.num = query.getLimit();
        }
        return this;
    }

    public Integer getSkip() {
        return this.skip;
    }

    public DBObject toDBObject() {
        BasicDBObject dbObject = new BasicDBObject();
        if (this.query != null) {
            dbObject.put("query", (Object)this.query.getQueryObject());
        }
        if (this.maxDistance != null) {
            dbObject.put("maxDistance", (Object)this.maxDistance.getNormalizedValue());
        }
        if (this.minDistance != null) {
            dbObject.put("minDistance", (Object)this.minDistance.getNormalizedValue());
        }
        if (this.metric != null) {
            dbObject.put("distanceMultiplier", (Object)this.metric.getMultiplier());
        }
        if (this.num != null) {
            dbObject.put("num", (Object)this.num);
        }
        dbObject.put("near", Arrays.asList(this.point.getX(), this.point.getY()));
        dbObject.put("spherical", (Object)this.spherical);
        return dbObject;
    }
}

