/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.mongodb.repository.support.MongoEntityInformationSupport;
import org.springframework.data.mongodb.repository.support.QueryDslMongoRepository;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class MongoRepositoryFactory
extends RepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final MongoOperations operations;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public MongoRepositoryFactory(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations);
        this.operations = mongoOperations;
        this.mappingContext = mongoOperations.getConverter().getMappingContext();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        boolean isQueryDslRepository = QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        return isQueryDslRepository ? QueryDslMongoRepository.class : SimpleMongoRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        MongoEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new MongoQueryLookupStrategy(this.operations, evaluationContextProvider, this.mappingContext);
    }

    public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, RepositoryInformation information) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return MongoEntityInformationSupport.entityInformationFor(entity, information != null ? information.getIdType() : null);
    }

    private static class MongoQueryLookupStrategy
    implements QueryLookupStrategy {
        private final MongoOperations operations;
        private final EvaluationContextProvider evaluationContextProvider;
        MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

        public MongoQueryLookupStrategy(MongoOperations operations, EvaluationContextProvider evaluationContextProvider, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            this.operations = operations;
            this.evaluationContextProvider = evaluationContextProvider;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedMongoQuery(namedQuery, queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedMongoQuery(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            return new PartTreeMongoQuery(queryMethod, this.operations);
        }
    }
}

