/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.ldap.repository.Query;
import org.springframework.data.ldap.repository.query.LdapParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;

public class LdapQueryMethod
extends QueryMethod {
    private final Method method;

    public LdapQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
    }

    protected LdapParameters createParameters(ParametersSource parametersSource) {
        return new LdapParameters(parametersSource);
    }

    public LdapParameters getParameters() {
        return (LdapParameters)super.getParameters();
    }

    public boolean hasQueryAnnotation() {
        return this.getQueryAnnotation() != null;
    }

    @Nullable
    Query getQueryAnnotation() {
        return (Query)AnnotationUtils.getAnnotation((Method)this.method, Query.class);
    }

    Query getRequiredQueryAnnotation() {
        Query queryAnnotation = this.getQueryAnnotation();
        if (queryAnnotation != null) {
            return queryAnnotation;
        }
        throw new IllegalStateException("Required @Query annotation is not present");
    }
}

