/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.FilteredClause;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.springframework.data.ldap.repository.support.LdapSerializer;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class QuerydslLdapQuery<K>
implements FilteredClause<QuerydslLdapQuery<K>> {
    private final LdapOperations ldapOperations;
    private final Class<? extends K> entityType;
    private final LdapSerializer filterGenerator;
    private QueryMixin<QuerydslLdapQuery<K>> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata().noValidate());

    public QuerydslLdapQuery(LdapOperations ldapOperations, EntityPath<K> entityPath) {
        this(ldapOperations, entityPath.getType());
    }

    public QuerydslLdapQuery(LdapOperations ldapOperations, Class<? extends K> entityType) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null!");
        Assert.notNull(entityType, (String)"Type must not be null!");
        this.ldapOperations = ldapOperations;
        this.entityType = entityType;
        this.filterGenerator = new LdapSerializer(ldapOperations.getObjectDirectoryMapper(), this.entityType);
    }

    public QuerydslLdapQuery<K> where(Predicate ... o) {
        return (QuerydslLdapQuery)this.queryMixin.where(o);
    }

    public List<K> list() {
        return this.ldapOperations.find(this.buildQuery(), this.entityType);
    }

    public K uniqueResult() {
        return (K)this.ldapOperations.findOne(this.buildQuery(), this.entityType);
    }

    private LdapQuery buildQuery() {
        Predicate where = this.queryMixin.getMetadata().getWhere();
        if (where != null) {
            return LdapQueryBuilder.query().filter(this.filterGenerator.handle((Expression<?>)where));
        }
        return LdapQueryBuilder.query();
    }
}

