/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.event;

import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;

public class KeyValueEvent<T>
extends ApplicationEvent {
    private static final long serialVersionUID = -7128527253428193044L;
    private final String keyspace;

    protected KeyValueEvent(Object source, String keyspace) {
        super(source);
        this.keyspace = keyspace;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String toString() {
        return "KeyValueEvent [keyspace=" + this.keyspace + ", source=" + this.getSource() + "]";
    }

    public static <T> BeforeGetEvent<T> beforeGet(Object id, String keyspace, Class<T> type) {
        return new BeforeGetEvent<T>(id, keyspace, type);
    }

    public static <T> AfterGetEvent<T> afterGet(Object id, String keyspace, Class<T> type, @Nullable T value) {
        return new AfterGetEvent<T>(id, keyspace, type, value);
    }

    public static <T> BeforeInsertEvent<T> beforeInsert(Object id, String keyspace, Class<? extends T> type, T value) {
        return new BeforeInsertEvent<T>(id, keyspace, type, value);
    }

    public static <T> AfterInsertEvent<T> afterInsert(Object id, String keyspace, Class<? extends T> type, T value) {
        return new AfterInsertEvent<T>(id, keyspace, type, value);
    }

    public static <T> BeforeUpdateEvent<T> beforeUpdate(Object id, String keyspace, Class<? extends T> type, T value) {
        return new BeforeUpdateEvent<T>(id, keyspace, type, value);
    }

    public static <T> AfterUpdateEvent<T> afterUpdate(Object id, String keyspace, Class<? extends T> type, T actualValue, @Nullable Object previousValue) {
        return new AfterUpdateEvent<T>(id, keyspace, type, actualValue, previousValue);
    }

    public static <T> BeforeDropKeySpaceEvent<T> beforeDropKeySpace(String keyspace, Class<? extends T> type) {
        return new BeforeDropKeySpaceEvent<T>(keyspace, type);
    }

    public static <T> AfterDropKeySpaceEvent<T> afterDropKeySpace(String keyspace, Class<? extends T> type) {
        return new AfterDropKeySpaceEvent<T>(keyspace, type);
    }

    public static <T> BeforeDeleteEvent<T> beforeDelete(Object id, String keyspace, Class<? extends T> type) {
        return new BeforeDeleteEvent<T>(id, keyspace, type);
    }

    public static <T> AfterDeleteEvent<T> afterDelete(Object id, String keyspace, Class<? extends T> type, @Nullable T value) {
        return new AfterDeleteEvent<T>(id, keyspace, type, value);
    }

    public static class BeforeGetEvent<T>
    extends KeyBasedEvent<T> {
        protected BeforeGetEvent(Object key, String keyspace, Class<T> type) {
            super(key, keyspace, type);
        }
    }

    public static class AfterGetEvent<T>
    extends KeyBasedEventWithPayload<T> {
        protected AfterGetEvent(Object key, String keyspace, Class<T> type, @Nullable T payload) {
            super(key, keyspace, type, payload);
        }
    }

    public static class BeforeInsertEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public BeforeInsertEvent(Object key, String keyspace, Class<? extends T> type, @Nullable T payload) {
            super(key, keyspace, type, payload);
        }
    }

    public static class AfterInsertEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public AfterInsertEvent(Object key, String keyspace, Class<? extends T> type, @Nullable T payload) {
            super(key, keyspace, type, payload);
        }
    }

    public static class BeforeUpdateEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public BeforeUpdateEvent(Object key, String keyspace, Class<? extends T> type, @Nullable T payload) {
            super(key, keyspace, type, payload);
        }
    }

    public static class AfterUpdateEvent<T>
    extends KeyBasedEventWithPayload<T> {
        private final @Nullable Object existing;

        public AfterUpdateEvent(Object key, String keyspace, Class<? extends T> type, T payload, @Nullable Object existing) {
            super(key, keyspace, type, payload);
            this.existing = existing;
        }

        public @Nullable Object before() {
            return this.existing;
        }

        public @Nullable T after() {
            return (T)this.getPayload();
        }
    }

    public static class BeforeDropKeySpaceEvent<T>
    extends KeyValueEvent<T> {
        public BeforeDropKeySpaceEvent(String keyspace, Class<? extends T> type) {
            super(type, keyspace);
        }

        public Class<T> getSource() {
            return (Class)super.getSource();
        }
    }

    public static class AfterDropKeySpaceEvent<T>
    extends KeyValueEvent<T> {
        public AfterDropKeySpaceEvent(String keyspace, Class<? extends T> type) {
            super(type, keyspace);
        }

        public Class<T> getSource() {
            return (Class)super.getSource();
        }
    }

    public static class BeforeDeleteEvent<T>
    extends KeyBasedEvent<T> {
        public BeforeDeleteEvent(Object key, String keyspace, Class<? extends T> type) {
            super(key, keyspace, type);
        }
    }

    public static class AfterDeleteEvent<T>
    extends KeyBasedEventWithPayload<T> {
        public AfterDeleteEvent(Object key, String keyspace, Class<? extends T> type, @Nullable T payload) {
            super(key, keyspace, type, payload);
        }
    }

    static abstract class KeyBasedEventWithPayload<T>
    extends KeyBasedEvent<T> {
        private final @Nullable T payload;

        KeyBasedEventWithPayload(Object key, String keyspace, Class<? extends T> type, @Nullable T payload) {
            super(key, keyspace, type);
            this.payload = payload;
        }

        public @Nullable T getPayload() {
            return this.payload;
        }
    }

    static abstract class KeyBasedEvent<T>
    extends KeyValueEvent<T> {
        private Object key;
        private Class<? extends T> type;

        KeyBasedEvent(Object key, String keyspace, Class<? extends T> type) {
            super(type, keyspace);
            this.key = key;
            this.type = type;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getSource() {
            return this.getKey();
        }

        public Class<? extends T> getType() {
            return this.type;
        }
    }
}

