/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.query;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.ClassUtils;

public class KeyValuePartTreeQuery
implements RepositoryQuery {
    private final EvaluationContextProvider evaluationContextProvider;
    private final QueryMethod queryMethod;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private KeyValueQuery<?> query;

    public KeyValuePartTreeQuery(QueryMethod queryMethod, EvaluationContextProvider evalContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this.queryMethod = queryMethod;
        this.keyValueOperations = keyValueOperations;
        this.evaluationContextProvider = evalContextProvider;
        this.queryCreator = queryCreator;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    public Object execute(Object[] parameters) {
        KeyValueQuery<?> query = this.prepareQuery(parameters);
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable page = (Pageable)parameters[this.queryMethod.getParameters().getPageableIndex()];
            query.setOffset(page.getOffset());
            query.setRows(page.getPageSize());
            Iterable result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            long count = this.queryMethod.isSliceQuery() ? 0L : this.keyValueOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(IterableConverter.toList(result), page, count);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Iterable result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            return result.iterator().hasNext() ? result.iterator().next() : null;
        }
        throw new UnsupportedOperationException("Query method not supported.");
    }

    private KeyValueQuery<?> prepareQuery(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        if (this.query == null) {
            this.query = this.createQuery(accessor);
        }
        KeyValueQuery q = new KeyValueQuery(this.query.getCritieria());
        if (accessor.getPageable() != null) {
            q.setOffset(accessor.getPageable().getOffset());
            q.setRows(accessor.getPageable().getPageSize());
        } else {
            q.setOffset(-1);
            q.setRows(-1);
        }
        if (accessor.getSort() != null) {
            q.setSort(accessor.getSort());
        } else {
            q.setSort(this.query.getSort());
        }
        if (q.getCritieria() instanceof SpelExpression) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), parameters);
            ((SpelExpression)q.getCritieria()).setEvaluationContext(context);
        }
        return q;
    }

    public KeyValueQuery<?> createQuery(ParametersParameterAccessor accessor) {
        PartTree tree = new PartTree(this.getQueryMethod().getName(), this.getQueryMethod().getEntityInformation().getJavaType());
        Constructor constructor = ClassUtils.getConstructorIfAvailable(this.queryCreator, (Class[])new Class[]{PartTree.class, ParameterAccessor.class});
        return (KeyValueQuery)((AbstractQueryCreator)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{tree, accessor})).createQuery();
    }
}

