/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SpelCriteriaAccessor;
import org.springframework.data.keyvalue.core.SpelSortAccessor;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

class SpelQueryEngine<T extends KeyValueAdapter>
extends QueryEngine<KeyValueAdapter, SpelExpression, Comparator<?>> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    public SpelQueryEngine() {
        super(new SpelCriteriaAccessor(PARSER), new SpelSortAccessor(PARSER));
    }

    @Override
    public Collection<?> execute(SpelExpression criteria, Comparator<?> sort, int offset, int rows, Serializable keyspace) {
        return this.sortAndFilterMatchingRange(this.getAdapter().getAllOf(keyspace), criteria, sort, offset, rows);
    }

    @Override
    public long count(SpelExpression criteria, Serializable keyspace) {
        return SpelQueryEngine.filterMatchingRange(this.getAdapter().getAllOf(keyspace), criteria, -1, -1).size();
    }

    private List<?> sortAndFilterMatchingRange(Iterable<?> source, SpelExpression criteria, Comparator sort, int offset, int rows) {
        List<?> tmp = IterableConverter.toList(source);
        if (sort != null) {
            Collections.sort(tmp, sort);
        }
        return SpelQueryEngine.filterMatchingRange(tmp, criteria, offset, rows);
    }

    private static <S> List<S> filterMatchingRange(Iterable<S> source, SpelExpression criteria, int offset, int rows) {
        ArrayList<S> result = new ArrayList<S>();
        boolean compareOffsetAndRows = 0 < offset || 0 <= rows;
        int remainingRows = rows;
        int curPos = 0;
        for (S candidate : source) {
            boolean matches;
            boolean bl = matches = criteria == null;
            if (!matches) {
                try {
                    matches = (Boolean)criteria.getValue(candidate, Boolean.class);
                }
                catch (SpelEvaluationException e) {
                    criteria.getEvaluationContext().setVariable("it", candidate);
                    matches = (Boolean)criteria.getValue(Boolean.class);
                }
            }
            if (!matches) continue;
            if (compareOffsetAndRows) {
                if (curPos >= offset && rows > 0) {
                    result.add(candidate);
                    if (--remainingRows <= 0) break;
                }
                ++curPos;
                continue;
            }
            result.add(candidate);
        }
        return result;
    }
}

