/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Metamodel;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class JpaCountQueryCreator
extends JpaQueryCreator {
    private final boolean distinct;

    public JpaCountQueryCreator(PartTree tree, ReturnedType returnedType, ParameterMetadataProvider provider, JpqlQueryTemplates templates, EntityManager em) {
        super(tree, returnedType, provider, templates, em.getMetamodel());
        this.distinct = tree.isDistinct();
    }

    public JpaCountQueryCreator(PartTree tree, ReturnedType returnedType, ParameterMetadataProvider provider, JpqlQueryTemplates templates, Metamodel metamodel) {
        super(tree, returnedType, provider, templates, metamodel);
        this.distinct = tree.isDistinct();
    }

    public JpaCountQueryCreator(PartTree tree, ReturnedType returnedType, ParameterMetadataProvider provider, JpqlQueryTemplates templates, JpaEntityMetadata<?> entityMetadata, Metamodel metamodel) {
        super(tree, false, returnedType, provider, templates, entityMetadata, metamodel);
        this.distinct = tree.isDistinct();
    }

    @Override
    protected JpqlQueryBuilder.Select buildQuery(Sort sort) {
        JpqlQueryBuilder.SelectStep selectStep = JpqlQueryBuilder.selectFrom(this.getEntity());
        if (this.distinct) {
            selectStep = selectStep.distinct();
        }
        return selectStep.count();
    }
}

