/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.DeleteSpecification;
import org.springframework.data.jpa.domain.PredicateSpecification;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.UpdateSpecification;
import org.springframework.data.repository.query.FluentQuery;

public interface JpaSpecificationExecutor<T> {
    default public Optional<T> findOne(PredicateSpecification<T> spec) {
        return this.findOne(Specification.where(spec));
    }

    public Optional<T> findOne(Specification<T> var1);

    default public List<T> findAll(PredicateSpecification<T> spec) {
        return this.findAll(Specification.where(spec));
    }

    public List<T> findAll(Specification<T> var1);

    public Page<T> findAll(Specification<T> var1, Pageable var2);

    public Page<T> findAll(Specification<T> var1, Specification<T> var2, Pageable var3);

    public List<T> findAll(Specification<T> var1, Sort var2);

    default public long count(PredicateSpecification<T> spec) {
        return this.count(Specification.where(spec));
    }

    public long count(Specification<T> var1);

    default public boolean exists(PredicateSpecification<T> spec) {
        return this.exists(Specification.where(spec));
    }

    public boolean exists(Specification<T> var1);

    public long update(UpdateSpecification<T> var1);

    default public long delete(PredicateSpecification<T> spec) {
        return this.delete(DeleteSpecification.where(spec));
    }

    public long delete(DeleteSpecification<T> var1);

    default public <S extends T, R> R findBy(PredicateSpecification<T> spec, Function<? super SpecificationFluentQuery<S>, R> queryFunction) {
        return this.findBy(Specification.where(spec), queryFunction);
    }

    public <S extends T, R> R findBy(Specification<T> var1, Function<? super SpecificationFluentQuery<S>, R> var2);

    public static interface SpecificationFluentQuery<T>
    extends FluentQuery.FetchableFluentQuery<T> {
        public SpecificationFluentQuery<T> sortBy(Sort var1);

        public SpecificationFluentQuery<T> limit(int var1);

        public <R> SpecificationFluentQuery<R> as(Class<R> var1);

        default public SpecificationFluentQuery<T> project(String ... properties) {
            return this.project(Arrays.asList(properties));
        }

        public SpecificationFluentQuery<T> project(Collection<String> var1);

        default public Page<T> page(Pageable pageable, PredicateSpecification<?> countSpec) {
            return this.page(pageable, Specification.where(countSpec));
        }

        public Page<T> page(Pageable var1, Specification<?> var2);
    }
}

