/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.IdClass;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanWrapper;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.JpaMetamodelEntityMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;

public class JpaMetamodelEntityInformation<T, ID>
extends JpaEntityInformationSupport<T, ID> {
    private final IdMetadata<T> idMetadata;
    private final Optional<SingularAttribute<? super T, ?>> versionAttribute;
    private final Metamodel metamodel;
    @Nullable
    private final String entityName;
    private final PersistenceUnitUtil persistenceUnitUtil;

    /*
     * WARNING - void declaration
     */
    public JpaMetamodelEntityInformation(Class<T> domainClass, Metamodel metamodel, PersistenceUnitUtil persistenceUnitUtil) {
        super(domainClass);
        void identifiableType;
        Assert.notNull((Object)metamodel, (String)"Metamodel must not be null");
        this.metamodel = metamodel;
        ManagedType type = metamodel.managedType(domainClass);
        if (type == null) {
            throw new IllegalArgumentException("The given domain class can not be found in the given Metamodel");
        }
        String string = this.entityName = type instanceof EntityType ? ((EntityType)type).getName() : null;
        if (!(type instanceof IdentifiableType)) {
            throw new IllegalArgumentException("The given domain class does not contain an id attribute");
        }
        IdentifiableType identifiableType2 = (IdentifiableType)type;
        this.idMetadata = new IdMetadata(identifiableType, PersistenceProvider.fromMetamodel(metamodel));
        this.versionAttribute = JpaMetamodelEntityInformation.findVersionAttribute(identifiableType, metamodel);
        Assert.notNull((Object)persistenceUnitUtil, (String)"PersistenceUnitUtil must not be null");
        this.persistenceUnitUtil = persistenceUnitUtil;
    }

    JpaMetamodelEntityInformation(EntityType<T> entityType, Metamodel metamodel, PersistenceUnitUtil persistenceUnitUtil) {
        super(new JpaMetamodelEntityMetadata<T>(entityType));
        this.metamodel = metamodel;
        this.entityName = entityType.getName();
        this.idMetadata = new IdMetadata<T>(entityType, PersistenceProvider.fromMetamodel(metamodel));
        this.versionAttribute = JpaMetamodelEntityInformation.findVersionAttribute(entityType, metamodel);
        Assert.notNull((Object)persistenceUnitUtil, (String)"PersistenceUnitUtil must not be null");
        this.persistenceUnitUtil = persistenceUnitUtil;
    }

    @Override
    public String getEntityName() {
        return this.entityName != null ? this.entityName : super.getEntityName();
    }

    /*
     * Unable to fully structure code
     */
    private static <T> Optional<SingularAttribute<? super T, ?>> findVersionAttribute(IdentifiableType<T> type, Metamodel metamodel) {
        try {
            return Optional.ofNullable(type.getVersion(Object.class));
        }
        catch (IllegalArgumentException v0) {
            attributes = type.getSingularAttributes();
            ** for (attribute : attributes)
        }
lbl-1000:
        // 1 sources

        {
            if (!attribute.isVersion()) continue;
            return Optional.of(attribute);
        }
lbl8:
        // 1 sources

        superType = type.getJavaType().getSuperclass();
        if (!JpaMetamodel.of(metamodel).isJpaManaged(superType)) {
            return Optional.empty();
        }
        managedSuperType = metamodel.managedType(superType);
        if (!(managedSuperType instanceof IdentifiableType)) {
            return Optional.empty();
        }
        return JpaMetamodelEntityInformation.findVersionAttribute((IdentifiableType)managedSuperType, metamodel);
    }

    @Nullable
    public ID getId(T entity) {
        PersistenceProvider persistenceProvider = PersistenceProvider.fromMetamodel(this.metamodel);
        if (persistenceProvider.shouldUseAccessorFor(entity)) {
            return (ID)persistenceProvider.getIdentifierFrom(entity);
        }
        if (this.idMetadata.hasSimpleId()) {
            if (entity instanceof Tuple) {
                Tuple t = (Tuple)entity;
                return (ID)t.get(this.idMetadata.getSimpleIdAttribute().getName());
            }
            if (this.getJavaType().isInstance(entity)) {
                return (ID)this.persistenceUnitUtil.getIdentifier(entity);
            }
        }
        DirectFieldAccessFallbackBeanWrapper entityWrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        boolean partialIdValueFound = false;
        for (SingularAttribute<T, ?> attribute : this.idMetadata) {
            Object propertyValue = entityWrapper.getPropertyValue(attribute.getName());
            if (this.idMetadata.hasSimpleId()) {
                return (ID)propertyValue;
            }
            if (propertyValue == null) continue;
            partialIdValueFound = true;
        }
        return (ID)(partialIdValueFound ? this.persistenceUnitUtil.getIdentifier(entity) : null);
    }

    public Class<ID> getIdType() {
        return this.idMetadata.getType();
    }

    @Override
    public SingularAttribute<? super T, ?> getIdAttribute() {
        return this.idMetadata.getSimpleIdAttribute();
    }

    @Override
    public boolean hasCompositeId() {
        return !this.idMetadata.hasSimpleId();
    }

    @Override
    public Collection<String> getIdAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>(this.idMetadata.attributes.size());
        for (SingularAttribute singularAttribute : this.idMetadata.attributes) {
            attributeNames.add(singularAttribute.getName());
        }
        return attributeNames;
    }

    @Override
    @Nullable
    public Object getCompositeIdAttributeValue(Object id, String idAttribute) {
        Assert.isTrue((boolean)this.hasCompositeId(), (String)"Model must have a composite Id");
        return new DirectFieldAccessFallbackBeanWrapper(id).getPropertyValue(idAttribute);
    }

    public boolean isNew(T entity) {
        if (this.versionAttribute.isEmpty() || this.versionAttribute.map(Attribute::getJavaType).map(Class::isPrimitive).orElse(false).booleanValue()) {
            return super.isNew(entity);
        }
        DirectFieldAccessFallbackBeanWrapper wrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        return this.versionAttribute.map(arg_0 -> JpaMetamodelEntityInformation.lambda$2((BeanWrapper)wrapper, arg_0)).orElse(true);
    }

    @Override
    public Map<String, Object> getKeyset(Iterable<String> propertyPaths, T entity) {
        Function<String, Object> getter = this.getPropertyValueFunction(entity);
        LinkedHashMap<String, Object> keyset = new LinkedHashMap<String, Object>();
        if (this.hasCompositeId()) {
            for (String idAttributeName : this.getIdAttributeNames()) {
                keyset.put(idAttributeName, getter.apply(idAttributeName));
            }
        } else {
            keyset.put(this.getIdAttribute().getName(), this.getId(entity));
        }
        for (String propertyPath : propertyPaths) {
            keyset.put(propertyPath, getter.apply(propertyPath));
        }
        return keyset;
    }

    private Function<String, Object> getPropertyValueFunction(Object entity) {
        if (entity instanceof Tuple) {
            Tuple t = (Tuple)entity;
            return arg_0 -> ((Tuple)t).get(arg_0);
        }
        DirectFieldAccessFallbackBeanWrapper entityWrapper = new DirectFieldAccessFallbackBeanWrapper(entity);
        return arg_0 -> ((BeanWrapper)entityWrapper).getPropertyValue(arg_0);
    }

    private static /* synthetic */ Boolean lambda$2(BeanWrapper beanWrapper, SingularAttribute it) {
        return beanWrapper.getPropertyValue(it.getName()) == null;
    }

    private static class IdMetadata<T>
    implements Iterable<SingularAttribute<? super T, ?>> {
        private final IdentifiableType<T> type;
        private final Set<SingularAttribute<? super T, ?>> idClassAttributes;
        private final Set<SingularAttribute<? super T, ?>> attributes;
        @Nullable
        private Class<?> idType;

        IdMetadata(IdentifiableType<T> source, PersistenceProvider persistenceProvider) {
            this.type = source;
            this.idClassAttributes = persistenceProvider.getIdClassAttributes(source);
            this.attributes = source.hasSingleIdAttribute() ? Collections.singleton(source.getId(source.getIdType().getJavaType())) : source.getIdClassAttributes();
        }

        boolean hasSimpleId() {
            return this.idClassAttributes.isEmpty() && this.attributes.size() == 1;
        }

        public Class<?> getType() {
            if (this.idType != null) {
                return this.idType;
            }
            this.idType = this.tryExtractIdTypeWithFallbackToIdTypeLookup();
            if (this.idType == null) {
                throw new IllegalStateException("Cannot resolve Id type from " + String.valueOf(this.type));
            }
            return this.idType;
        }

        @Nullable
        private Class<?> tryExtractIdTypeWithFallbackToIdTypeLookup() {
            try {
                Class<T> idClassType = IdMetadata.lookupIdClass(this.type);
                if (idClassType != null) {
                    return idClassType;
                }
                Type idType = this.type.getIdType();
                return idType == null ? null : idType.getJavaType();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }

        @Nullable
        private static Class<?> lookupIdClass(IdentifiableType<?> type) {
            IdClass annotation = type.getJavaType() != null ? (IdClass)AnnotationUtils.findAnnotation((Class)type.getJavaType(), IdClass.class) : null;
            return annotation == null ? null : annotation.value();
        }

        SingularAttribute<? super T, ?> getSimpleIdAttribute() {
            return this.attributes.iterator().next();
        }

        @Override
        public Iterator<SingularAttribute<? super T, ?>> iterator() {
            return this.attributes.iterator();
        }
    }
}

