/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.VectorScoringFunctions;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaMetamodelEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.JpqlQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlUtils;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.query.SimilarityNormalizer;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class JpaQueryCreator
extends AbstractQueryCreator<String, JpqlQueryBuilder.Predicate>
implements JpqlQueryCreator {
    private static final Map<ScoringFunction, DistanceFunction> DISTANCE_FUNCTIONS = Map.of(VectorScoringFunctions.COSINE, new DistanceFunction("cosine_distance", Sort.Direction.ASC), VectorScoringFunctions.EUCLIDEAN, new DistanceFunction("euclidean_distance", Sort.Direction.ASC), VectorScoringFunctions.TAXICAB, new DistanceFunction("taxicab_distance", Sort.Direction.ASC), VectorScoringFunctions.HAMMING, new DistanceFunction("hamming_distance", Sort.Direction.ASC), VectorScoringFunctions.DOT_PRODUCT, new DistanceFunction("negative_inner_product", Sort.Direction.ASC));
    private final boolean searchQuery;
    private final ReturnedType returnedType;
    private final ParameterMetadataProvider provider;
    private final JpqlQueryTemplates templates;
    private final PartTree tree;
    private final EscapeCharacter escape;
    private final EntityType<?> entityType;
    private final JpqlQueryBuilder.Entity entity;
    private final Metamodel metamodel;
    private final SimilarityNormalizer similarityNormalizer;
    private final boolean useNamedParameters;

    public JpaQueryCreator(PartTree tree, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, EntityManager em) {
        this(tree, false, type, provider, templates, em.getMetamodel());
    }

    public JpaQueryCreator(PartTree tree, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, Metamodel metamodel) {
        this(tree, false, type, provider, templates, metamodel);
    }

    public JpaQueryCreator(PartTree tree, boolean searchQuery, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, Metamodel metamodel) {
        this(tree, searchQuery, type, provider, templates, new JpaMetamodelEntityMetadata(metamodel.entity(type.getDomainType())), metamodel);
    }

    public JpaQueryCreator(PartTree tree, boolean searchQuery, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, JpaEntityMetadata<?> entityMetadata, Metamodel metamodel) {
        super(tree);
        this.searchQuery = searchQuery;
        this.tree = tree;
        this.returnedType = type;
        this.provider = provider;
        JpaParameters bindableParameters = (JpaParameters)provider.getParameters().getBindableParameters();
        boolean useNamedParameters = false;
        Iterator iterator = bindableParameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter bindableParameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (bindableParameter.isNamedParameter()) {
                useNamedParameters = true;
            }
            if (!useNamedParameters || bindableParameter.isNamedParameter()) continue;
            useNamedParameters = false;
            break;
        }
        this.useNamedParameters = useNamedParameters;
        this.templates = templates;
        this.escape = provider.getEscape();
        this.entityType = metamodel.entity(type.getDomainType());
        this.entity = JpqlQueryBuilder.entity(entityMetadata);
        this.metamodel = metamodel;
        this.similarityNormalizer = provider.getSimilarityNormalizer();
    }

    Bindable<?> getFrom() {
        return this.entityType;
    }

    JpqlQueryBuilder.Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean useTupleQuery() {
        return this.returnedType.needsCustomConstruction() && this.returnedType.getReturnedType().isInterface();
    }

    @Override
    public List<ParameterBinding> getBindings() {
        return this.provider.getBindings();
    }

    @Override
    public ParameterBinder getBinder() {
        return ParameterBinderFactory.createBinder(this.provider.getParameters(), this.getBindings());
    }

    protected JpqlQueryBuilder.Predicate create(Part part, Iterator<Object> iterator) {
        return this.toPredicate(part);
    }

    protected JpqlQueryBuilder.Predicate and(Part part, JpqlQueryBuilder.Predicate base, Iterator<Object> iterator) {
        return base.and(this.toPredicate(part));
    }

    protected JpqlQueryBuilder.Predicate or(JpqlQueryBuilder.Predicate base, JpqlQueryBuilder.Predicate predicate) {
        return base.or(predicate);
    }

    protected final String complete(@Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        JpqlQueryBuilder.AbstractJpqlQuery query = this.createQuery(predicate, sort);
        return query.render();
    }

    protected JpqlQueryBuilder.AbstractJpqlQuery createQuery(@Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        JpqlQueryBuilder.Select query = this.buildQuery(sort);
        if (predicate != null) {
            return query.where(predicate);
        }
        return query;
    }

    protected JpqlQueryBuilder.Select buildQuery(Sort sort) {
        DistanceFunction distanceFunction;
        JpqlQueryBuilder.Select select = this.doSelect(sort);
        if (this.tree.isDelete() || this.tree.isCountProjection()) {
            return select;
        }
        if (sort.isSorted()) {
            for (Sort.Order order : sort) {
                JpqlQueryBuilder.Expression expression;
                QueryUtils.checkSortExpression(order);
                try {
                    expression = JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)order.getProperty(), (Class)this.entityType.getJavaType()));
                }
                catch (PropertyReferenceException e) {
                    JpaSort.JpaOrder jpaOrder;
                    if (order instanceof JpaSort.JpaOrder && (jpaOrder = (JpaSort.JpaOrder)order).isUnsafe()) {
                        expression = JpqlQueryBuilder.expression(order.getProperty());
                    }
                    throw e;
                }
                if (order.isIgnoreCase()) {
                    expression = JpqlQueryBuilder.function(this.templates.getIgnoreCaseOperator(), expression);
                }
                select.orderBy(JpqlQueryBuilder.orderBy(expression, order));
            }
        } else if (this.searchQuery && (distanceFunction = DISTANCE_FUNCTIONS.get(this.provider.getScoringFunction())) != null) {
            select.orderBy(JpqlQueryBuilder.orderBy(JpqlQueryBuilder.expression("distance"), distanceFunction.direction()));
        }
        return select;
    }

    private JpqlQueryBuilder.Select doSelect(Sort sort) {
        JpqlQueryBuilder.Expression distance;
        JpqlQueryBuilder.SelectStep selectStep = JpqlQueryBuilder.selectFrom(this.entity);
        if (this.tree.isDelete()) {
            return selectStep.entity();
        }
        if (this.tree.isDistinct()) {
            selectStep = selectStep.distinct();
        }
        if (this.returnedType.needsCustomConstruction()) {
            Collection requiredSelection = null;
            requiredSelection = this.returnedType.getReturnedType().getPackageName().startsWith("java.util") || this.returnedType.getReturnedType().getPackageName().startsWith("jakarta.persistence") ? (Collection)this.metamodel.managedType(this.returnedType.getDomainType()).getAttributes().stream().map(Attribute::getName).collect(Collectors.toList()) : this.getRequiredSelection(sort, this.returnedType);
            ArrayList<JpqlQueryBuilder.Expression> paths = new ArrayList<JpqlQueryBuilder.Expression>(requiredSelection.size());
            for (String selection : requiredSelection) {
                paths.add(JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)selection, (Class)this.returnedType.getDomainType()), true));
            }
            JpqlQueryBuilder.Expression distance2 = null;
            if (this.searchQuery) {
                distance2 = this.getDistanceExpression();
            }
            if (this.useTupleQuery()) {
                if (this.searchQuery) {
                    paths.add((distance2 != null ? distance2 : JpqlQueryBuilder.literal(0)).as("distance"));
                }
                return selectStep.select(paths);
            }
            JpqlQueryBuilder.ConstructorExpression expression = new JpqlQueryBuilder.ConstructorExpression(this.returnedType.getReturnedType().getName(), new JpqlQueryBuilder.Multiselect(this.entity, paths));
            ArrayList<JpqlQueryBuilder.Expression> selection = new ArrayList<JpqlQueryBuilder.Expression>(2);
            selection.add(expression);
            if (this.searchQuery) {
                selection.add((distance2 != null ? distance2 : JpqlQueryBuilder.literal(0)).as("distance"));
            }
            return selectStep.select(selection);
        }
        if (this.searchQuery && (distance = this.getDistanceExpression()) != null) {
            return selectStep.select(new JpqlQueryBuilder.Multiselect(this.entity, Arrays.asList(new JpqlQueryBuilder.EntitySelection(this.entity), distance.as("distance"))));
        }
        if (this.tree.isExistsProjection()) {
            if (this.entityType.hasSingleIdAttribute()) {
                SingularAttribute id = this.entityType.getId(this.entityType.getIdType().getJavaType());
                return selectStep.select(JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)id.getName(), (Class)this.returnedType.getDomainType()), true));
            }
            List<JpqlQueryBuilder.PathExpression> paths = this.entityType.getIdClassAttributes().stream().map(it -> JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, PropertyPath.from((String)it.getName(), (Class)this.returnedType.getDomainType()), true)).toList();
            return selectStep.select(paths);
        }
        if (this.tree.isCountProjection()) {
            return selectStep.count();
        }
        return selectStep.entity();
    }

    private @Nullable JpqlQueryBuilder.Expression getDistanceExpression() {
        DistanceFunction distanceFunction = DISTANCE_FUNCTIONS.get(this.provider.getScoringFunction());
        if (distanceFunction != null) {
            JpqlQueryBuilder.PathExpression pas = JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.entityType, this.getVectorPath(), true);
            return JpqlQueryBuilder.function(distanceFunction.distanceFunction(), pas, this.placeholder(this.provider.getVectorBinding()));
        }
        return null;
    }

    PropertyPath getVectorPath() {
        for (PartTree.OrPart parts : this.tree) {
            for (Part part : parts) {
                if (part.getType() != Part.Type.NEAR && part.getType() != Part.Type.WITHIN) continue;
                return part.getProperty();
            }
        }
        throw new IllegalStateException("No vector path found");
    }

    Collection<String> getRequiredSelection(Sort sort, ReturnedType returnedType) {
        return returnedType.getInputProperties();
    }

    JpqlQueryBuilder.Expression placeholder(ParameterBinding binding) {
        if (this.useNamedParameters && binding.hasName()) {
            return JpqlQueryBuilder.parameter(JpqlQueryBuilder.ParameterPlaceholder.named(binding.getRequiredName()));
        }
        return JpqlQueryBuilder.parameter(JpqlQueryBuilder.ParameterPlaceholder.indexed(binding.getRequiredPosition()));
    }

    private JpqlQueryBuilder.Predicate toPredicate(Part part) {
        return new PredicateBuilder(part, this.similarityNormalizer).build();
    }

    record DistanceFunction(String distanceFunction, Sort.Direction direction) {
    }

    private class PredicateBuilder {
        private final Part part;
        private final SimilarityNormalizer normalizer;

        public PredicateBuilder(Part part, SimilarityNormalizer normalizer) {
            this.part = part;
            this.normalizer = normalizer;
        }

        public JpqlQueryBuilder.Predicate build() {
            PropertyPath property = this.part.getProperty();
            Part.Type type = this.part.getType();
            JpqlQueryBuilder.PathExpression pas = JpqlUtils.toExpressionRecursively(JpaQueryCreator.this.metamodel, JpaQueryCreator.this.entity, JpaQueryCreator.this.entityType, property);
            JpqlQueryBuilder.WhereStep where = JpqlQueryBuilder.where(pas);
            JpqlQueryBuilder.WhereStep whereIgnoreCase = JpqlQueryBuilder.where(this.potentiallyIgnoreCase(pas));
            switch (type) {
                case BETWEEN: {
                    ParameterBinding.PartTreeParameterBinding first = JpaQueryCreator.this.provider.next(this.part);
                    ParameterBinding.PartTreeParameterBinding second = JpaQueryCreator.this.provider.next(this.part);
                    return where.between(JpaQueryCreator.this.placeholder(first), JpaQueryCreator.this.placeholder(second));
                }
                case GREATER_THAN: 
                case AFTER: {
                    return where.gt(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case GREATER_THAN_EQUAL: {
                    return where.gte(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case LESS_THAN: 
                case BEFORE: {
                    return where.lt(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case LESS_THAN_EQUAL: {
                    return where.lte(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                }
                case IS_NULL: {
                    return where.isNull();
                }
                case IS_NOT_NULL: {
                    return where.isNotNull();
                }
                case NOT_IN: {
                    return whereIgnoreCase.notIn(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part, Collection.class)));
                }
                case IN: {
                    return whereIgnoreCase.in(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part, Collection.class)));
                }
                case STARTING_WITH: 
                case ENDING_WITH: 
                case NOT_CONTAINING: 
                case CONTAINING: {
                    if (property.getLeafProperty().isCollection()) {
                        where = JpqlQueryBuilder.where(JpaQueryCreator.this.entity, property);
                        return type.equals((Object)Part.Type.NOT_CONTAINING) ? where.notMemberOf(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part))) : where.memberOf(JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.next(this.part)));
                    }
                }
                case NOT_LIKE: 
                case LIKE: {
                    ParameterBinding.PartTreeParameterBinding parameter = JpaQueryCreator.this.provider.next(this.part, String.class);
                    JpqlQueryBuilder.Expression parameterExpression = this.potentiallyIgnoreCase(this.part.getProperty(), JpaQueryCreator.this.placeholder(parameter));
                    String escapeChar = Character.toString(JpaQueryCreator.this.escape.getEscapeCharacter());
                    return type.equals((Object)Part.Type.NOT_LIKE) || type.equals((Object)Part.Type.NOT_CONTAINING) ? whereIgnoreCase.notLike(parameterExpression, escapeChar) : whereIgnoreCase.like(parameterExpression, escapeChar);
                }
                case TRUE: {
                    return where.isTrue();
                }
                case FALSE: {
                    return where.isFalse();
                }
                case NEGATING_SIMPLE_PROPERTY: 
                case SIMPLE_PROPERTY: {
                    ParameterBinding.PartTreeParameterBinding simple = JpaQueryCreator.this.provider.next(this.part);
                    if (simple.isIsNullParameter()) {
                        return type.equals((Object)Part.Type.SIMPLE_PROPERTY) ? where.isNull() : where.isNotNull();
                    }
                    JpqlQueryBuilder.Expression expression = this.potentiallyIgnoreCase(property, JpaQueryCreator.this.placeholder(simple));
                    return type.equals((Object)Part.Type.SIMPLE_PROPERTY) ? whereIgnoreCase.eq(expression) : whereIgnoreCase.neq(expression);
                }
                case IS_NOT_EMPTY: 
                case IS_EMPTY: {
                    if (!property.getLeafProperty().isCollection()) {
                        throw new IllegalArgumentException("IsEmpty / IsNotEmpty can only be used on collection properties");
                    }
                    where = JpqlQueryBuilder.where(JpaQueryCreator.this.entity, property);
                    return type.equals((Object)Part.Type.IS_NOT_EMPTY) ? where.isNotEmpty() : where.isEmpty();
                }
                case NEAR: 
                case WITHIN: {
                    Object object;
                    JpqlQueryBuilder.Expression distance;
                    Range r;
                    Range range;
                    ParameterBinding.PartTreeParameterBinding vector = JpaQueryCreator.this.provider.next(this.part);
                    ParameterBinding.PartTreeParameterBinding within = JpaQueryCreator.this.provider.next(this.part);
                    Object object2 = within.getValue();
                    if (object2 instanceof Range && ((range = (r = (Range)object2)).getUpperBound().isBounded() || range.getUpperBound().isBounded())) {
                        JpqlQueryBuilder.Expression distanceValue;
                        Range.Bound lower = range.getLowerBound();
                        Range.Bound upper = range.getUpperBound();
                        String distanceFunction = PredicateBuilder.getDistanceFunction(JpaQueryCreator.this.provider.getScoringFunction());
                        distance = JpqlQueryBuilder.function(distanceFunction, pas, JpaQueryCreator.this.placeholder(vector));
                        JpqlQueryBuilder.Predicate lowerPredicate = null;
                        JpqlQueryBuilder.Predicate upperPredicate = null;
                        if (lower.isBounded()) {
                            distanceValue = JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.lower(within, this.normalizer));
                            lowerPredicate = this.getUpperPredicate(lower.isInclusive(), distance, distanceValue);
                        }
                        if (upper.isBounded()) {
                            distanceValue = JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.upper(within, this.normalizer));
                            upperPredicate = this.getLowerPredicate(upper.isInclusive(), distance, distanceValue);
                        }
                        if (lowerPredicate != null && upperPredicate != null) {
                            return lowerPredicate.and(upperPredicate);
                        }
                        if (lowerPredicate != null) {
                            return lowerPredicate;
                        }
                        if (upperPredicate != null) {
                            return upperPredicate;
                        }
                    }
                    if ((object = within.getValue()) instanceof Score) {
                        Score score = (Score)object;
                        String distanceFunction = PredicateBuilder.getDistanceFunction(score.getFunction());
                        JpqlQueryBuilder.Expression distanceValue = JpaQueryCreator.this.placeholder(JpaQueryCreator.this.provider.normalize(within, this.normalizer));
                        distance = JpqlQueryBuilder.function(distanceFunction, pas, JpaQueryCreator.this.placeholder(vector));
                        return this.getUpperPredicate(true, distance, distanceValue);
                    }
                    throw new InvalidDataAccessApiUsageException("Near/Within keywords must be used with a Score or Range<Score> type");
                }
            }
            throw new IllegalArgumentException("Unsupported keyword " + String.valueOf(type));
        }

        private JpqlQueryBuilder.Predicate getLowerPredicate(boolean inclusive, JpqlQueryBuilder.Expression lhs, JpqlQueryBuilder.Expression distance) {
            return PredicateBuilder.doLower(inclusive, lhs, distance);
        }

        private JpqlQueryBuilder.Predicate getUpperPredicate(boolean inclusive, JpqlQueryBuilder.Expression lhs, JpqlQueryBuilder.Expression distance) {
            return PredicateBuilder.doUpper(inclusive, lhs, distance);
        }

        private static JpqlQueryBuilder.Predicate doLower(boolean inclusive, JpqlQueryBuilder.Expression lhs, JpqlQueryBuilder.Expression distance) {
            return inclusive ? JpqlQueryBuilder.where(lhs).gte(distance) : JpqlQueryBuilder.where(lhs).gt(distance);
        }

        private static JpqlQueryBuilder.Predicate doUpper(boolean inclusive, JpqlQueryBuilder.Expression lhs, JpqlQueryBuilder.Expression distance) {
            return inclusive ? JpqlQueryBuilder.where(lhs).lte(distance) : JpqlQueryBuilder.where(lhs).lt(distance);
        }

        private static String getDistanceFunction(ScoringFunction scoringFunction) {
            DistanceFunction distanceFunction = DISTANCE_FUNCTIONS.get(scoringFunction);
            if (distanceFunction == null) {
                throw new IllegalArgumentException("Unsupported ScoringFunction: %s. Make sure to declare a supported ScoringFunction when creating Score/Similarity instances.".formatted(scoringFunction.getName()));
            }
            return distanceFunction.distanceFunction();
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(JpqlQueryBuilder.Origin source, PropertyPath path) {
            return this.potentiallyIgnoreCase(path, JpqlQueryBuilder.expression(source, path));
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(JpqlQueryBuilder.PathExpression path) {
            return this.potentiallyIgnoreCase(path.getPropertyPath(), path);
        }

        private <T> JpqlQueryBuilder.Expression potentiallyIgnoreCase(PropertyPath path, JpqlQueryBuilder.Expression expressionValue) {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: {
                    Assert.isTrue((boolean)this.canUpperCase(path), (String)("Unable to ignore case of " + path.getType().getName() + " types, the property '" + this.part.getProperty().getSegment() + "' must reference a String"));
                    return JpqlQueryBuilder.function(JpaQueryCreator.this.templates.getIgnoreCaseOperator(), expressionValue);
                }
                case WHEN_POSSIBLE: {
                    if (!this.canUpperCase(path)) break;
                    return JpqlQueryBuilder.function(JpaQueryCreator.this.templates.getIgnoreCaseOperator(), expressionValue);
                }
            }
            return expressionValue;
        }

        private boolean canUpperCase(PropertyPath path) {
            return String.class.equals((Object)path.getType());
        }
    }
}

