/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.lang.Contract;

public final class EscapeCharacter {
    public static final EscapeCharacter DEFAULT = EscapeCharacter.of('\\');
    private static final List<String> TO_REPLACE = Arrays.asList("_", "%");
    private final char escapeCharacter;

    private EscapeCharacter(char escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public static EscapeCharacter of(char escapeCharacter) {
        return new EscapeCharacter(escapeCharacter);
    }

    @Nullable
    @Contract(value="null -> null")
    public String escape(@Nullable String value) {
        return value == null ? null : Stream.concat(Stream.of(String.valueOf(this.escapeCharacter)), TO_REPLACE.stream()).reduce(value, (it, character) -> it.replace((CharSequence)character, this.escapeCharacter + character));
    }

    public char getEscapeCharacter() {
        return this.escapeCharacter;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void that;
        if (this == o) {
            return true;
        }
        if (!(o instanceof EscapeCharacter)) {
            return false;
        }
        EscapeCharacter escapeCharacter = (EscapeCharacter)o;
        return this.escapeCharacter == that.escapeCharacter;
    }

    public int hashCode() {
        return this.escapeCharacter;
    }

    public String toString() {
        return "EscapeCharacter(escapeCharacter=" + this.getEscapeCharacter() + ")";
    }
}

