/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.JpqlUtils;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.mapping.PropertyPath;

public record KeysetScrollSpecification<T>(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) implements Specification<T>
{
    public KeysetScrollSpecification(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) {
        this.position = position;
        this.entity = entity;
        this.sort = KeysetScrollSpecification.createSort(position, sort, entity);
    }

    public static Sort createSort(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) {
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(position.getDirection());
        return delegate.createSort(sort, entity);
    }

    @Override
    @Nullable
    public Predicate toPredicate(Root<T> root, @Nullable CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        return this.createPredicate(root, criteriaBuilder);
    }

    @Nullable
    public Predicate createPredicate(Root<?> root, CriteriaBuilder criteriaBuilder) {
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(this.position.getDirection());
        return delegate.createPredicate(this.position, this.sort, new CriteriaBuilderStrategy((From<?, ?>)root, criteriaBuilder));
    }

    public @Nullable JpqlQueryBuilder.Predicate createJpqlPredicate(Bindable<?> from, JpqlQueryBuilder.Entity entity, ParameterFactory factory) {
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(this.position.getDirection());
        return delegate.createPredicate(this.position, this.sort, new JpqlStrategy(null, from, entity, factory));
    }

    private static class CriteriaBuilderStrategy
    implements KeysetScrollDelegate.QueryStrategy<Expression<Comparable>, Predicate> {
        private final From<?, ?> from;
        private final CriteriaBuilder cb;

        public CriteriaBuilderStrategy(From<?, ?> from, CriteriaBuilder cb) {
            this.from = from;
            this.cb = cb;
        }

        @Override
        public Expression<Comparable> createExpression(String property) {
            PropertyPath path = PropertyPath.from((String)property, (Class)this.from.getJavaType());
            return QueryUtils.toExpressionRecursively(this.from, path);
        }

        @Override
        public Predicate compare(Sort.Order order, Expression<Comparable> propertyExpression, @Nullable Object value) {
            if (value instanceof Comparable) {
                Comparable compareValue = (Comparable)value;
                return order.isAscending() ? this.cb.greaterThan(propertyExpression, compareValue) : this.cb.lessThan(propertyExpression, compareValue);
            }
            return order.isAscending() ? this.cb.isNull(propertyExpression) : this.cb.isNotNull(propertyExpression);
        }

        @Override
        public Predicate compare(Expression<Comparable> propertyExpression, @Nullable Object value) {
            return value == null ? this.cb.isNull(propertyExpression) : this.cb.equal(propertyExpression, value);
        }

        @Override
        public Predicate and(List<Predicate> intermediate) {
            return this.cb.and(intermediate.toArray(new Predicate[0]));
        }

        @Override
        public Predicate or(List<Predicate> intermediate) {
            return this.cb.or(intermediate.toArray(new Predicate[0]));
        }
    }

    private static class JpqlStrategy
    implements KeysetScrollDelegate.QueryStrategy<JpqlQueryBuilder.Expression, JpqlQueryBuilder.Predicate> {
        private final Bindable<?> from;
        private final JpqlQueryBuilder.Entity entity;
        private final ParameterFactory factory;
        @Nullable
        private final Metamodel metamodel;

        public JpqlStrategy(@Nullable Metamodel metamodel, Bindable<?> from, JpqlQueryBuilder.Entity entity, ParameterFactory factory) {
            this.from = from;
            this.entity = entity;
            this.factory = factory;
            this.metamodel = metamodel;
        }

        @Override
        public JpqlQueryBuilder.Expression createExpression(String property) {
            PropertyPath path = PropertyPath.from((String)property, (Class)this.from.getBindableJavaType());
            return JpqlUtils.toExpressionRecursively(this.metamodel, this.entity, this.from, path);
        }

        @Override
        public JpqlQueryBuilder.Predicate compare(Sort.Order order, JpqlQueryBuilder.Expression propertyExpression, @Nullable Object value) {
            JpqlQueryBuilder.WhereStep where = JpqlQueryBuilder.where(propertyExpression);
            if (value == null) {
                return order.isAscending() ? where.isNull() : where.isNotNull();
            }
            return order.isAscending() ? where.gt(this.factory.capture(value)) : where.lt(this.factory.capture(value));
        }

        @Override
        public JpqlQueryBuilder.Predicate compare(JpqlQueryBuilder.Expression propertyExpression, @Nullable Object value) {
            JpqlQueryBuilder.WhereStep where = JpqlQueryBuilder.where(propertyExpression);
            return value == null ? where.isNull() : where.eq(this.factory.capture(value));
        }

        @Override
        public @Nullable JpqlQueryBuilder.Predicate and(List<JpqlQueryBuilder.Predicate> intermediate) {
            return JpqlQueryBuilder.and(intermediate);
        }

        @Override
        public @Nullable JpqlQueryBuilder.Predicate or(List<JpqlQueryBuilder.Predicate> intermediate) {
            return JpqlQueryBuilder.or(intermediate);
        }
    }

    public static interface ParameterFactory {
        public JpqlQueryBuilder.Expression capture(Object var1);
    }
}

