/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

class JpaKeysetScrollQueryCreator
extends JpaQueryCreator {
    private final JpaEntityInformation<?, ?> entityInformation;
    private final KeysetScrollPosition scrollPosition;
    private final ParameterMetadataProvider provider;
    private final List<ParameterBinding> syntheticBindings = new ArrayList<ParameterBinding>();

    public JpaKeysetScrollQueryCreator(PartTree tree, ReturnedType type, ParameterMetadataProvider provider, JpqlQueryTemplates templates, JpaEntityInformation<?, ?> entityInformation, KeysetScrollPosition scrollPosition, EntityManager em) {
        super(tree, type, provider, templates, em);
        this.entityInformation = entityInformation;
        this.scrollPosition = scrollPosition;
        this.provider = provider;
    }

    @Override
    public List<ParameterBinding> getBindings() {
        List<ParameterBinding> partTreeBindings = super.getBindings();
        ArrayList<ParameterBinding> bindings = new ArrayList<ParameterBinding>(partTreeBindings.size() + this.syntheticBindings.size());
        bindings.addAll(partTreeBindings);
        bindings.addAll(this.syntheticBindings);
        return bindings;
    }

    @Override
    protected JpqlQueryBuilder.AbstractJpqlQuery createQuery(@Nullable JpqlQueryBuilder.Predicate predicate, Sort sort) {
        KeysetScrollSpecification keysetSpec = new KeysetScrollSpecification(this.scrollPosition, sort, this.entityInformation);
        JpqlQueryBuilder.Select query = this.buildQuery(keysetSpec.sort());
        AtomicInteger counter = new AtomicInteger(this.provider.getBindings().size());
        JpqlQueryBuilder.Predicate keysetPredicate = keysetSpec.createJpqlPredicate(this.getFrom(), this.getEntity(), value -> {
            this.syntheticBindings.add(this.provider.nextSynthetic(value, this.scrollPosition));
            return this.placeholder(counter.incrementAndGet());
        });
        JpqlQueryBuilder.Predicate predicateToUse = JpaKeysetScrollQueryCreator.getPredicate(predicate, keysetPredicate);
        if (predicateToUse != null) {
            return query.where(predicateToUse);
        }
        return query;
    }

    private static @Nullable JpqlQueryBuilder.Predicate getPredicate(@Nullable JpqlQueryBuilder.Predicate predicate, @Nullable JpqlQueryBuilder.Predicate keysetPredicate) {
        if (keysetPredicate != null) {
            if (predicate != null) {
                return predicate.nest().and(keysetPredicate.nest());
            }
            return keysetPredicate;
        }
        return predicate;
    }

    @Override
    Collection<String> getRequiredSelection(Sort sort, ReturnedType returnedType) {
        Sort sortToUse = KeysetScrollSpecification.createSort(this.scrollPosition, sort, this.entityInformation);
        return KeysetScrollDelegate.getProjectionInputProperties(this.entityInformation, returnedType.getInputProperties(), sortToUse);
    }
}

