/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryEnhancer;
import org.springframework.data.jpa.repository.query.JSqlParserQueryEnhancer;
import org.springframework.data.jpa.repository.query.JpaQueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.util.ClassUtils;

public final class QueryEnhancerFactory {
    private static final Log LOG = LogFactory.getLog(QueryEnhancerFactory.class);
    private static final boolean jSqlParserPresent = ClassUtils.isPresent((String)"net.sf.jsqlparser.parser.JSqlParser", (ClassLoader)QueryEnhancerFactory.class.getClassLoader());

    private QueryEnhancerFactory() {
    }

    public static QueryEnhancer forQuery(DeclaredQuery query) {
        if (query.isNativeQuery()) {
            if (jSqlParserPresent) {
                return new JSqlParserQueryEnhancer(query);
            }
            return new DefaultQueryEnhancer(query);
        }
        if (PersistenceProvider.HIBERNATE.isPresent()) {
            return JpaQueryEnhancer.forHql(query);
        }
        if (PersistenceProvider.ECLIPSELINK.isPresent()) {
            return JpaQueryEnhancer.forEql(query);
        }
        return JpaQueryEnhancer.forJpql(query);
    }

    static {
        if (jSqlParserPresent) {
            LOG.info((Object)"JSqlParser is in classpath; If applicable, JSqlParser will be used");
        }
        if (PersistenceProvider.ECLIPSELINK.isPresent()) {
            LOG.info((Object)"EclipseLink is in classpath; If applicable, EQL parser will be used.");
        }
        if (PersistenceProvider.HIBERNATE.isPresent()) {
            LOG.info((Object)"Hibernate is in classpath; If applicable, HQL parser will be used.");
        }
    }
}

