/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.CollectionUtils;
import org.springframework.lang.Nullable;

public class KeysetScrollDelegate {
    private static final KeysetScrollDelegate forward = new KeysetScrollDelegate();
    private static final KeysetScrollDelegate reverse = new ReverseKeysetScrollDelegate();

    public static KeysetScrollDelegate of(KeysetScrollPosition.Direction direction) {
        return direction == KeysetScrollPosition.Direction.Forward ? forward : reverse;
    }

    @Nullable
    public <E, P> P createPredicate(KeysetScrollPosition keyset, Sort sort, QueryStrategy<E, P> strategy) {
        Map keysetValues = keyset.getKeys();
        if (keysetValues.isEmpty()) {
            return null;
        }
        ArrayList<P> or = new ArrayList<P>();
        int i = 0;
        for (Sort.Order order : sort) {
            if (!keysetValues.containsKey(order.getProperty())) {
                throw new IllegalStateException(String.format("KeysetScrollPosition does not contain all keyset values. Missing key: %s", order.getProperty()));
            }
            ArrayList<P> sortConstraint = new ArrayList<P>();
            int j = 0;
            for (Sort.Order inner : sort) {
                E propertyExpression = strategy.createExpression(inner.getProperty());
                Object o = keysetValues.get(inner.getProperty());
                if (j >= i) {
                    sortConstraint.add(strategy.compare(inner, propertyExpression, o));
                    break;
                }
                sortConstraint.add(strategy.compare(propertyExpression, o));
                ++j;
            }
            if (!sortConstraint.isEmpty()) {
                or.add(strategy.and(sortConstraint));
            }
            ++i;
        }
        if (or.isEmpty()) {
            return null;
        }
        return strategy.or(or);
    }

    protected Sort getSortOrders(Sort sort) {
        return sort;
    }

    protected <T> List<T> postProcessResults(List<T> result) {
        return result;
    }

    protected <T> List<T> getResultWindow(List<T> list, int limit) {
        return CollectionUtils.getFirst(limit, list);
    }

    public static interface QueryStrategy<E, P> {
        public E createExpression(String var1);

        public P compare(Sort.Order var1, E var2, Object var3);

        public P compare(E var1, @Nullable Object var2);

        public P and(List<P> var1);

        public P or(List<P> var1);
    }

    private static class ReverseKeysetScrollDelegate
    extends KeysetScrollDelegate {
        private ReverseKeysetScrollDelegate() {
        }

        @Override
        protected Sort getSortOrders(Sort sort) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                orders.add(new Sort.Order(order.isAscending() ? Sort.Direction.DESC : Sort.Direction.ASC, order.getProperty()));
            }
            return Sort.by(orders);
        }

        @Override
        protected <T> List<T> postProcessResults(List<T> result) {
            Collections.reverse(result);
            return result;
        }

        @Override
        protected <T> List<T> getResultWindow(List<T> list, int limit) {
            return CollectionUtils.getLast(limit, list);
        }
    }
}

