/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import java.util.Set;
import org.springframework.data.mapping.PropertyPath;

abstract class EntityGraphFactory {
    public static final String HINT = "javax.persistence.fetchgraph";

    EntityGraphFactory() {
    }

    public static <T> EntityGraph<T> create(EntityManager entityManager, Class<T> domainType, Set<String> properties) {
        EntityGraph entityGraph = entityManager.createEntityGraph(domainType);
        for (String property : properties) {
            Subgraph current = null;
            for (PropertyPath path : PropertyPath.from((String)property, domainType)) {
                if (path.hasNext()) {
                    current = current == null ? entityGraph.addSubgraph(path.getSegment()) : current.addSubgraph(path.getSegment());
                    continue;
                }
                if (current == null) {
                    entityGraph.addAttributeNodes(new String[]{path.getSegment()});
                    continue;
                }
                current.addAttributeNodes(new String[]{path.getSegment()});
            }
        }
        return entityGraph;
    }
}

