/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    public static final String DELETE_ALL_QUERY_BY_ID_STRING = "delete from %s x where %s in :ids";
    private static final String IDENTIFIER = "[._$[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{Punct}]]+";
    static final String COLON_NO_DOUBLE_COLON = "(?<![:\\\\]):";
    static final String IDENTIFIER_GROUP = String.format("(%s)", "[._$[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{Punct}]]+");
    private static final String COUNT_REPLACEMENT_TEMPLATE = "select count(%s) $5$6$7";
    private static final String SIMPLE_COUNT_VALUE = "$2";
    private static final String COMPLEX_COUNT_VALUE = "$3 $6";
    private static final String COMPLEX_COUNT_LAST_VALUE = "$6";
    private static final String ORDER_BY_PART = "(?iu)\\s+order\\s+by\\s+.*";
    private static final Pattern ALIAS_MATCH;
    private static final Pattern COUNT_MATCH;
    private static final Pattern STARTS_WITH_PAREN;
    private static final Pattern PARENS_TO_REMOVE;
    private static final Pattern PROJECTION_CLAUSE;
    private static final Pattern NO_DIGITS;
    private static final String JOIN;
    private static final Pattern JOIN_PATTERN;
    private static final String EQUALS_CONDITION_STRING = "%s.%s = :%s";
    private static final Pattern ORDER_BY;
    private static final Pattern ORDER_BY_IN_WINDOW_OR_SUBSELECT;
    private static final Pattern NAMED_PARAMETER;
    private static final Pattern CONSTRUCTOR_EXPRESSION;
    private static final Map<Attribute.PersistentAttributeType, Class<? extends Annotation>> ASSOCIATION_TYPES;
    private static final int QUERY_JOIN_ALIAS_GROUP_INDEX = 3;
    private static final int VARIABLE_NAME_GROUP_INDEX = 4;
    private static final int COMPLEX_COUNT_FIRST_INDEX = 3;
    private static final Pattern PUNCTATION_PATTERN;
    private static final Pattern FUNCTION_PATTERN;
    private static final Pattern FIELD_ALIAS_PATTERN;
    private static final String UNSAFE_PROPERTY_REFERENCE = "Sort expression '%s' must only contain property references or aliases used in the select clause; If you really want to use something other than that for sorting, please use JpaSort.unsafe(\u2026)";

    private QueryUtils() {
    }

    public static String getExistsQueryString(String entityName, String countQueryPlaceHolder, Iterable<String> idAttributes) {
        String whereClause = Streamable.of(idAttributes).stream().map(idAttribute -> String.format(EQUALS_CONDITION_STRING, "x", idAttribute, idAttribute)).collect(Collectors.joining(" AND ", " WHERE ", ""));
        return String.format(COUNT_QUERY_STRING, countQueryPlaceHolder, entityName) + whereClause;
    }

    public static String getQueryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)"Entity name must not be null or empty");
        return String.format(template, entityName);
    }

    public static String applySorting(String query, Sort sort) {
        return QueryUtils.applySorting(query, sort, QueryUtils.detectAlias(query));
    }

    public static String applySorting(String query, Sort sort, @Nullable String alias) {
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        if (sort.isUnsorted()) {
            return query;
        }
        StringBuilder builder = new StringBuilder(query);
        if (QueryUtils.hasOrderByClause(query)) {
            builder.append(", ");
        } else {
            builder.append(" order by ");
        }
        Set<String> joinAliases = QueryUtils.getOuterJoinAliases(query);
        Set<String> selectionAliases = QueryUtils.getFunctionAliases(query);
        selectionAliases.addAll(QueryUtils.getFieldAliases(query));
        for (Sort.Order order : sort) {
            builder.append(QueryUtils.getOrderClause(joinAliases, selectionAliases, alias, order)).append(", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    private static boolean hasOrderByClause(String query) {
        return QueryUtils.countOccurrences(ORDER_BY, query) > QueryUtils.countOccurrences(ORDER_BY_IN_WINDOW_OR_SUBSELECT, query);
    }

    private static int countOccurrences(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        int occurrences = 0;
        while (matcher.find()) {
            ++occurrences;
        }
        return occurrences;
    }

    private static String getOrderClause(Set<String> joinAliases, Set<String> selectionAlias, @Nullable String alias, Sort.Order order) {
        String property = order.getProperty();
        QueryUtils.checkSortExpression(order);
        if (selectionAlias.contains(property)) {
            return String.format("%s %s", order.isIgnoreCase() ? String.format("lower(%s)", property) : property, QueryUtils.toJpaDirection(order));
        }
        boolean qualifyReference = !property.contains("(");
        for (String joinAlias : joinAliases) {
            if (!property.startsWith(joinAlias.concat("."))) continue;
            qualifyReference = false;
            break;
        }
        String reference = qualifyReference && StringUtils.hasText((String)alias) ? String.format("%s.%s", alias, property) : property;
        String wrapped = order.isIgnoreCase() ? String.format("lower(%s)", reference) : reference;
        return String.format("%s %s", wrapped, QueryUtils.toJpaDirection(order));
    }

    static Set<String> getOuterJoinAliases(String query) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = JOIN_PATTERN.matcher(query);
        while (matcher.find()) {
            String alias = matcher.group(3);
            if (!StringUtils.hasText((String)alias)) continue;
            result.add(alias);
        }
        return result;
    }

    private static Set<String> getFieldAliases(String query) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = FIELD_ALIAS_PATTERN.matcher(query);
        while (matcher.find()) {
            String alias = matcher.group(1);
            if (!StringUtils.hasText((String)alias)) continue;
            result.add(alias);
        }
        return result;
    }

    static Set<String> getFunctionAliases(String query) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = FUNCTION_PATTERN.matcher(query);
        while (matcher.find()) {
            String alias = matcher.group(1);
            if (!StringUtils.hasText((String)alias)) continue;
            result.add(alias);
        }
        return result;
    }

    private static String toJpaDirection(Sort.Order order) {
        return order.getDirection().name().toLowerCase(Locale.US);
    }

    @Nullable
    @Deprecated
    public static String detectAlias(String query) {
        String alias = null;
        Matcher matcher = ALIAS_MATCH.matcher(QueryUtils.removeSubqueries(query));
        while (matcher.find()) {
            alias = matcher.group(2);
        }
        return alias;
    }

    static String removeSubqueries(String query) {
        if (!StringUtils.hasText((String)query)) {
            return query;
        }
        ArrayList<Integer> opens = new ArrayList<Integer>();
        ArrayList<Integer> closes = new ArrayList<Integer>();
        ArrayList<Boolean> closeMatches = new ArrayList<Boolean>();
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '(') {
                opens.add(i);
                continue;
            }
            if (c != ')') continue;
            closes.add(i);
            closeMatches.add(Boolean.FALSE);
        }
        StringBuilder sb = new StringBuilder(query);
        boolean startsWithParen = STARTS_WITH_PAREN.matcher(query).find();
        for (int i = opens.size() - 1; i >= (startsWithParen ? 1 : 0); --i) {
            String subquery;
            Matcher matcher;
            Integer open = (Integer)opens.get(i);
            Integer close = QueryUtils.findClose(open, closes, closeMatches) + 1;
            if (close <= open || !(matcher = PARENS_TO_REMOVE.matcher(subquery = sb.substring(open, close))).find()) continue;
            sb.replace(open, close, new String(new char[close - open]).replace('\u0000', ' '));
        }
        return sb.toString();
    }

    private static Integer findClose(Integer open, List<Integer> closes, List<Boolean> closeMatches) {
        for (int i = 0; i < closes.size(); ++i) {
            int close = closes.get(i);
            if (close <= open || closeMatches.get(i).booleanValue()) continue;
            closeMatches.set(i, Boolean.TRUE);
            return close;
        }
        return -1;
    }

    public static <T> Query applyAndBind(String queryString, Iterable<T> entities, EntityManager entityManager) {
        Assert.notNull((Object)queryString, (String)"Querystring must not be null");
        Assert.notNull(entities, (String)"Iterable of entities must not be null");
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null");
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = QueryUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            builder.append(String.format(" %s = ?%d", alias, ++i));
            if (!iterator.hasNext()) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        iterator = entities.iterator();
        i = 0;
        while (iterator.hasNext()) {
            query.setParameter(++i, iterator.next());
        }
        return query;
    }

    @Deprecated
    public static String createCountQueryFor(String originalQuery) {
        return QueryUtils.createCountQueryFor(originalQuery, null);
    }

    @Deprecated
    public static String createCountQueryFor(String originalQuery, @Nullable String countProjection) {
        String countQuery;
        Assert.hasText((String)originalQuery, (String)"OriginalQuery must not be null or empty");
        Matcher matcher = COUNT_MATCH.matcher(originalQuery);
        if (countProjection == null) {
            String variable = matcher.matches() ? matcher.group(4) : null;
            boolean useVariable = StringUtils.hasText((String)variable) && !variable.startsWith("new") && !variable.startsWith(" new") && !variable.startsWith("count(") && !variable.contains(",");
            String complexCountValue = matcher.matches() && StringUtils.hasText((String)matcher.group(3)) ? COMPLEX_COUNT_VALUE : COMPLEX_COUNT_LAST_VALUE;
            String replacement = useVariable ? SIMPLE_COUNT_VALUE : complexCountValue;
            String alias = QueryUtils.detectAlias(originalQuery);
            if ("*".equals(variable) && alias != null) {
                replacement = alias;
            }
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, replacement));
        } else {
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, countProjection));
        }
        return countQuery.replaceFirst(ORDER_BY_PART, "");
    }

    public static boolean hasNamedParameter(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        for (Parameter parameter : query.getParameters()) {
            String name = parameter.getName();
            if (name == null || !NO_DIGITS.matcher(name).find()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    static boolean hasNamedParameter(@Nullable String query) {
        return StringUtils.hasText((String)query) && NAMED_PARAMETER.matcher(query).find();
    }

    public static List<Order> toOrders(Sort sort, From<?, ?> from, CriteriaBuilder cb) {
        if (sort.isUnsorted()) {
            return Collections.emptyList();
        }
        Assert.notNull(from, (String)"From must not be null");
        Assert.notNull((Object)cb, (String)"CriteriaBuilder must not be null");
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort) {
            orders.add(QueryUtils.toJpaOrder(order, from, cb));
        }
        return orders;
    }

    public static boolean hasConstructorExpression(String query) {
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        return CONSTRUCTOR_EXPRESSION.matcher(query).find();
    }

    public static String getProjection(String query) {
        Assert.hasText((String)query, (String)"Query must not be null or empty");
        Matcher matcher = PROJECTION_CLAUSE.matcher(query);
        String projection = matcher.find() ? matcher.group(1) : "";
        return projection.trim();
    }

    private static Order toJpaOrder(Sort.Order order, From<?, ?> from, CriteriaBuilder cb) {
        PropertyPath property = PropertyPath.from((String)order.getProperty(), (Class)from.getJavaType());
        Expression expression = QueryUtils.toExpressionRecursively(from, property);
        if (order.isIgnoreCase() && String.class.equals((Object)expression.getJavaType())) {
            Expression upper = cb.lower(expression);
            return order.isAscending() ? cb.asc(upper) : cb.desc(upper);
        }
        return order.isAscending() ? cb.asc(expression) : cb.desc(expression);
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property) {
        return QueryUtils.toExpressionRecursively(from, property, false);
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property, boolean isForSelection) {
        return QueryUtils.toExpressionRecursively(from, property, isForSelection, false);
    }

    static <T> Expression<T> toExpressionRecursively(From<?, ?> from, PropertyPath property, boolean isForSelection, boolean hasRequiredOuterJoin) {
        String segment = property.getSegment();
        boolean isLeafProperty = !property.hasNext();
        boolean requiresOuterJoin = QueryUtils.requiresOuterJoin(from, property, isForSelection, hasRequiredOuterJoin);
        if (!requiresOuterJoin && isLeafProperty) {
            return from.get(segment);
        }
        JoinType joinType = requiresOuterJoin ? JoinType.LEFT : JoinType.INNER;
        Join<?, ?> join = QueryUtils.getOrCreateJoin(from, segment, joinType);
        if (isLeafProperty) {
            return join;
        }
        PropertyPath nextProperty = Objects.requireNonNull(property.next(), "An element of the property path is null");
        return QueryUtils.toExpressionRecursively(join, nextProperty, isForSelection, requiresOuterJoin);
    }

    private static boolean requiresOuterJoin(From<?, ?> from, PropertyPath property, boolean isForSelection, boolean hasRequiredOuterJoin) {
        boolean isInverseOptionalOneToOne;
        boolean isLeafProperty;
        String segment = property.getSegment();
        if (QueryUtils.isAlreadyInnerJoined(from, segment)) {
            return false;
        }
        Bindable model = from.getModel();
        ManagedType managedType = null;
        if (model instanceof ManagedType) {
            managedType = (ManagedType)model;
        } else if (model instanceof SingularAttribute && ((SingularAttribute)model).getType() instanceof ManagedType) {
            managedType = (ManagedType)((SingularAttribute)model).getType();
        }
        Bindable propertyPathModel = managedType != null ? (Bindable)managedType.getAttribute(segment) : from.get(segment).getModel();
        boolean isPluralAttribute = model instanceof PluralAttribute;
        boolean bl = isLeafProperty = !property.hasNext();
        if (propertyPathModel == null && isPluralAttribute) {
            return true;
        }
        if (!(propertyPathModel instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)propertyPathModel;
        if (!ASSOCIATION_TYPES.containsKey(attribute.getPersistentAttributeType())) {
            return false;
        }
        boolean isCollection = attribute.isCollection();
        boolean bl2 = isInverseOptionalOneToOne = Attribute.PersistentAttributeType.ONE_TO_ONE == attribute.getPersistentAttributeType() && StringUtils.hasText((String)QueryUtils.getAnnotationProperty(attribute, "mappedBy", ""));
        if (!(!isLeafProperty || isForSelection || isCollection || isInverseOptionalOneToOne || hasRequiredOuterJoin)) {
            return false;
        }
        return hasRequiredOuterJoin || QueryUtils.getAnnotationProperty(attribute, "optional", true) != false;
    }

    @Nullable
    private static <T> T getAnnotationProperty(Attribute<?, ?> attribute, String propertyName, T defaultValue) {
        Class<? extends Annotation> associationAnnotation = ASSOCIATION_TYPES.get(attribute.getPersistentAttributeType());
        if (associationAnnotation == null) {
            return defaultValue;
        }
        Member member = attribute.getJavaMember();
        if (!(member instanceof AnnotatedElement)) {
            return defaultValue;
        }
        Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)((AnnotatedElement)((Object)member)), associationAnnotation);
        return (T)(annotation == null ? defaultValue : AnnotationUtils.getValue((Annotation)annotation, (String)propertyName));
    }

    private static Join<?, ?> getOrCreateJoin(From<?, ?> from, String attribute, JoinType joinType) {
        for (Join join : from.getJoins()) {
            if (!join.getAttribute().getName().equals(attribute)) continue;
            return join;
        }
        return from.join(attribute, joinType);
    }

    private static boolean isAlreadyInnerJoined(From<?, ?> from, String attribute) {
        for (Fetch fetch : from.getFetches()) {
            if (!fetch.getAttribute().getName().equals(attribute) || !fetch.getJoinType().equals((Object)JoinType.INNER)) continue;
            return true;
        }
        for (Join join : from.getJoins()) {
            if (!join.getAttribute().getName().equals(attribute) || !join.getJoinType().equals((Object)JoinType.INNER)) continue;
            return true;
        }
        return false;
    }

    static void checkSortExpression(Sort.Order order) {
        if (order instanceof JpaSort.JpaOrder && ((JpaSort.JpaOrder)order).isUnsafe()) {
            return;
        }
        if (PUNCTATION_PATTERN.matcher(order.getProperty()).find()) {
            throw new InvalidDataAccessApiUsageException(String.format(UNSAFE_PROPERTY_REFERENCE, order));
        }
    }

    static {
        STARTS_WITH_PAREN = Pattern.compile("^\\s*\\(");
        PARENS_TO_REMOVE = Pattern.compile("(\\(.*\\bfrom\\b[^)]+\\))", 2);
        PROJECTION_CLAUSE = Pattern.compile("select\\s+(?:distinct\\s+)?(.+)\\s+from", 2);
        NO_DIGITS = Pattern.compile("\\D+");
        JOIN = "join\\s+(fetch\\s+)?[._$[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{Punct}]]+\\s+(as\\s+)?" + IDENTIFIER_GROUP;
        JOIN_PATTERN = Pattern.compile(JOIN, 2);
        ORDER_BY = Pattern.compile("(order\\s+by\\s+)", 2);
        ORDER_BY_IN_WINDOW_OR_SUBSELECT = Pattern.compile("\\([\\s\\S]*order\\s+by\\s[\\s\\S]*\\)", 2);
        NAMED_PARAMETER = Pattern.compile("(?<![:\\\\]):[._$[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{Punct}]]+|#[._$[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{Punct}]]+", 2);
        PUNCTATION_PATTERN = Pattern.compile(".*((?![._])[\\p{Punct}|\\s])");
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=\\bfrom)");
        builder.append("(?:\\s)+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?:\\sas)*");
        builder.append("(?:\\s)+");
        builder.append("(?!(?:where|group\\s*by|order\\s*by))(\\w+)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("\\s*");
        builder.append("(select\\s+((distinct)?((?s).+?)?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
        COUNT_MATCH = Pattern.compile(builder.toString(), 34);
        HashMap<Attribute.PersistentAttributeType, Class> persistentAttributeTypes = new HashMap<Attribute.PersistentAttributeType, Class>();
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_ONE, OneToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ONE_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_ONE, ManyToOne.class);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.MANY_TO_MANY, null);
        persistentAttributeTypes.put(Attribute.PersistentAttributeType.ELEMENT_COLLECTION, null);
        ASSOCIATION_TYPES = Collections.unmodifiableMap(persistentAttributeTypes);
        builder = new StringBuilder();
        builder.append("select");
        builder.append("\\s+");
        builder.append("(.*\\s+)?");
        builder.append("new");
        builder.append("\\s+");
        builder.append(IDENTIFIER);
        builder.append("\\s*");
        builder.append("\\(");
        builder.append(".*");
        builder.append("\\)");
        CONSTRUCTOR_EXPRESSION = Pattern.compile(builder.toString(), 34);
        builder = new StringBuilder();
        builder.append("\\w+\\s*\\([\\w\\.,\\s'=:\\\\?]+\\)");
        builder.append("\\s+[as|AS]+\\s+(([\\w\\.]+))");
        FUNCTION_PATTERN = Pattern.compile(builder.toString());
        builder = new StringBuilder();
        builder.append("\\s+");
        builder.append("[^\\s\\(\\)]+");
        builder.append("\\s+[as|AS]+\\s+(([\\w\\.]+))");
        FIELD_ALIAS_PATTERN = Pattern.compile(builder.toString());
    }
}

