/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EmptyDeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryParameterSetterFactory;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.util.StreamUtils;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

class ParameterBinderFactory {
    ParameterBinderFactory() {
    }

    static ParameterBinder createBinder(JpaParameters parameters) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        QueryParameterSetterFactory setterFactory = QueryParameterSetterFactory.basic(parameters);
        List<StringQuery.ParameterBinding> bindings = ParameterBinderFactory.getBindings(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, setterFactory));
    }

    static ParameterBinder createCriteriaBinder(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull(metadata, (String)"Parameter metadata must not be null!");
        QueryParameterSetterFactory setterFactory = QueryParameterSetterFactory.forCriteriaQuery(parameters, metadata);
        List<StringQuery.ParameterBinding> bindings = ParameterBinderFactory.getBindings(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, setterFactory));
    }

    static ParameterBinder createQueryAwareBinder(JpaParameters parameters, DeclaredQuery query, SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull((Object)query, (String)"StringQuery must not be null!");
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        List<StringQuery.ParameterBinding> bindings = query.getParameterBindings();
        QueryParameterSetterFactory expressionSetterFactory = QueryParameterSetterFactory.parsing(parser, evaluationContextProvider, parameters);
        QueryParameterSetterFactory basicSetterFactory = QueryParameterSetterFactory.basic(parameters);
        return new ParameterBinder(parameters, ParameterBinderFactory.createSetters(bindings, query, expressionSetterFactory, basicSetterFactory), !query.usesPaging());
    }

    private static List<StringQuery.ParameterBinding> getBindings(JpaParameters parameters) {
        ArrayList<StringQuery.ParameterBinding> result = new ArrayList<StringQuery.ParameterBinding>();
        int bindableParameterIndex = 0;
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!parameter.isBindable()) continue;
            result.add(new StringQuery.ParameterBinding(++bindableParameterIndex));
        }
        return result;
    }

    private static Iterable<QueryParameterSetter> createSetters(List<StringQuery.ParameterBinding> parameterBindings, QueryParameterSetterFactory ... factories) {
        return ParameterBinderFactory.createSetters(parameterBindings, EmptyDeclaredQuery.EMPTY_QUERY, factories);
    }

    private static Iterable<QueryParameterSetter> createSetters(List<StringQuery.ParameterBinding> parameterBindings, DeclaredQuery declaredQuery, QueryParameterSetterFactory ... strategies) {
        return (Iterable)parameterBindings.stream().map(it -> ParameterBinderFactory.createQueryParameterSetter(it, strategies, declaredQuery)).collect(StreamUtils.toUnmodifiableList());
    }

    private static QueryParameterSetter createQueryParameterSetter(StringQuery.ParameterBinding binding, QueryParameterSetterFactory[] strategies, DeclaredQuery declaredQuery) {
        return Arrays.stream(strategies).map(it -> it.create(binding, declaredQuery)).filter(Objects::nonNull).findFirst().orElse(QueryParameterSetter.NOOP);
    }
}

