/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";

    public String getRepositoryFactoryClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "jpa";
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)(transactionManagerRef == null ? DEFAULT_TRANSACTION_MANAGER_BEAN_NAME : transactionManagerRef));
        builder.addPropertyValue("entityManager", (Object)JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(source, source.getSource()));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), (Object)source);
        if (!registry.containsBeanDefinition("jpaMappingContext")) {
            registry.registerBeanDefinition("jpaMappingContext", (BeanDefinition)new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class));
        }
        if (!JpaRepositoryConfigExtension.hasBean(PAB_POST_PROCESSOR, (BeanDefinitionRegistry)registry) && !registry.containsBeanDefinition("org.springframework.context.annotation.internalPersistenceAnnotationProcessor")) {
            JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)new RootBeanDefinition(PAB_POST_PROCESSOR), (Object)source);
        }
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        String entityManagerFactoryRef = config == null ? null : config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef == null ? "entityManagerFactory" : entityManagerFactoryRef;
    }
}

