/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";

    public String getRepositoryFactoryClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "jpa";
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        this.postProcess(builder, element.getAttribute("transaction-manager-ref"), element.getAttribute("entity-manager-factory-ref"), config.getSource());
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        this.postProcess(builder, attributes.getString("transactionManagerRef"), attributes.getString("entityManagerFactoryRef"), config.getSource());
    }

    private void postProcess(BeanDefinitionBuilder builder, String transactionManagerRef, String entityManagerRef, Object source) {
        transactionManagerRef = StringUtils.hasText((String)transactionManagerRef) ? transactionManagerRef : DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)transactionManagerRef);
        if (StringUtils.hasText((String)entityManagerRef)) {
            builder.addPropertyValue("entityManager", (Object)this.getEntityManagerBeanDefinitionFor(entityManagerRef, source));
        }
    }

    private BeanDefinition getEntityManagerBeanDefinitionFor(String entityManagerFactoryBeanName, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(entityManagerFactoryBeanName);
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        Object source = configurationSource.getSource();
        JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), (Object)source);
        if (!JpaRepositoryConfigExtension.hasBean(PAB_POST_PROCESSOR, (BeanDefinitionRegistry)registry) && !registry.containsBeanDefinition("org.springframework.context.annotation.internalPersistenceAnnotationProcessor")) {
            JpaRepositoryConfigExtension.registerWithSourceAndGeneratedBeanName((BeanDefinitionRegistry)registry, (AbstractBeanDefinition)new RootBeanDefinition(PAB_POST_PROCESSOR), (Object)source);
        }
    }
}

