/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.config.JpaMetamodelMappingContextFactoryBean;
import org.springframework.data.jpa.repository.support.DefaultJpaContext;
import org.springframework.data.jpa.repository.support.EntityManagerBeanDefinitionRegistrarPostProcessor;
import org.springframework.data.jpa.repository.support.JpaEvaluationContextExtension;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.orm.jpa.support.PersistenceAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;

public class JpaRepositoryConfigExtension
extends RepositoryConfigurationExtensionSupport {
    private static final Class<?> PAB_POST_PROCESSOR = PersistenceAnnotationBeanPostProcessor.class;
    private static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String ESCAPE_CHARACTER_PROPERTY = "escapeCharacter";

    public String getModuleName() {
        return "JPA";
    }

    public String getRepositoryFactoryClassName() {
        return JpaRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return this.getModuleName().toLowerCase(Locale.US);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(Entity.class, MappedSuperclass.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(JpaRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        Character escapeCharacter = JpaRepositoryConfigExtension.getEscapeCharacter(source);
        String transactionManagerRef = source.getAttribute("transactionManagerRef");
        builder.addPropertyValue(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME, (Object)(transactionManagerRef == null ? DEFAULT_TRANSACTION_MANAGER_BEAN_NAME : transactionManagerRef));
        builder.addPropertyValue("entityManager", (Object)JpaRepositoryConfigExtension.getEntityManagerBeanDefinitionFor(source, source.getSource()));
        builder.addPropertyValue(ESCAPE_CHARACTER_PROPERTY, (Object)Character.valueOf(escapeCharacter == null ? (char)'\\' : (char)escapeCharacter.charValue()));
        builder.addPropertyReference("mappingContext", "jpaMappingContext");
    }

    private static Character getEscapeCharacter(RepositoryConfigurationSource source) {
        if (AnnotationRepositoryConfigurationSource.class.isInstance(source)) {
            return (Character)((AnnotationRepositoryConfigurationSource)AnnotationRepositoryConfigurationSource.class.cast(source)).getAttributes().get((Object)ESCAPE_CHARACTER_PROPERTY);
        }
        String attribute = source.getAttribute(ESCAPE_CHARACTER_PROPERTY);
        return attribute == null ? null : Character.valueOf(attribute.toCharArray()[0]);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        String enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (StringUtils.hasText((String)enableDefaultTransactions)) {
            builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)enableDefaultTransactions);
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(EntityManagerBeanDefinitionRegistrarPostProcessor.class), (BeanDefinitionRegistry)registry, (String)"emBeanDefinitionRegistrarPostProcessor", (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(JpaMetamodelMappingContextFactoryBean.class), (BeanDefinitionRegistry)registry, (String)"jpaMappingContext", (Object)source);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)new RootBeanDefinition(PAB_POST_PROCESSOR), (BeanDefinitionRegistry)registry, (String)"org.springframework.context.annotation.internalPersistenceAnnotationProcessor", (Object)source);
        RootBeanDefinition contextDefinition = new RootBeanDefinition(DefaultJpaContext.class);
        contextDefinition.setAutowireMode(3);
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)contextDefinition, (BeanDefinitionRegistry)registry, (String)"jpaContext", (Object)source);
        Character escapeCharacter = JpaRepositoryConfigExtension.getEscapeCharacter(config);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JpaEvaluationContextExtension.class);
        builder.addConstructorArgValue((Object)Character.valueOf(escapeCharacter == null ? (char)'\\' : (char)escapeCharacter.charValue()));
        JpaRepositoryConfigExtension.registerIfNotAlreadyRegistered((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)registry, (String)JpaEvaluationContextExtension.class.getName(), (Object)source);
    }

    private static AbstractBeanDefinition getEntityManagerBeanDefinitionFor(RepositoryConfigurationSource config, Object source) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.orm.jpa.SharedEntityManagerCreator");
        builder.setFactoryMethod("createSharedEntityManager");
        builder.addConstructorArgReference(JpaRepositoryConfigExtension.getEntityManagerBeanRef(config));
        AbstractBeanDefinition bean = builder.getRawBeanDefinition();
        bean.setSource(source);
        return bean;
    }

    private static String getEntityManagerBeanRef(RepositoryConfigurationSource config) {
        String entityManagerFactoryRef = config == null ? null : config.getAttribute("entityManagerFactoryRef");
        return entityManagerFactoryRef == null ? "entityManagerFactory" : entityManagerFactoryRef;
    }
}

