/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.RelationalPredicates;
import org.springframework.data.relational.core.sql.SqlIdentifier;

public class SqlParametersFactory {
    private final RelationalMappingContext context;
    private final JdbcConverter converter;

    public SqlParametersFactory(JdbcConverter converter) {
        this(converter.getMappingContext(), converter);
    }

    public SqlParametersFactory(RelationalMappingContext context, JdbcConverter converter) {
        this.context = context;
        this.converter = converter;
    }

    <T> SqlIdentifierParameterSource forInsert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        ParameterSourceHolder holder = this.getParameterSource(instance, persistentEntity, "", PersistentProperty::isIdProperty);
        identifier.forEach(holder::addValue);
        if (IdValueSource.PROVIDED.equals((Object)idValueSource)) {
            PersistentPropertyPathAccessor propertyPathAccessor = persistentEntity.getPropertyPathAccessor(instance);
            AggregatePath.ColumnInfos columnInfos = this.context.getAggregatePath(persistentEntity).getTableInfo().idColumnInfos();
            columnInfos.forEach((ap, __) -> {
                Object idValue = propertyPathAccessor.getProperty(ap.getRequiredPersistentPropertyPath());
                RelationalPersistentProperty idProperty = ap.getRequiredLeafProperty();
                holder.addValue(idProperty, idValue);
            });
        }
        return holder.getParameterSource();
    }

    <T> SqlIdentifierParameterSource forUpdate(T instance, Class<T> domainType) {
        return this.getParameterSource(instance, this.getRequiredPersistentEntity(domainType), "", RelationalPersistentProperty::isInsertOnly).getParameterSource();
    }

    <T> SqlIdentifierParameterSource forQueryById(Object id, Class<T> domainType) {
        return this.doWithIdentifiers(domainType, (columns, idProperty, complexId) -> {
            ParameterSourceHolder holder = new ParameterSourceHolder();
            BiFunction<Object, AggregatePath, Object> valueExtractor = this.getIdMapper(complexId);
            columns.forEach((ap, ci) -> holder.addValue(ci.name(), ap.getRequiredLeafProperty(), valueExtractor.apply(id, (AggregatePath)ap)));
            return holder.getParameterSource();
        });
    }

    <T> SqlIdentifierParameterSource forQueryByIds(Iterable<?> ids, Class<T> domainType) {
        return this.doWithIdentifiers(domainType, (columns, idProperty, complexId) -> {
            int n;
            ParameterSourceHolder holder = new ParameterSourceHolder();
            BiFunction<Object, AggregatePath, Object> valueExtractor = this.getIdMapper(complexId);
            if (ids instanceof Collection) {
                Collection c = (Collection)ids;
                n = c.size();
            } else {
                n = 16;
            }
            ArrayList<Object> parameterValues = new ArrayList<Object>(n);
            if (complexId == null || columns.size() == 1) {
                for (Object id : ids) {
                    SqlParametersFactory.appendIdentifier(holder, columns, id, valueExtractor, parameterValues);
                }
            } else {
                for (Object id : ids) {
                    ArrayList<Object> tuple = new ArrayList<Object>(columns.size());
                    SqlParametersFactory.appendIdentifier(holder, columns, id, valueExtractor, tuple);
                    parameterValues.add(tuple.toArray(new Object[0]));
                }
            }
            holder.getParameterSource().addValue(SqlGenerator.IDS_SQL_PARAMETER, parameterValues);
            return holder.getParameterSource();
        });
    }

    private static void appendIdentifier(ParameterSourceHolder holder, AggregatePath.ColumnInfos columns, Object id, BiFunction<Object, AggregatePath, Object> valueExtractor, List<@Nullable Object> tuple) {
        columns.forEach((ap, ci) -> {
            JdbcValue writeValue = holder.getWriteValue(ap.getRequiredLeafProperty(), valueExtractor.apply(id, (AggregatePath)ap));
            tuple.add(writeValue.getValue());
        });
    }

    private <T> T doWithIdentifiers(Class<?> domainType, IdentifierCallback<T> callback) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty();
        RelationalPersistentEntity complexId = this.context.getPersistentEntity(idProperty);
        AggregatePath.ColumnInfos columns = this.context.getAggregatePath(entity).getTableInfo().idColumnInfos();
        return callback.doWithIdentifiers(columns, idProperty, complexId);
    }

    SqlIdentifierParameterSource forQueryByIdentifier(Identifier identifier) {
        ParameterSourceHolder holder = new ParameterSourceHolder();
        identifier.forEach(holder::addValue);
        return holder.getParameterSource();
    }

    private BiFunction<Object, AggregatePath, @Nullable Object> getIdMapper(@Nullable RelationalPersistentEntity<?> complexId) {
        if (complexId == null) {
            return (id, aggregatePath) -> id;
        }
        return (id, aggregatePath) -> {
            PersistentPropertyAccessor accessor = complexId.getPropertyAccessor(id);
            return accessor.getProperty((PersistentProperty)aggregatePath.getRequiredLeafProperty());
        };
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private <S, T> ParameterSourceHolder getParameterSource(@Nullable S instance, RelationalPersistentEntity<S> persistentEntity, String prefix, Predicate<RelationalPersistentProperty> skipProperty) {
        ParameterSourceHolder holder = new ParameterSourceHolder();
        PersistentPropertyAccessor propertyAccessor = instance != null ? persistentEntity.getPropertyAccessor(instance) : NoValuePropertyAccessor.instance();
        persistentEntity.doWithAll(property -> {
            if (skipProperty.test((RelationalPersistentProperty)property) || !property.isWritable()) {
                return;
            }
            if (RelationalPredicates.isRelation((RelationalPersistentProperty)property)) {
                return;
            }
            if (property.isEmbedded()) {
                Object value = propertyAccessor.getProperty(property);
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(property.getTypeInformation());
                ParameterSourceHolder additionalParameters = this.getParameterSource(value, embeddedEntity, prefix + property.getEmbeddedPrefix(), skipProperty);
                holder.addAll(additionalParameters);
            } else {
                SqlIdentifier paramName = property.getColumnName().transform(prefix::concat);
                holder.addValue(paramName, (RelationalPersistentProperty)property, propertyAccessor.getProperty(property));
            }
        });
        return holder;
    }

    class ParameterSourceHolder {
        private final SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource();

        ParameterSourceHolder() {
        }

        public void addValue(RelationalPersistentProperty property, @Nullable Object value) {
            this.addValue(property.getColumnName(), property, value);
        }

        public void addValue(SqlIdentifier paramName, RelationalPersistentProperty property, @Nullable Object value) {
            JdbcValue jdbcValue = this.getWriteValue(property, value);
            this.parameterSource.addValue(paramName, jdbcValue);
        }

        public void addValue(SqlIdentifier paramName, @Nullable Object value, Class<?> javaType) {
            JdbcValue jdbcValue = SqlParametersFactory.this.converter.writeJdbcValue(value, javaType, JdbcUtil.targetSqlTypeFor(javaType));
            this.parameterSource.addValue(paramName, jdbcValue);
        }

        JdbcValue getWriteValue(RelationalPersistentProperty property, @Nullable Object value) {
            return SqlParametersFactory.this.converter.writeJdbcValue(value, SqlParametersFactory.this.converter.getColumnType(property), SqlParametersFactory.this.converter.getTargetSqlType(property));
        }

        public void addAll(ParameterSourceHolder others) {
            this.parameterSource.addAll(others.parameterSource);
        }

        public SqlIdentifierParameterSource getParameterSource() {
            return this.parameterSource;
        }
    }

    static interface IdentifierCallback<T> {
        public T doWithIdentifiers(AggregatePath.ColumnInfos var1, RelationalPersistentProperty var2, @Nullable RelationalPersistentEntity<?> var3);
    }

    static class NoValuePropertyAccessor<T>
    implements PersistentPropertyAccessor<T> {
        private static final NoValuePropertyAccessor<?> INSTANCE = new NoValuePropertyAccessor();

        NoValuePropertyAccessor() {
        }

        static <T> NoValuePropertyAccessor<T> instance() {
            return INSTANCE;
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            throw new UnsupportedOperationException("Cannot set value on 'null' target object");
        }

        public @Nullable Object getProperty(PersistentProperty<?> property) {
            return null;
        }

        public T getBean() {
            throw new UnsupportedOperationException("Cannot get bean of NoValuePropertyAccessor");
        }
    }
}

