/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.Jsr310TimestampBasedConverters;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class JdbcCustomConversions
extends CustomConversions {
    private static final Collection<Object> STORE_CONVERTERS = Collections.unmodifiableCollection(Jsr310TimestampBasedConverters.getConvertersToRegister());

    public JdbcCustomConversions() {
        this(Collections.emptyList());
    }

    public JdbcCustomConversions(List<?> userConverters) {
        this(CustomConversions.StoreConversions.of((SimpleTypeHolder)JdbcSimpleTypes.HOLDER, STORE_CONVERTERS), userConverters);
    }

    public JdbcCustomConversions(CustomConversions.StoreConversions storeConversions, List<?> userConverters) {
        super(JdbcConverterConfigurer.from(storeConversions).registerConverters(userConverters).createConfiguration());
    }

    public JdbcCustomConversions(CustomConversions.ConverterConfiguration converterConfiguration) {
        super(converterConfiguration);
    }

    public static JdbcCustomConversions of(Dialect dialect, Collection<?> converters) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(converters, (String)"Converters must not be null");
        return JdbcCustomConversions.create(dialect, configurer -> configurer.registerConverters(converters));
    }

    public static JdbcCustomConversions create(Dialect dialect, Consumer<JdbcConverterConfigurer> configurer) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(configurer, (String)"JdbcConverterConfigurer Consumer must not be null");
        JdbcConverterConfigurer converterConfigurer = JdbcConverterConfigurer.from(dialect);
        configurer.accept(converterConfigurer);
        return new JdbcCustomConversions(converterConfigurer.createConfiguration());
    }

    public static Collection<Object> storeConverters() {
        return STORE_CONVERTERS;
    }

    private static boolean isDateTimeApiConversion(GenericConverter.ConvertiblePair cp) {
        if (cp.getSourceType().equals(Date.class)) {
            return cp.getTargetType().getTypeName().startsWith("java.time.");
        }
        if (cp.getTargetType().equals(Date.class)) {
            return cp.getSourceType().getTypeName().startsWith("java.time.");
        }
        return false;
    }

    private static boolean excludeConversionsBetweenDateAndJsr310Types(GenericConverter.ConvertiblePair cp) {
        return !JdbcCustomConversions.isDateTimeApiConversion(cp);
    }

    public static class JdbcConverterConfigurer {
        private final CustomConversions.StoreConversions storeConversions;
        private final List<Object> customConverters = new ArrayList<Object>();

        private JdbcConverterConfigurer(CustomConversions.StoreConversions storeConversions) {
            this.storeConversions = storeConversions;
        }

        static JdbcConverterConfigurer from(Dialect dialect) {
            ArrayList<Object> converters = new ArrayList<Object>();
            converters.addAll(dialect.getConverters());
            converters.addAll(JdbcCustomConversions.storeConverters());
            SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder(dialect.simpleTypes(), JdbcSimpleTypes.HOLDER);
            return new JdbcConverterConfigurer(CustomConversions.StoreConversions.of((SimpleTypeHolder)simpleTypeHolder, converters));
        }

        static JdbcConverterConfigurer from(CustomConversions.StoreConversions storeConversions) {
            return new JdbcConverterConfigurer(storeConversions);
        }

        @Contract(value="_ -> this")
        public JdbcConverterConfigurer registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null");
            this.customConverters.add(converter);
            return this;
        }

        @Contract(value="_ -> this")
        public JdbcConverterConfigurer registerConverters(Object ... converters) {
            return this.registerConverters(Arrays.asList(converters));
        }

        @Contract(value="_ -> this")
        public JdbcConverterConfigurer registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values");
            this.customConverters.addAll(converters);
            return this;
        }

        @Contract(value="_ -> this")
        public JdbcConverterConfigurer registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null");
            this.customConverters.add(converterFactory);
            return this;
        }

        CustomConversions.ConverterConfiguration createConfiguration() {
            return new CustomConversions.ConverterConfiguration(this.storeConversions, this.customConverters, JdbcCustomConversions::excludeConversionsBetweenDateAndJsr310Types);
        }
    }
}

