/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;

class SequenceEntityCallbackDelegate {
    private static final Log LOG = LogFactory.getLog(SequenceEntityCallbackDelegate.class);
    private static final MapSqlParameterSource EMPTY_PARAMETERS = new MapSqlParameterSource();
    private final Dialect dialect;
    private final NamedParameterJdbcOperations operations;

    public SequenceEntityCallbackDelegate(Dialect dialect, NamedParameterJdbcOperations operations) {
        this.dialect = dialect;
        this.operations = operations;
    }

    protected void generateSequenceValue(RelationalPersistentProperty property, PersistentPropertyAccessor<Object> accessor) {
        Object sequenceValue = this.getSequenceValue(property);
        if (sequenceValue == null) {
            return;
        }
        Class targetType = ClassUtils.resolvePrimitiveIfNecessary((Class)property.getType());
        if (sequenceValue instanceof Number && Number.class.isAssignableFrom(targetType)) {
            sequenceValue = NumberUtils.convertNumberToTargetClass((Number)((Number)sequenceValue), (Class)targetType);
        }
        accessor.setProperty((PersistentProperty)property, sequenceValue);
    }

    protected boolean hasValue(PersistentProperty<?> property, PersistentPropertyAccessor<Object> propertyAccessor) {
        Object identifier = propertyAccessor.getProperty(property);
        if (property.getType().isPrimitive()) {
            Object primitiveDefault = ReflectionUtils.getPrimitiveDefault((Class)property.getType());
            return !primitiveDefault.equals(identifier);
        }
        return identifier != null;
    }

    private @Nullable Object getSequenceValue(RelationalPersistentProperty property) {
        SqlIdentifier sequence = property.getSequence();
        if (sequence == null) {
            return null;
        }
        if (!this.dialect.getIdGeneration().sequencesSupported()) {
            LOG.warn((Object)"Aggregate type '%s' is marked for sequence usage but configured dialect '%s'\ndoes not support sequences. Falling back to identity columns.\n".formatted(property.getOwner().getType(), ClassUtils.getQualifiedName((Class)this.dialect.getClass())));
            return null;
        }
        String sql = this.dialect.getIdGeneration().createSequenceQuery(sequence);
        return this.operations.queryForObject(sql, (SqlParameterSource)EMPTY_PARAMETERS, (rs, rowNum) -> rs.getObject(1));
    }
}

