/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.FunctionCollector;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class CascadingDataAccessStrategy
implements DataAccessStrategy {
    private final List<DataAccessStrategy> strategies;

    public CascadingDataAccessStrategy(List<DataAccessStrategy> strategies) {
        this.strategies = new ArrayList<DataAccessStrategy>(strategies);
    }

    @Override
    public Dialect getDialect() {
        Assert.notEmpty(this.strategies, (String)"DataAccessStrategy must have at least one strategy");
        return this.strategies.get(0).getDialect();
    }

    @Override
    public NamedParameterJdbcOperations getJdbcOperations() {
        Assert.notEmpty(this.strategies, (String)"DataAccessStrategy must have at least one strategy");
        return this.strategies.get(0).getJdbcOperations();
    }

    @Override
    public <T> @Nullable Object insert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        return this.collect(das -> das.insert(instance, domainType, identifier, idValueSource));
    }

    @Override
    public <T> @Nullable Object[] insert(List<InsertSubject<T>> insertSubjects, Class<T> domainType, IdValueSource idValueSource) {
        return this.collect(das -> das.insert(insertSubjects, domainType, idValueSource));
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.collect(das -> das.update(instance, domainType));
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number previousVersion) {
        return this.collect(das -> das.updateWithVersion(instance, domainType, previousVersion));
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        this.collectVoid(das -> das.delete(id, domainType));
    }

    @Override
    public void delete(Iterable<Object> ids, Class<?> domainType) {
        this.collectVoid(das -> das.delete(ids, domainType));
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        this.collectVoid(das -> das.deleteWithVersion(id, domainType, previousVersion));
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.collectVoid(das -> das.delete(rootId, propertyPath));
    }

    @Override
    public void delete(Iterable<Object> rootIds, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.collectVoid(das -> das.delete(rootIds, propertyPath));
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.collectVoid(das -> das.deleteAll(domainType));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.collectVoid(das -> das.deleteAll(propertyPath));
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        this.collectVoid(das -> das.acquireLockById(id, lockMode, domainType));
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        this.collectVoid(das -> das.acquireLockAll(lockMode, domainType));
    }

    @Override
    public long count(Class<?> domainType) {
        return this.collect(das -> das.count(domainType));
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        return (T)this.collect(das -> das.findById(id, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.collect(das -> das.findAll(domainType));
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType) {
        return this.collect(das -> das.streamAll(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.collect(das -> das.findAllById(ids, domainType));
    }

    @Override
    public <T> Stream<T> streamAllByIds(Iterable<?> ids, Class<T> domainType) {
        return this.collect(das -> das.streamAllByIds(ids, domainType));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        return this.collect(das -> das.findAllByPath(identifier, path));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return this.collect(das -> das.existsById(id, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        return this.collect(das -> das.findAll(domainType, sort));
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType, Sort sort) {
        return this.collect(das -> das.streamAll(domainType, sort));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Pageable pageable) {
        return this.collect(das -> das.findAll(domainType, pageable));
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        return this.collect(das -> das.findOne(query, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType) {
        return this.collect(das -> das.findAll(query, domainType));
    }

    @Override
    public <T> Stream<T> streamAll(Query query, Class<T> domainType) {
        return this.collect(das -> das.streamAll(query, domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType, Pageable pageable) {
        return this.collect(das -> das.findAll(query, domainType, pageable));
    }

    @Override
    public <T> boolean exists(Query query, Class<T> domainType) {
        return this.collect(das -> das.exists(query, domainType));
    }

    @Override
    public <T> long count(Query query, Class<T> domainType) {
        return this.collect(das -> das.count(query, domainType));
    }

    private <T> T collect(Function<DataAccessStrategy, T> function) {
        return (T)this.strategies.stream().collect(new FunctionCollector<T>(function));
    }

    private void collectVoid(Consumer<DataAccessStrategy> consumer) {
        this.collect(das -> {
            consumer.accept((DataAccessStrategy)das);
            return Boolean.TRUE;
        });
    }
}

