/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.ConvertingRowMapper;
import org.springframework.data.jdbc.repository.query.JdbcCountQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcDeleteQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.Lazy;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PartTreeJdbcQuery
extends AbstractJdbcQuery {
    private final RelationalMappingContext context;
    private final Parameters<?, ?> parameters;
    private final Dialect dialect;
    private final JdbcConverter converter;
    private final CachedRowMapperFactory cachedRowMapperFactory;
    private final PartTree tree;

    public PartTreeJdbcQuery(JdbcQueryMethod queryMethod, Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations operations, RowMapperFactory rowMapperFactory) {
        this(converter.getMappingContext(), queryMethod, dialect, converter, operations, rowMapperFactory);
    }

    public PartTreeJdbcQuery(RelationalMappingContext context, JdbcQueryMethod queryMethod, Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations operations, RowMapper<Object> rowMapper) {
        this(context, queryMethod, dialect, converter, operations, (Class<?> it) -> rowMapper);
    }

    public PartTreeJdbcQuery(RelationalMappingContext context, JdbcQueryMethod queryMethod, Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations operations, RowMapperFactory rowMapperFactory) {
        super(queryMethod, operations);
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)((Object)queryMethod), (String)"JdbcQueryMethod must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)rowMapperFactory, (String)"RowMapperFactory must not be null");
        this.context = context;
        this.parameters = queryMethod.getParameters();
        this.dialect = dialect;
        this.converter = converter;
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getResultProcessor().getReturnedType().getDomainType());
        JdbcQueryCreator.validate(this.tree, this.parameters, this.converter.getMappingContext());
        this.cachedRowMapperFactory = new CachedRowMapperFactory(this.tree, rowMapperFactory, converter, queryMethod.getResultProcessor());
    }

    private Sort getDynamicSort(RelationalParameterAccessor accessor) {
        return this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
    }

    @Nullable
    public Object execute(Object[] values) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), values);
        if (this.tree.isDelete()) {
            JdbcQueryExecution<Object> execution = this.createModifyingQueryExecutor();
            List<ParametrizedQuery> queries = this.createDeleteQueries(accessor);
            Object result = null;
            for (ParametrizedQuery query : queries) {
                result = execution.execute(query.getQuery(), query.getParameterSource(this.dialect.getLikeEscaper()));
            }
            return result;
        }
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ParametrizedQuery query = this.createQuery(accessor, processor.getReturnedType());
        JdbcQueryExecution<?> execution = this.getQueryExecution(processor, accessor);
        return execution.execute(query.getQuery(), query.getParameterSource(this.dialect.getLikeEscaper()));
    }

    private JdbcQueryExecution<?> getQueryExecution(ResultProcessor processor, RelationalParametersParameterAccessor accessor) {
        ResultSetExtractor extractor = this.tree.isExistsProjection() ? ResultSet::next : null;
        Supplier<RowMapper<?>> rowMapper = this.parameters.hasDynamicProjection() ? () -> this.cachedRowMapperFactory.getRowMapper(processor) : this.cachedRowMapperFactory;
        JdbcQueryExecution<?> queryExecution = this.getJdbcQueryExecution((ResultSetExtractor<Boolean>)extractor, rowMapper);
        if (this.getQueryMethod().isSliceQuery()) {
            return new SliceQueryExecution(queryExecution, accessor.getPageable());
        }
        if (this.getQueryMethod().isPageQuery()) {
            return new PageQueryExecution(queryExecution, accessor.getPageable(), () -> {
                RelationalEntityMetadata<?> entityMetadata = this.getQueryMethod().getEntityInformation();
                JdbcCountQueryCreator queryCreator = new JdbcCountQueryCreator(this.context, this.tree, this.converter, this.dialect, entityMetadata, (RelationalParameterAccessor)accessor, false, processor.getReturnedType(), this.getQueryMethod().lookupLockAnnotation());
                ParametrizedQuery countQuery = (ParametrizedQuery)queryCreator.createQuery(Sort.unsorted());
                Object count = this.singleObjectQuery((rs, i) -> rs.getLong(1)).execute(countQuery.getQuery(), countQuery.getParameterSource(this.dialect.getLikeEscaper()));
                return (Long)this.converter.getConversionService().convert(count, Long.class);
            });
        }
        return queryExecution;
    }

    ParametrizedQuery createQuery(RelationalParametersParameterAccessor accessor, ReturnedType returnedType) {
        RelationalEntityMetadata<?> entityMetadata = this.getQueryMethod().getEntityInformation();
        JdbcQueryCreator queryCreator = new JdbcQueryCreator(this.context, this.tree, this.converter, this.dialect, entityMetadata, (RelationalParameterAccessor)accessor, this.getQueryMethod().isSliceQuery(), returnedType, this.getQueryMethod().lookupLockAnnotation());
        return (ParametrizedQuery)queryCreator.createQuery(this.getDynamicSort((RelationalParameterAccessor)accessor));
    }

    private List<ParametrizedQuery> createDeleteQueries(RelationalParametersParameterAccessor accessor) {
        RelationalEntityMetadata<?> entityMetadata = this.getQueryMethod().getEntityInformation();
        JdbcDeleteQueryCreator queryCreator = new JdbcDeleteQueryCreator(this.context, this.tree, this.converter, this.dialect, entityMetadata, (RelationalParameterAccessor)accessor);
        return (List)queryCreator.createQuery();
    }

    private JdbcQueryExecution<?> getJdbcQueryExecution(@Nullable ResultSetExtractor<Boolean> extractor, Supplier<RowMapper<?>> rowMapper) {
        if (this.getQueryMethod().isPageQuery() || this.getQueryMethod().isSliceQuery()) {
            return this.collectionQuery(rowMapper.get());
        }
        if (this.getQueryMethod().isModifyingQuery()) {
            return this.createModifyingQueryExecutor();
        }
        return this.createReadingQueryExecution(extractor, rowMapper);
    }

    class CachedRowMapperFactory
    implements Supplier<RowMapper<?>> {
        private final Lazy<RowMapper<?>> rowMapper;
        private final Function<ResultProcessor, RowMapper<?>> rowMapperFunction = processor -> {
            if (tree.isCountProjection() || tree.isExistsProjection()) {
                return rowMapperFactory.create(this$0.resolveTypeToRead((ResultProcessor)processor));
            }
            JdbcQueryExecution.ResultProcessingConverter resultProcessingConverter = new JdbcQueryExecution.ResultProcessingConverter((ResultProcessor)processor, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)converter.getMappingContext(), converter.getEntityInstantiators());
            return new ConvertingRowMapper(rowMapperFactory.create(processor.getReturnedType().getDomainType()), resultProcessingConverter);
        };

        public CachedRowMapperFactory(PartTree tree, RowMapperFactory rowMapperFactory, RelationalConverter converter, ResultProcessor defaultResultProcessor) {
            this.rowMapper = Lazy.of(() -> this.rowMapperFunction.apply(defaultResultProcessor));
        }

        @Override
        public RowMapper<?> get() {
            return this.getRowMapper();
        }

        public RowMapper<?> getRowMapper() {
            return (RowMapper)this.rowMapper.get();
        }

        public RowMapper<?> getRowMapper(ResultProcessor resultProcessor) {
            return this.rowMapperFunction.apply(resultProcessor);
        }
    }

    static class SliceQueryExecution<T>
    implements JdbcQueryExecution<Slice<T>> {
        private final JdbcQueryExecution<? extends Collection<T>> delegate;
        private final Pageable pageable;

        public SliceQueryExecution(JdbcQueryExecution<? extends Collection<T>> delegate, Pageable pageable) {
            this.delegate = delegate;
            this.pageable = pageable;
        }

        @Override
        public Slice<T> execute(String query, SqlParameterSource parameter) {
            Collection<T> result = this.delegate.execute(query, parameter);
            int pageSize = 0;
            if (this.pageable.isPaged()) {
                pageSize = this.pageable.getPageSize();
            }
            List resultList = result instanceof List ? (List)result : new ArrayList<T>(result);
            boolean hasNext = this.pageable.isPaged() && resultList.size() > pageSize;
            return new SliceImpl(hasNext ? resultList.subList(0, pageSize) : resultList, this.pageable, hasNext);
        }
    }

    static class PageQueryExecution<T>
    implements JdbcQueryExecution<Slice<T>> {
        private final JdbcQueryExecution<? extends Collection<T>> delegate;
        private final Pageable pageable;
        private final LongSupplier countSupplier;

        PageQueryExecution(JdbcQueryExecution<? extends Collection<T>> delegate, Pageable pageable, LongSupplier countSupplier) {
            this.delegate = delegate;
            this.pageable = pageable;
            this.countSupplier = countSupplier;
        }

        @Override
        public Slice<T> execute(String query, SqlParameterSource parameter) {
            Collection<T> result = this.delegate.execute(query, parameter);
            return PageableExecutionUtils.getPage((List)(result instanceof List ? (List<Object>)result : new ArrayList<T>(result)), (Pageable)this.pageable, (LongSupplier)this.countSupplier);
        }
    }
}

