/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.InsertSubject;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class DelegatingDataAccessStrategy
implements DataAccessStrategy {
    private DataAccessStrategy delegate;

    public DelegatingDataAccessStrategy() {
    }

    public DelegatingDataAccessStrategy(DataAccessStrategy delegate) {
        Assert.notNull((Object)delegate, (String)"DataAccessStrategy must not be null");
        this.delegate = delegate;
    }

    @Override
    public Dialect getDialect() {
        return this.delegate.getDialect();
    }

    @Override
    public NamedParameterJdbcOperations getJdbcOperations() {
        return this.delegate.getJdbcOperations();
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier, IdValueSource idValueSource) {
        return this.delegate.insert(instance, domainType, identifier, idValueSource);
    }

    @Override
    public <T> Object[] insert(List<InsertSubject<T>> insertSubjects, Class<T> domainType, IdValueSource idValueSource) {
        return this.delegate.insert(insertSubjects, domainType, idValueSource);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.delegate.update(instance, domainType);
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number nextVersion) {
        return this.delegate.updateWithVersion(instance, domainType, nextVersion);
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.delegate.delete(rootId, propertyPath);
    }

    @Override
    public void delete(Iterable<Object> rootIds, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.delegate.delete(rootIds, propertyPath);
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        this.delegate.delete(id, domainType);
    }

    @Override
    public void delete(Iterable<Object> ids, Class<?> domainType) {
        this.delegate.delete(ids, domainType);
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        this.delegate.deleteWithVersion(id, domainType, previousVersion);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.delegate.deleteAll(domainType);
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.delegate.deleteAll(propertyPath);
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        this.delegate.acquireLockById(id, lockMode, domainType);
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        this.delegate.acquireLockAll(lockMode, domainType);
    }

    @Override
    public long count(Class<?> domainType) {
        return this.delegate.count(domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull((Object)this.delegate, (String)"Delegate is null");
        return this.delegate.findById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.delegate.findAll(domainType);
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType) {
        return this.delegate.streamAll(domainType);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.delegate.findAllById(ids, domainType);
    }

    @Override
    public <T> Stream<T> streamAllByIds(Iterable<?> ids, Class<T> domainType) {
        return this.delegate.streamAllByIds(ids, domainType);
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        return this.delegate.findAllByPath(identifier, path);
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return this.delegate.existsById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        return this.delegate.findAll(domainType, sort);
    }

    @Override
    public <T> Stream<T> streamAll(Class<T> domainType, Sort sort) {
        return this.delegate.streamAll(domainType, sort);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Pageable pageable) {
        return this.delegate.findAll(domainType, pageable);
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        return this.delegate.findOne(query, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType) {
        return this.delegate.findAll(query, domainType);
    }

    @Override
    public <T> Stream<T> streamAll(Query query, Class<T> domainType) {
        return this.delegate.streamAll(query, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType, Pageable pageable) {
        return this.delegate.findAll(query, domainType, pageable);
    }

    @Override
    public <T> boolean exists(Query query, Class<T> domainType) {
        return this.delegate.exists(query, domainType);
    }

    @Override
    public <T> long count(Query query, Class<T> domainType) {
        return this.delegate.count(query, domainType);
    }

    @Deprecated(since="3.0", forRemoval=true)
    public void setDelegate(DataAccessStrategy delegate) {
        Assert.isNull((Object)this.delegate, (String)"The delegate must be set exactly once");
        Assert.notNull((Object)delegate, (String)"The delegate must not be set to null");
        this.delegate = delegate;
    }
}

