/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.AggregateReferenceConverters;
import org.springframework.data.jdbc.core.convert.Jsr310TimestampBasedConverters;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class JdbcCustomConversions
extends CustomConversions {
    private static final Collection<Object> STORE_CONVERTERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public JdbcCustomConversions() {
        this(Collections.emptyList());
    }

    public JdbcCustomConversions(List<?> converters) {
        super(new CustomConversions.ConverterConfiguration(STORE_CONVERSIONS, converters, JdbcCustomConversions::excludeConversionsBetweenDateAndJsr310Types));
    }

    public JdbcCustomConversions(CustomConversions.StoreConversions storeConversions, List<?> userConverters) {
        super(new CustomConversions.ConverterConfiguration(storeConversions, userConverters, JdbcCustomConversions::excludeConversionsBetweenDateAndJsr310Types));
    }

    public JdbcCustomConversions(CustomConversions.ConverterConfiguration converterConfiguration) {
        super(converterConfiguration);
    }

    public static Collection<Object> storeConverters() {
        return STORE_CONVERTERS;
    }

    private static boolean isDateTimeApiConversion(GenericConverter.ConvertiblePair cp) {
        if (cp.getSourceType().equals(Date.class)) {
            return cp.getTargetType().getTypeName().startsWith("java.time.");
        }
        if (cp.getTargetType().equals(Date.class)) {
            return cp.getSourceType().getTypeName().startsWith("java.time.");
        }
        return false;
    }

    private static boolean excludeConversionsBetweenDateAndJsr310Types(GenericConverter.ConvertiblePair cp) {
        return !JdbcCustomConversions.isDateTimeApiConversion(cp);
    }

    static {
        ArrayList converters = new ArrayList(Jsr310TimestampBasedConverters.getConvertersToRegister());
        converters.addAll(AggregateReferenceConverters.getConvertersToRegister(DefaultConversionService.getSharedInstance()));
        STORE_CONVERTERS = Collections.unmodifiableCollection(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)JdbcSimpleTypes.HOLDER, STORE_CONVERTERS);
    }
}

