/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class Identifier {
    private static final Identifier EMPTY = new Identifier(Collections.emptyList());
    private final List<SingleIdentifierValue> parts;

    private Identifier(List<SingleIdentifierValue> parts) {
        this.parts = parts;
    }

    public static Identifier empty() {
        return EMPTY;
    }

    public static Identifier of(SqlIdentifier name, Object value, Class<?> targetType) {
        Assert.notNull((Object)name, (String)"Name must not be empty!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        return new Identifier(Collections.singletonList(new SingleIdentifierValue(name, value, targetType)));
    }

    public static Identifier from(Map<SqlIdentifier, Object> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        if (map.isEmpty()) {
            return Identifier.empty();
        }
        ArrayList values = new ArrayList();
        map.forEach((? super K k, ? super V v) -> values.add(new SingleIdentifierValue((SqlIdentifier)k, v, v != null ? ClassUtils.getUserClass((Object)v) : Object.class)));
        return new Identifier(Collections.unmodifiableList(values));
    }

    public Identifier withPart(SqlIdentifier name, Object value, Class<?> targetType) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull(targetType, (String)"Target type must not be null!");
        boolean overwritten = false;
        ArrayList<SingleIdentifierValue> keys = new ArrayList<SingleIdentifierValue>(this.parts.size() + 1);
        for (SingleIdentifierValue singleValue : this.parts) {
            if (singleValue.getName().equals(name)) {
                overwritten = true;
                keys.add(new SingleIdentifierValue(singleValue.getName(), value, targetType));
                continue;
            }
            keys.add(singleValue);
        }
        if (!overwritten) {
            keys.add(new SingleIdentifierValue(name, value, targetType));
        }
        return new Identifier(Collections.unmodifiableList(keys));
    }

    public Map<SqlIdentifier, Object> toMap() {
        StringKeyedLinkedHashMap<Object> result = new StringKeyedLinkedHashMap<Object>(this.getParts().size());
        this.forEach((name, value, type) -> result.put(name, value));
        return result;
    }

    public Collection<SingleIdentifierValue> getParts() {
        return this.parts;
    }

    public void forEach(IdentifierConsumer consumer) {
        Assert.notNull((Object)consumer, (String)"IdentifierConsumer must not be null");
        this.getParts().forEach((? super T it) -> consumer.accept(it.name, it.value, it.targetType));
    }

    public int size() {
        return this.parts.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public String toString() {
        return "Identifier{parts=" + this.parts + "}";
    }

    static final class SingleIdentifierValue {
        private final SqlIdentifier name;
        private final Object value;
        private final Class<?> targetType;

        private SingleIdentifierValue(SqlIdentifier name, @Nullable Object value, Class<?> targetType) {
            Assert.notNull((Object)name, (String)"Name must not be null.");
            Assert.notNull(targetType, (String)"TargetType must not be null.");
            this.name = name;
            this.value = value;
            this.targetType = targetType;
        }

        public SqlIdentifier getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleIdentifierValue that = (SingleIdentifierValue)o;
            return this.name.equals(that.name) && this.value.equals(that.value) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value, this.targetType);
        }

        public String toString() {
            return "SingleIdentifierValue{name=" + this.name + ", value=" + this.value + ", targetType=" + this.targetType + "}";
        }
    }

    private static class StringKeyedLinkedHashMap<V>
    extends LinkedHashMap<SqlIdentifier, V> {
        public StringKeyedLinkedHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public V get(Object key) {
            if (key instanceof String) {
                for (SqlIdentifier sqlIdentifier : this.keySet()) {
                    if (!sqlIdentifier.getReference().equals(key)) continue;
                    return super.get(sqlIdentifier);
                }
            }
            return super.get(key);
        }
    }

    @FunctionalInterface
    public static interface IdentifierConsumer {
        public void accept(SqlIdentifier var1, Object var2, Class<?> var3);
    }
}

