/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.MappingException;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

class ResultSetAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetAccessor.class);
    private final ResultSet resultSet;
    private final Map<String, Integer> indexLookUp;

    ResultSetAccessor(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.indexLookUp = ResultSetAccessor.indexColumns(resultSet);
    }

    private static Map<String, Integer> indexColumns(ResultSet resultSet) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            LinkedCaseInsensitiveMap index = new LinkedCaseInsensitiveMap(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                String label = metaData.getColumnLabel(i);
                if (index.containsKey(label)) {
                    LOG.warn("ResultSet contains {} multiple times", (Object)label);
                    continue;
                }
                index.put(label, i);
            }
            return index;
        }
        catch (SQLException se) {
            throw new MappingException("Cannot obtain result metadata", (Throwable)se);
        }
    }

    @Nullable
    public Object getObject(String columnName) {
        try {
            int index = this.findColumnIndex(columnName);
            return index > 0 ? this.resultSet.getObject(index) : null;
        }
        catch (SQLException o_O) {
            throw new MappingException(String.format("Could not read value %s from result set!", columnName), (Throwable)o_O);
        }
    }

    private int findColumnIndex(String columnName) {
        return this.indexLookUp.getOrDefault(columnName, -1);
    }

    public boolean hasValue(String columnName) {
        return this.indexLookUp.containsKey(columnName);
    }
}

