/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.mybatis;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jdbc.core.convert.CascadingDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DelegatingDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.mybatis.MyBatisContext;
import org.springframework.data.jdbc.mybatis.NamespaceStrategy;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class MyBatisDataAccessStrategy
implements DataAccessStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisDataAccessStrategy.class);
    private final SqlSession sqlSession;
    private NamespaceStrategy namespaceStrategy = NamespaceStrategy.DEFAULT_INSTANCE;

    public static DataAccessStrategy createCombinedAccessStrategy(RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlSession sqlSession) {
        return MyBatisDataAccessStrategy.createCombinedAccessStrategy(context, converter, operations, sqlSession, NamespaceStrategy.DEFAULT_INSTANCE);
    }

    public static DataAccessStrategy createCombinedAccessStrategy(RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations, SqlSession sqlSession, NamespaceStrategy namespaceStrategy) {
        DelegatingDataAccessStrategy delegatingDataAccessStrategy = new DelegatingDataAccessStrategy();
        MyBatisDataAccessStrategy myBatisDataAccessStrategy = new MyBatisDataAccessStrategy(sqlSession);
        myBatisDataAccessStrategy.setNamespaceStrategy(namespaceStrategy);
        CascadingDataAccessStrategy cascadingDataAccessStrategy = new CascadingDataAccessStrategy(Arrays.asList(myBatisDataAccessStrategy, delegatingDataAccessStrategy));
        SqlGeneratorSource sqlGeneratorSource = new SqlGeneratorSource(context);
        DefaultDataAccessStrategy defaultDataAccessStrategy = new DefaultDataAccessStrategy(sqlGeneratorSource, context, converter, operations);
        delegatingDataAccessStrategy.setDelegate(defaultDataAccessStrategy);
        return cascadingDataAccessStrategy;
    }

    public MyBatisDataAccessStrategy(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public void setNamespaceStrategy(NamespaceStrategy namespaceStrategy) {
        Assert.notNull((Object)namespaceStrategy, (String)"The NamespaceStrategy must not be null");
        this.namespaceStrategy = namespaceStrategy;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Map<String, Object> additionalParameters) {
        MyBatisContext myBatisContext = new MyBatisContext(null, instance, domainType, additionalParameters);
        this.sqlSession().insert(this.namespace(domainType) + ".insert", (Object)myBatisContext);
        return myBatisContext.getId();
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        MyBatisContext myBatisContext = new MyBatisContext(null, instance, domainType, identifier.toMap());
        this.sqlSession().insert(this.namespace(domainType) + ".insert", (Object)myBatisContext);
        return myBatisContext.getId();
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.sqlSession().update(this.namespace(domainType) + ".update", (Object)new MyBatisContext(null, instance, domainType, Collections.emptyMap())) != 0;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        this.sqlSession().delete(this.namespace(domainType) + ".delete", (Object)new MyBatisContext(id, null, domainType, Collections.emptyMap()));
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.sqlSession().delete(this.namespace(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType()) + ".delete-" + MyBatisDataAccessStrategy.toDashPath(propertyPath), (Object)new MyBatisContext(rootId, null, ((RelationalPersistentProperty)propertyPath.getRequiredLeafProperty()).getTypeInformation().getType(), Collections.emptyMap()));
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.sqlSession().delete(this.namespace(domainType) + ".deleteAll", (Object)new MyBatisContext(null, null, domainType, Collections.emptyMap()));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        Class baseType = ((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType();
        Class leafType = ((RelationalPersistentProperty)propertyPath.getRequiredLeafProperty()).getTypeInformation().getType();
        this.sqlSession().delete(this.namespace(baseType) + ".deleteAll-" + MyBatisDataAccessStrategy.toDashPath(propertyPath), (Object)new MyBatisContext(null, null, leafType, Collections.emptyMap()));
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        return (T)this.sqlSession().selectOne(this.namespace(domainType) + ".findById", (Object)new MyBatisContext(id, null, domainType, Collections.emptyMap()));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.sqlSession().selectList(this.namespace(domainType) + ".findAll", (Object)new MyBatisContext(null, null, domainType, Collections.emptyMap()));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.sqlSession().selectList(this.namespace(domainType) + ".findAllById", (Object)new MyBatisContext(ids, null, domainType, Collections.emptyMap()));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<RelationalPersistentProperty> path) {
        String statementName = this.namespace(((RelationalPersistentProperty)path.getBaseProperty()).getOwner().getType()) + ".findAllByPath-" + path.toDotPath();
        try {
            return this.sqlSession().selectList(statementName, (Object)new MyBatisContext(identifier, null, ((RelationalPersistentProperty)path.getRequiredLeafProperty()).getType()));
        }
        catch (PersistenceException pex) {
            LOG.debug(String.format("Didn't find %s in the MyBatis session. Falling back to findAllByPath.", statementName), (Throwable)pex);
            return DataAccessStrategy.super.findAllByPath(identifier, path);
        }
    }

    @Override
    public <T> Iterable<T> findAllByProperty(Object rootId, RelationalPersistentProperty property) {
        return this.sqlSession().selectList(this.namespace(property.getOwner().getType()) + ".findAllByProperty-" + property.getName(), (Object)new MyBatisContext(rootId, null, property.getType(), Collections.emptyMap()));
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return (Boolean)this.sqlSession().selectOne(this.namespace(domainType) + ".existsById", (Object)new MyBatisContext(id, null, domainType, Collections.emptyMap()));
    }

    @Override
    public long count(Class<?> domainType) {
        return (Long)this.sqlSession().selectOne(this.namespace(domainType) + ".count", (Object)new MyBatisContext(null, null, domainType, Collections.emptyMap()));
    }

    private String namespace(Class<?> domainType) {
        return this.namespaceStrategy.getNamespace(domainType);
    }

    private SqlSession sqlSession() {
        return this.sqlSession;
    }

    private static String toDashPath(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        return propertyPath.toDotPath().replaceAll("\\.", "-");
    }
}

