/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.Identifier;
import org.springframework.lang.Nullable;

public class JdbcIdentifierBuilder {
    private Identifier identifier;

    private JdbcIdentifierBuilder(Identifier identifier) {
        this.identifier = identifier;
    }

    public static JdbcIdentifierBuilder empty() {
        return new JdbcIdentifierBuilder(Identifier.empty());
    }

    public static JdbcIdentifierBuilder forBackReferences(PersistentPropertyPath<RelationalPersistentProperty> path, @Nullable Object value) {
        Identifier identifier = Identifier.of((String)((RelationalPersistentProperty)path.getRequiredLeafProperty()).getReverseColumnName(), (Object)value, (Class)JdbcIdentifierBuilder.getLastIdProperty(path).getColumnType());
        return new JdbcIdentifierBuilder(identifier);
    }

    public JdbcIdentifierBuilder withQualifier(PersistentPropertyPath<RelationalPersistentProperty> path, Object value) {
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)path.getRequiredLeafProperty();
        this.identifier = this.identifier.withPart(leafProperty.getKeyColumn(), value, leafProperty.getQualifierColumnType());
        return this;
    }

    public Identifier build() {
        return this.identifier;
    }

    private static RelationalPersistentProperty getLastIdProperty(PersistentPropertyPath<RelationalPersistentProperty> path) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)((RelationalPersistentProperty)path.getRequiredLeafProperty()).getOwner().getIdProperty();
        if (idProperty != null) {
            return idProperty;
        }
        return JdbcIdentifierBuilder.getLastIdProperty((PersistentPropertyPath<RelationalPersistentProperty>)path.getParentPath());
    }
}

