/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.data.annotation.ReadOnlyProperty;
import org.springframework.data.jdbc.core.PersistentPropertyPathExtension;
import org.springframework.data.jdbc.core.SqlContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.BindMarker;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.InsertBuilder;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Update;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SqlGenerator {
    private static final Pattern parameterPattern = Pattern.compile("\\W");
    private final RelationalPersistentEntity<?> entity;
    private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
    private final SqlContext sqlContext;
    private final Columns columns;
    private final Lazy<String> findOneSql = Lazy.of(this::createFindOneSql);
    private final Lazy<String> findAllSql = Lazy.of(this::createFindAllSql);
    private final Lazy<String> findAllInListSql = Lazy.of(this::createFindAllInListSql);
    private final Lazy<String> existsSql = Lazy.of(this::createExistsSql);
    private final Lazy<String> countSql = Lazy.of(this::createCountSql);
    private final Lazy<String> updateSql = Lazy.of(this::createUpdateSql);
    private final Lazy<String> deleteByIdSql = Lazy.of(this::createDeleteSql);
    private final Lazy<String> deleteByListSql = Lazy.of(this::createDeleteByListSql);

    SqlGenerator(RelationalMappingContext mappingContext, RelationalPersistentEntity<?> entity) {
        this.mappingContext = mappingContext;
        this.entity = entity;
        this.sqlContext = new SqlContext(entity);
        this.columns = new Columns(entity, (MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty>)mappingContext);
    }

    String getFindAllInList() {
        return (String)this.findAllInListSql.get();
    }

    String getFindAll() {
        return (String)this.findAllSql.get();
    }

    String getFindAllByProperty(String columnName, @Nullable String keyColumn, boolean ordered) {
        Assert.isTrue((keyColumn != null || !ordered ? 1 : 0) != 0, (String)"If the SQL statement should be ordered a keyColumn to order by must be provided.");
        SelectBuilder.SelectWhere builder = this.selectBuilder(keyColumn == null ? Collections.emptyList() : Collections.singleton(keyColumn));
        Table table = this.getTable();
        SelectBuilder.SelectWhereAndOr withWhereClause = builder.where((Condition)table.column(columnName).isEqualTo((Expression)SqlGenerator.getBindMarker(columnName)));
        Select select = ordered ? withWhereClause.orderBy(new Column[]{table.column(keyColumn).as(keyColumn)}).build() : withWhereClause.build();
        return this.render(select);
    }

    String getExists() {
        return (String)this.existsSql.get();
    }

    String getFindOne() {
        return (String)this.findOneSql.get();
    }

    String getInsert(Set<String> additionalColumns) {
        return this.createInsertSql(additionalColumns);
    }

    String getUpdate() {
        return (String)this.updateSql.get();
    }

    String getCount() {
        return (String)this.countSql.get();
    }

    String getDeleteById() {
        return (String)this.deleteByIdSql.get();
    }

    String getDeleteByList() {
        return (String)this.deleteByListSql.get();
    }

    String createDeleteAllSql(@Nullable PersistentPropertyPath<RelationalPersistentProperty> path) {
        Table table = this.getTable();
        DeleteBuilder.DeleteWhere deleteAll = Delete.builder().from(table);
        if (path == null) {
            return this.render(deleteAll.build());
        }
        return this.createDeleteByPathAndCriteria(new PersistentPropertyPathExtension(this.mappingContext, path), Column::isNotNull);
    }

    String createDeleteByPath(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.createDeleteByPathAndCriteria(new PersistentPropertyPathExtension(this.mappingContext, path), filterColumn -> filterColumn.isEqualTo((Expression)SqlGenerator.getBindMarker("rootId")));
    }

    private String createFindOneSql() {
        Select select = this.selectBuilder().where((Condition)this.getIdColumn().isEqualTo((Expression)SqlGenerator.getBindMarker("id"))).build();
        return this.render(select);
    }

    private String createFindAllSql() {
        return this.render(this.selectBuilder().build());
    }

    private SelectBuilder.SelectWhere selectBuilder() {
        return this.selectBuilder(Collections.emptyList());
    }

    private SelectBuilder.SelectWhere selectBuilder(Collection<String> keyColumns) {
        Table table = this.getTable();
        ArrayList<Column> columnExpressions = new ArrayList<Column>();
        ArrayList<Join> joinTables = new ArrayList<Join>();
        for (PersistentPropertyPath path : this.mappingContext.findPersistentPropertyPaths(this.entity.getType(), p -> true)) {
            Column column;
            PersistentPropertyPathExtension extPath = new PersistentPropertyPathExtension(this.mappingContext, (PersistentPropertyPath<RelationalPersistentProperty>)path);
            Join join = this.getJoin(extPath);
            if (join != null) {
                joinTables.add(join);
            }
            if ((column = this.getColumn(extPath)) == null) continue;
            columnExpressions.add(column);
        }
        for (String keyColumn : keyColumns) {
            columnExpressions.add(table.column(keyColumn).as(keyColumn));
        }
        SelectBuilder.SelectAndFrom selectBuilder = StatementBuilder.select(columnExpressions);
        SelectBuilder.SelectFromAndJoin baseSelect = selectBuilder.from(table);
        for (Join join : joinTables) {
            baseSelect = baseSelect.leftOuterJoin(join.joinTable).on((Expression)join.joinColumn).equals((Expression)join.parentId);
        }
        return (SelectBuilder.SelectWhere)baseSelect;
    }

    @Nullable
    Column getColumn(PersistentPropertyPathExtension path) {
        if (path.isEmbedded() || path.getParentPath().isMultiValued()) {
            return null;
        }
        if (path.isEntity()) {
            if (path.isQualified() || path.isCollectionLike() || path.hasIdProperty()) {
                return null;
            }
            return this.sqlContext.getReverseColumn(path);
        }
        return this.sqlContext.getColumn(path);
    }

    @Nullable
    Join getJoin(PersistentPropertyPathExtension path) {
        if (!path.isEntity() || path.isEmbedded() || path.isMultiValued()) {
            return null;
        }
        Table currentTable = this.sqlContext.getTable(path);
        PersistentPropertyPathExtension idDefiningParentPath = path.getIdDefiningParentPath();
        Table parentTable = this.sqlContext.getTable(idDefiningParentPath);
        return new Join(currentTable, currentTable.column(path.getReverseColumnName()), parentTable.column(idDefiningParentPath.getIdColumnName()));
    }

    private String createFindAllInListSql() {
        Select select = this.selectBuilder().where((Condition)this.getIdColumn().in(new Expression[]{SqlGenerator.getBindMarker("ids")})).build();
        return this.render(select);
    }

    private String createExistsSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{this.getIdColumn()})).from(table).where((Condition)this.getIdColumn().isEqualTo((Expression)SqlGenerator.getBindMarker("id"))).build();
        return this.render(select);
    }

    private String createCountSql() {
        Table table = this.getTable();
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from(table).build();
        return this.render(select);
    }

    private String createInsertSql(Set<String> additionalColumns) {
        Table table = this.getTable();
        LinkedHashSet<String> columnNamesForInsert = new LinkedHashSet<String>(this.columns.getInsertableColumns());
        columnNamesForInsert.addAll(additionalColumns);
        InsertBuilder.InsertIntoColumnsAndValuesWithBuild insert = Insert.builder().into(table);
        for (String cn : columnNamesForInsert) {
            insert = insert.column(table.column(cn));
        }
        InsertBuilder.InsertValuesWithBuild insertWithValues = null;
        for (String cn : columnNamesForInsert) {
            insertWithValues = ((InsertBuilder.InsertValues)(insertWithValues == null ? insert : insertWithValues)).values(new Expression[]{SqlGenerator.getBindMarker(cn)});
        }
        return this.render(insertWithValues == null ? insert.build() : insertWithValues.build());
    }

    private String createUpdateSql() {
        Table table = this.getTable();
        List assignments = this.columns.getUpdateableColumns().stream().map(columnName -> Assignments.value((Column)table.column(columnName), (Expression)SqlGenerator.getBindMarker(columnName))).collect(Collectors.toList());
        Update update = Update.builder().table(table).set(assignments).where((Condition)this.getIdColumn().isEqualTo((Expression)SqlGenerator.getBindMarker(this.entity.getIdColumn()))).build();
        return this.render(update);
    }

    private String createDeleteSql() {
        Table table = this.getTable();
        Delete delete = Delete.builder().from(table).where((Condition)this.getIdColumn().isEqualTo((Expression)SQL.bindMarker((String)":id"))).build();
        return this.render(delete);
    }

    private String createDeleteByPathAndCriteria(PersistentPropertyPathExtension path, Function<Column, Condition> rootCondition) {
        Delete delete;
        Table table = SQL.table((String)path.getTableName());
        DeleteBuilder.DeleteWhere builder = Delete.builder().from(table);
        Column filterColumn = table.column(path.getReverseColumnName());
        if (path.getLength() == 1) {
            delete = builder.where(rootCondition.apply(filterColumn)).build();
        } else {
            Condition condition = SqlGenerator.getSubselectCondition(path, rootCondition, filterColumn);
            delete = builder.where(condition).build();
        }
        return this.render(delete);
    }

    private static Condition getSubselectCondition(PersistentPropertyPathExtension path, Function<Column, Condition> rootCondition, Column filterColumn) {
        PersistentPropertyPathExtension parentPath = path.getParentPath();
        Table subSelectTable = SQL.table((String)parentPath.getTableName());
        Column idColumn = subSelectTable.column(parentPath.getIdColumnName());
        Column selectFilterColumn = subSelectTable.column(parentPath.getEffectiveIdColumnName());
        Condition innerCondition = parentPath.getLength() == 1 ? rootCondition.apply(selectFilterColumn) : SqlGenerator.getSubselectCondition(parentPath, rootCondition, selectFilterColumn);
        Select select = Select.builder().select((Expression)idColumn).from(subSelectTable).where(innerCondition).build();
        return filterColumn.in(select);
    }

    private String createDeleteByListSql() {
        Table table = this.getTable();
        Delete delete = Delete.builder().from(table).where((Condition)this.getIdColumn().in(new Expression[]{SqlGenerator.getBindMarker("ids")})).build();
        return this.render(delete);
    }

    private String render(Select select) {
        return SqlRenderer.create().render(select);
    }

    private String render(Insert insert) {
        return SqlRenderer.create().render(insert);
    }

    private String render(Update update) {
        return SqlRenderer.create().render(update);
    }

    private String render(Delete delete) {
        return SqlRenderer.create().render(delete);
    }

    private Table getTable() {
        return this.sqlContext.getTable();
    }

    private Column getIdColumn() {
        return this.sqlContext.getIdColumn();
    }

    private static BindMarker getBindMarker(String columnName) {
        return SQL.bindMarker((String)(":" + parameterPattern.matcher(columnName).replaceAll("")));
    }

    static class Columns {
        private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        private final List<String> columnNames = new ArrayList<String>();
        private final List<String> idColumnNames = new ArrayList<String>();
        private final List<String> nonIdColumnNames = new ArrayList<String>();
        private final Set<String> readOnlyColumnNames = new HashSet<String>();
        private final Set<String> insertableColumns;
        private final Set<String> updateableColumns;

        Columns(RelationalPersistentEntity<?> entity, MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext) {
            this.mappingContext = mappingContext;
            this.populateColumnNameCache(entity, "");
            LinkedHashSet<String> insertable = new LinkedHashSet<String>(this.nonIdColumnNames);
            insertable.removeAll(this.readOnlyColumnNames);
            this.insertableColumns = Collections.unmodifiableSet(insertable);
            LinkedHashSet<String> updateable = new LinkedHashSet<String>(this.columnNames);
            updateable.removeAll(this.idColumnNames);
            updateable.removeAll(this.readOnlyColumnNames);
            this.updateableColumns = Collections.unmodifiableSet(updateable);
        }

        private void populateColumnNameCache(RelationalPersistentEntity<?> entity, String prefix) {
            entity.doWithProperties(property -> {
                if (!property.isEntity()) {
                    this.initSimpleColumnName((RelationalPersistentProperty)property, prefix);
                } else if (property.isEmbedded()) {
                    this.initEmbeddedColumnNames((RelationalPersistentProperty)property, prefix);
                }
            });
        }

        private void initSimpleColumnName(RelationalPersistentProperty property, String prefix) {
            String columnName = prefix + property.getColumnName();
            this.columnNames.add(columnName);
            if (!property.getOwner().isIdProperty((PersistentProperty)property)) {
                this.nonIdColumnNames.add(columnName);
            } else {
                this.idColumnNames.add(columnName);
            }
            if (!property.isWritable() || property.isAnnotationPresent(ReadOnlyProperty.class)) {
                this.readOnlyColumnNames.add(columnName);
            }
        }

        private void initEmbeddedColumnNames(RelationalPersistentProperty property, String prefix) {
            String embeddedPrefix = property.getEmbeddedPrefix();
            RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property.getColumnType());
            this.populateColumnNameCache(embeddedEntity, prefix + embeddedPrefix);
        }

        Set<String> getInsertableColumns() {
            return this.insertableColumns;
        }

        Set<String> getUpdateableColumns() {
            return this.updateableColumns;
        }
    }

    static final class Join {
        private final Table joinTable;
        private final Column joinColumn;
        private final Column parentId;

        public Join(Table joinTable, Column joinColumn, Column parentId) {
            this.joinTable = joinTable;
            this.joinColumn = joinColumn;
            this.parentId = parentId;
        }

        public Table getJoinTable() {
            return this.joinTable;
        }

        public Column getJoinColumn() {
            return this.joinColumn;
        }

        public Column getParentId() {
            return this.parentId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Join)) {
                return false;
            }
            Join other = (Join)o;
            Table this$joinTable = this.getJoinTable();
            Table other$joinTable = other.getJoinTable();
            if (this$joinTable == null ? other$joinTable != null : !this$joinTable.equals(other$joinTable)) {
                return false;
            }
            Column this$joinColumn = this.getJoinColumn();
            Column other$joinColumn = other.getJoinColumn();
            if (this$joinColumn == null ? other$joinColumn != null : !this$joinColumn.equals(other$joinColumn)) {
                return false;
            }
            Column this$parentId = this.getParentId();
            Column other$parentId = other.getParentId();
            return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Table $joinTable = this.getJoinTable();
            result = result * 59 + ($joinTable == null ? 43 : $joinTable.hashCode());
            Column $joinColumn = this.getJoinColumn();
            result = result * 59 + ($joinColumn == null ? 43 : $joinColumn.hashCode());
            Column $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            return result;
        }

        public String toString() {
            return "SqlGenerator.Join(joinTable=" + this.getJoinTable() + ", joinColumn=" + this.getJoinColumn() + ", parentId=" + this.getParentId() + ")";
        }
    }
}

